/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.business.org.OrgService;
import kd.taxc.tpo.business.rule.RuleService;
import kd.taxc.tpo.common.enums.RuleTypeStrategyEnum;

public class RuleCollectTreeListPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private Set<String> ruleFormIdSet = new HashSet<String>(){
        {
            this.add("tcvat_rule_rollout");
            this.add("tcvat_rule_deduct");
            this.add("tcvat_rule_perpre");
            this.add("tcvat_rule_mdts");
        }
    };
    private static final String COPY = "copyrule";
    private static final String TPO_RULE = "tpo_rule";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    public void refreshNode(RefreshNodeEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("parent") != null && customParams.get("parent") instanceof List) {
            List parent = (List)customParams.get("parent");
            this.getTreeModel().getTreeFilter().add(new QFilter("parent", "in", (Object)parent).or(new QFilter("id", "in", (Object)parent)));
        }
        ((TreeListModel)this.getTreeModel()).getQueryParas().put("order", "createtime asc");
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(this.getRootNodeName());
        super.refreshNode(e);
    }

    private String getRootNodeName() {
        return ResManager.loadKDString((String)"\u89c4\u5219\u6c47\u603b", (String)"SbxRuleCollectTreeListPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String operateSource = customParams.getOrDefault("operateSource", "");
        if ("downloadFromBusiness".equals(operateSource)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel"});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        OrgUtils.listFilterByIsTaxpayerAndEnableAndAudit((BeforeFilterF7SelectEvent)args);
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams;
        String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
        if (root.getId().equals(currentNode.getId()) && (customParams = this.getView().getFormShowParameter().getCustomParams()).get("parent") != null && customParams.get("parent") instanceof List) {
            List parent = (List)customParams.get("parent");
            QFilter qFilter = new QFilter("group.parent", "in", (Object)parent).or(new QFilter("id", "in", (Object)parent));
            e.getQFilters().add(qFilter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(String.valueOf(this.getTreeModel().getCurrentNodeId()));
        if (this.getTreeModel().getRoot().getId().equals(currentNode.getId())) {
            return;
        }
        List<IListColumn> customListColumn = RuleTypeStrategyEnum.getStrategyByGroupId(currentNode.getId()).getListColumnByRuleType();
        List listColumns = args.getListColumns();
        listColumns.addAll(6, customListColumn);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Map customParams;
            String operateType;
            String operationKey = ((Donothing)args.getSource()).getOperateKey();
            if (Arrays.asList("download", "viewdownload").contains(operationKey) && "batchdownloadrule".equals(operateType = (customParams = this.getView().getFormShowParameter().getCustomParams()).getOrDefault("operateType", ""))) {
                Long orgId = Long.parseLong(String.valueOf(customParams.getOrDefault("org", 0L)));
                String entity = this.getView().getEntityId();
                List<Long> allPermOrgs = OrgService.getAllPermOrgs("tpo", entity, RuleService.getPermIdByBtnKey(operationKey));
                if (!allPermOrgs.contains(orgId)) {
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u201c%s\u201d\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRuleCollectTreeListPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(msg, ((Donothing)args.getSource()).getOperateName()));
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    private boolean checkBeforeAddRule(Long createOrgId, String ruleType, String formId) {
        boolean isybnsr;
        DynamicObjectCollection list = null;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainZzsByOrgId(Collections.singletonList(createOrgId));
        if (EmptyCheckUtils.isNotEmpty((Object)result.getData()) && EmptyCheckUtils.isNotEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity"))) {
            list = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("categoryentryentity");
        }
        if (this.ruleFormIdSet.contains(formId) && !(isybnsr = RuleService.isybnsr(list, ruleType, false))) {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u201c%1$s\u201c\u975e\u4e00\u822c\u7eb3\u7a0e\u4eba\uff0c\u4e0d\u9002\u7528%2$s\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"SbxRuleCollectTreeListPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), ((DynamicObject)((List)result.getData()).get(0)).getString("orgid.name"), currentNode.getText()));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormShowParameter showParameter;
        ListSelectedRowCollection listSelectedData;
        Object[] primaryKeyValues;
        boolean exists;
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("enable".equals(operateKey) && null != args.getOperationResult() && args.getOperationResult().getAllErrorOrValidateInfo().size() == 0 && (exists = QueryServiceHelper.exists((String)"tcvat_rule_wkpsr", (QFilter[])new QFilter[]{new QFilter("rulename", "in", (Object)(primaryKeyValues = (listSelectedData = operate.getListSelectedData()).getPrimaryKeyValues())), new QFilter("enable", "=", (Object)"0")}))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enable", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u540c\u65f6\u542f\u7528\u5173\u8054\u7684\u672a\u5f00\u7968\u6536\u5165\u53f0\u8d26\u89c4\u5219\uff1f", (String)"SbxRuleCollectTreeListPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
        }
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        if ("addnew".equals(operateKey)) {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            TreeNode root = this.getTreeModel().getRoot();
            TreeNode currentNode = root.getTreeNode(currentNodeId, 100);
            if (root.getId().equals(currentNode.getId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            RuleTypeStrategyEnum ruleTypeStrategyEnum = RuleTypeStrategyEnum.getStrategyByGroupId(currentNodeId);
            String formId = ruleTypeStrategyEnum.getFormId();
            if (StringUtil.isBlank((CharSequence)formId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            baseShowParameter.setFormId(formId);
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            baseShowParameter.setStatus(OperationStatus.ADDNEW);
            baseShowParameter.setCustomParam("operateType", (Object)"addSysRule");
            baseShowParameter.getShowParameter().getCustomParams().put("ruletype", operateKey);
            baseShowParameter.setCustomParam("groupId", (Object)ruleTypeStrategyEnum.getGroupId());
            Long createOrgId = RuleService.getCreateOrgId(this.getSelectedMainOrgIds());
            baseShowParameter.getShowParameter().getCustomParams().put("createorg", createOrgId);
            if (createOrgId.compareTo(0L) != 0 && !this.checkBeforeAddRule(createOrgId, operateKey, formId)) {
                return;
            }
            baseShowParameter.setCustomParam("ruletype", (Object)"private");
            baseShowParameter.setCustomParam("type", (Object)ruleTypeStrategyEnum.getRuleNumber());
            this.getView().showForm((FormShowParameter)baseShowParameter);
            return;
        }
        if ("download".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData2 = operate.getListSelectedData();
            Object[] primaryKeyValues2 = listSelectedData2.getPrimaryKeyValues();
            List ruleList = Arrays.stream(primaryKeyValues2).map(s -> (Long)s).collect(Collectors.toList());
            showParameter = new FormShowParameter();
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "downloadConfirm");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCustomParam("rule", (Object)SerializationUtils.toJsonString(ruleList));
            showParameter.setFormId("tpo_download_confirm");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
        if ("viewdownload".equals(operateKey)) {
            ListShowParameter showParameter2 = new ListShowParameter();
            showParameter2.setShowFilter(false);
            showParameter2.setShowQuickFilter(false);
            showParameter2.setBillFormId("tpo_download_history");
            showParameter2.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter2);
        }
        if (COPY.equals(operateKey)) {
            primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues.length != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AbstractRuleCollectTreeListPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            DynamicObject ruleObject = QueryServiceHelper.queryOne((String)TPO_RULE, (String)"name,group,ruledetail_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValues[0])});
            String formId = RuleTypeStrategyEnum.getStrategyByGroupId(ruleObject.getString("group")).getFormId();
            if (StringUtil.isBlank((CharSequence)formId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u89c4\u5219\u5206\u7ec4\u5b50\u8282\u70b9\u3002", (String)"AbstractRuleCollectTreeListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            showParameter = new BillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setPkId(primaryKeyValues[0]);
            showParameter.setCustomParam("operateSource", (Object)TPO_RULE);
            showParameter.getShowParameter().getCustomParams().put("iscopy", Boolean.TRUE);
            showParameter.setCustomParam("ruledetail", (Object)ruleObject.getString("ruledetail_tag"));
            showParameter.setCustomParam("groupId", (Object)ruleObject.getString("group"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm(showParameter);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        Object[] primaryKeyValues;
        DynamicObject[] wkpsrRule;
        List<Long> wkpsrId;
        OperationResult resultesult;
        String callBackId = evt.getCallBackId();
        if ("enable".equals(callBackId) && MessageBoxResult.Yes == evt.getResult() && (resultesult = OperationServiceHelper.executeOperate((String)"enable", (String)"tcvat_rule_wkpsr", (Object[])(wkpsrId = Arrays.stream(wkpsrRule = BusinessDataServiceHelper.load((String)"tcvat_rule_wkpsr", (String)"id,enable", (QFilter[])new QFilter[]{new QFilter("rulename", "in", (Object)(primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues())), new QFilter("enable", "=", (Object)"0")})).map(w -> w.getLong("id")).collect(Collectors.toList())).toArray(new Long[0]), (OperateOption)OperateOption.create())).isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672a\u5f00\u7968\u6536\u5165\u89c4\u5219\u542f\u7528\u6210\u529f\u3002", (String)"SbxRuleCollectTreeListPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if ("downloadConfirm".equals(action)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (null == returnData) {
                return;
            }
            this.showPrompt(String.valueOf(returnData));
        }
    }

    private void showPrompt(String string) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tcret_cjfcyzft_prompt");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("prompt", (Object)string);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7ed3\u679c\u63d0\u793a", (String)"SbxRuleCollectTreeListPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkid = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String operateSource = customParams.getOrDefault("operateSource", "");
        DynamicObject ruleObject = QueryServiceHelper.queryOne((String)TPO_RULE, (String)"number,group,issystem,ruledetail_tag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
        if ("dowloadhistory".equals(args.getFieldName())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.setBillFormId("tpo_download_history");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("ruleNumber", (Object)ruleObject.getString("number"));
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
        String group = ruleObject.getString("group");
        String formId = RuleTypeStrategyEnum.getStrategyByGroupId(group).getFormId();
        if (StringUtil.isBlank((CharSequence)formId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"ID\u4e3a\u201c%s\u201d\u7684FormId\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AbstractRuleCollectTreeListPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]));
            return;
        }
        String issystem = ruleObject.getString("issystem");
        String ruledetail = ruleObject.getString("ruledetail_tag");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pkid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("ruledetail", (Object)ruledetail);
        if (StringUtil.isNotBlank((CharSequence)operateSource)) {
            showParameter.setCustomParam("operateSource", (Object)operateSource);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

