/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.rule;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tpo.business.rule.RuleService;

public class RuleDownloadConfirm
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_BTNOK = "btnok";
    private static final String ID = "id";
    private static final String ORG = "org";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BTNCANCEL, KEY_BTNOK});
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTNOK.equalsIgnoreCase(key)) {
            MulBasedataDynamicObjectCollection orgs = (MulBasedataDynamicObjectCollection)this.getModel().getValue(ORG);
            if (CollectionUtils.isEmpty((Collection)orgs)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"RuleDownloadConfirm_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            List<Long> selectOrgList = orgs.stream().map(m -> m.getDynamicObject("fbasedataid").getLong(ID)).collect(Collectors.toList());
            String ruleType = (String)this.getModel().getValue("ruletype");
            if (StringUtil.isBlank((CharSequence)ruleType)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89c4\u5219\u7c7b\u578b\u3002", (String)"RuleDownloadConfirm_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            String ruleStr = customParams.getOrDefault("rule", "");
            List ruleList = SerializationUtils.fromJsonStringToList((String)ruleStr, Long.class);
            String downloadResult = "";
            downloadResult = RuleService.downloadRule(ruleList, selectOrgList, ruleType);
            this.getView().returnDataToParent((Object)downloadResult);
            this.getView().close();
        }
        if (KEY_BTNCANCEL.equalsIgnoreCase(key)) {
            this.getView().close();
        }
    }

    private void saveData(String formId, Long groupId, DynamicObject obj) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_all_rule_config");
        BeanCopyUtils.copyDynamicObjectWithoutEntity((DynamicObject)obj, (DynamicObject)dynamicObject);
        if (null == dynamicObject.getString("issystem")) {
            dynamicObject.set("issystem", (Object)"0");
        }
        dynamicObject.set("group", (Object)groupId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        long userId = RequestContext.get().getCurrUserId();
        String appid = this.getView().getFormShowParameter().getAppId();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdByIsTaxpayerWithPerm((Long)userId, (String)appid, (String)"tpo_rule", (String)"45H/O1=4C4D7");
        if (taxResult.isSuccess()) {
            List orgList = (List)taxResult.getData();
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter(ID, "in", (Object)orgList));
        }
    }
}

