/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.softwareprofitmap;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class SoftwareProfitMappingValidator
extends AbstractValidator {
    public static final String ENTITY = "tpo_software_profit_map";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            Date start = currentObj.getDate(STARTDATE);
            Date end = currentObj.getDate(ENDDATE);
            long id = currentObj.getLong("id");
            if (end != null && !end.after(start)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u5f97\u65e9\u4e8e\u6709\u6548\u671f\u8d77", (String)"SoftwareProfitMappingValidator_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection existDatas = QueryServiceHelper.query((String)ENTITY, (String)"id,startdate,enddate", null);
            if (!CollectionUtils.isNotEmpty((Collection)existDatas)) continue;
            for (DynamicObject dyo : existDatas) {
                if (dyo.getLong("id") == id || DateUtils.checkTimeRepeat((Date)start, (Date)end, (Date)dyo.getDate(STARTDATE), (Date)dyo.getDate(ENDDATE))) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u8d77\u6b62\u671f\u95f4\u5df2\u5b58\u5728\u751f\u6548\u7684\u8f6f\u4ef6\u96c6\u6210\u7535\u8def\u4f18\u60e0\u6620\u5c04\u6570\u636e\u8868", (String)"SoftwareProfitMappingValidator_1", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
        }
    }
}

