/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.szys;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.tpo.common.utils.EndDateUpdateUtil;

public class SzysBizDefEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    private static final String SUB_NUMBER = "subnumber";
    private static final String PROJECT_NAME = "projectname";
    private static final String PARENTID = "parent.id";
    private static final String LEVEL = "level";
    private static final String ISLEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String SUPER_ROOT = "0";
    private static final String TREEENTRYENTITY = "entry_detail";
    private static final String ENTRYNAME = "entryname";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit parentid = (BasedataEdit)this.getView().getControl("parent");
        parentid.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            EndDateUpdateUtil.doUpdateEndDate(this.getModel().getEntryEntity(TREEENTRYENTITY), "expired");
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (event.getFieldName().equals("setting")) {
            this.openSettingPage("tctb_tax_main", "filtername");
        }
    }

    protected void openSettingPage(String filterpage, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tpo_tcvat_assist_setting");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityNumber", (Object)filterpage);
        EntryGrid subtable = (EntryGrid)this.getControl(TREEENTRYENTITY);
        int focusRow = subtable.getEntryState().getFocusRow();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, focusRow);
        formshowParameter.setCustomParam("sdfasdfasdfasd", selectedRow.get("filter"));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        if ("filtername".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
            this.getModel().setValue("description", filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue("filter", filterData.get("filtervalue"), currentRowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("parent".equals(beforeF7SelectEvent.getProperty().getName())) {
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("orgid", (Object)RequestContext.get().getOrgId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map<String, Map<String, String>> map;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && !ObjectUtils.isEmpty(map = this.getTreeMap())) {
            try {
                this.updateTreeEntity(map);
            }
            catch (KDBizException e) {
                args.setCancel(true);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equalsIgnoreCase((CharSequence)PROJECT_NAME, (CharSequence)e.getProperty().getName())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
            DynamicObject focusRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, entryGrid.getEntryState().getFocusRow());
            focusRow.set(ENTRYNAME, focusRow.get(PROJECT_NAME));
            focusRow.set(FULLNAME, focusRow.get(PROJECT_NAME));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SUB_NUMBER, (CharSequence)e.getProperty().getName())) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(TREEENTRYENTITY);
            DynamicObject focusRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, entryGrid.getEntryState().getFocusRow());
            focusRow.set(LONGNUMBER, focusRow.get(SUB_NUMBER));
        }
    }

    private void updateTreeEntity(Map<String, Map<String, String>> map) {
        List<String> noLeafList = this.getNoLeafList(map);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            String parentId = treeNote.getString(PARENTID);
            String id = treeNote.getString("id");
            if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                treeNote.set(LONGNUMBER, (Object)StringUtils.join((Object[])this.getLongValue(id, map, SUB_NUMBER).toArray(), (String)"."));
                treeNote.set(FULLNAME, (Object)StringUtils.join((Object[])this.getLongValue(id, map, PROJECT_NAME).toArray(), (String)"."));
                treeNote.set(ENTRYNAME, (Object)treeNote.getString(PROJECT_NAME));
                treeNote.set(LEVEL, (Object)this.getLevel(id, map));
            }
            treeNote.set(ISLEAF, (Object)(!noLeafList.contains(subnumber) ? 1 : 0));
        }
    }

    private Map<String, Map<String, String>> getTreeMap() {
        HashMap<String, Map<String, String>> treesMap = new HashMap<String, Map<String, String>>(10);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString("id");
            if (treesMap.containsKey(subnumber)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(SUB_NUMBER, treeNote.getString(SUB_NUMBER));
            node.put(PROJECT_NAME, treeNote.getString(PROJECT_NAME));
            node.put(LEVEL, treeNote.getString(LEVEL));
            node.put(PARENTID, treeNote.getString(PARENTID));
            treesMap.put(subnumber, node);
        }
        return treesMap;
    }

    private List<String> getLongValue(String subNumber, Map<String, Map<String, String>> treeMap, String type) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> node = treeMap.get(subNumber);
        if (!ObjectUtils.isEmpty(node)) {
            String parentId = node.get(PARENTID);
            if (!ObjectUtils.isEmpty((Object)parentId) || !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                try {
                    list.addAll(this.getLongValue(parentId, treeMap, type));
                }
                catch (StackOverflowError e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7236\u7ea7ID\u5b58\u5728\u5faa\u73af\u5f15\u7528", (String)"SzysBizDefEdit_0", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            }
            list.add(node.get(type));
        }
        return list;
    }

    private int getLevel(String subNumber, Map<String, Map<String, String>> treeMap) {
        int level = 1;
        Map<String, String> node = treeMap.get(subNumber);
        if (null == node) {
            return level;
        }
        String parentId = node.get(PARENTID);
        if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
            level += this.getLevel(parentId, treeMap);
        }
        return level;
    }

    private List<String> getNoLeafList(Map<String, Map<String, String>> map) {
        ArrayList<String> list = new ArrayList<String>();
        map.forEach((key, value) -> {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)value.get(PARENTID)), (CharSequence)SUPER_ROOT)) {
                list.add((String)value.get(PARENTID));
            }
        });
        return list;
    }
}

