/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.szys;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.IListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SzysBizDefEntryList
extends AbstractListPlugin
implements FilterContainerInitListener {
    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String caption = (String)e.getFormShowParameter().getCustomParam("caption");
        if (StringUtil.isNotBlank((CharSequence)caption)) {
            e.getFormShowParameter().setCaption(caption);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){
            Map<String, Object> customParams;
            Object orgid;
            {
                this.customParams = SzysBizDefEntryList.this.getView().getFormShowParameter().getCustomParams();
                this.orgid = this.customParams.get("orgid");
            }

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicObjectType dot = data.getDynamicObjectType();
                DynamicSimpleProperty status = new DynamicSimpleProperty("status", String.class, (Object)"");
                dot.addProperty((DynamicProperty)status);
                data.removeIf(d -> {
                    String filter = d.getString("filter");
                    if (StringUtil.isNotBlank((CharSequence)filter)) {
                        QFilter q1 = FilterBuilderUtils.buildFilter((String)filter, (String)"tctb_tax_main");
                        QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
                        if (this.orgid != null) {
                            q1 = q1.and(new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(this.orgid))));
                        }
                        return !QueryServiceHelper.exists((String)"tctb_tax_main", (QFilter[])new QFilter[]{q1, taxationsys});
                    }
                    return false;
                });
                return data;
            }
        });
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String menu = (String)this.getView().getFormShowParameter().getCustomParam("menu");
        if (!"watersource".equals(menu)) {
            List listColumns = args.getListColumns();
            List collect = listColumns.stream().filter(c -> !"validfrom".equals(c.getListFieldKey()) && !"expired".equals(c.getListFieldKey()) && !"value".equals(c.getListFieldKey())).collect(Collectors.toList());
            args.setListColumns(collect);
        } else {
            List listColumns = args.getListColumns();
            List collect = listColumns.stream().filter(c -> !"enable".equals(c.getListFieldKey())).collect(Collectors.toList());
            for (IListColumn iListColumn : collect) {
                if (iListColumn.getListFieldKey().equals("projectname")) {
                    iListColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"SzysBizDefEntryList_0", (String)"taxc-tpo", (Object[])new Object[0])));
                    continue;
                }
                if (!iListColumn.getListFieldKey().equals("value")) continue;
                iListColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9002\u7528\u7a0e\u989d", (String)"SzysBizDefEntryList_1", (String)"taxc-tpo", (Object[])new Object[0])));
            }
            args.setListColumns(collect);
        }
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        String menu = (String)this.getView().getFormShowParameter().getCustomParam("menu");
        List fastFilterColumns = evt.getFastFilterColumns();
        for (FilterColumn filterColumn : fastFilterColumns) {
            if (!"watersource".equals(menu) || !filterColumn.getFieldName().equals("projectname")) continue;
            filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5f81\u6536\u5b50\u76ee", (String)"SzysBizDefEntryList_0", (String)"taxc-tpo", (Object[])new Object[0])));
            break;
        }
    }
}

