/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.tax;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxOrganSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    Date start = currentObj.getDate("start");
                    Date end = currentObj.getDate("end");
                    boolean isEffective = false;
                    if (null != end && start.after(end)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4.", (String)"TaxOrganSaveOp_0", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    boolean endTimeIsNull = false;
                    if (null == end) {
                        endTimeIsNull = true;
                    }
                    Object id = currentObj.get("id");
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)currentObj.getDataEntityType().getExtendName(), (String)"id,start,end", (QFilter[])new QFilter[0]);
                    for (DynamicObject exist : colls) {
                        if (id.equals(exist.get("id"))) continue;
                        Date existStart = exist.getDate("start");
                        Date existEnd = exist.getDate("end");
                        if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                            isEffective = true;
                            break;
                        }
                        if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
                        isEffective = true;
                        break;
                    }
                    if (isEffective) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u65f6\u95f4\u6bb5\u5df2\u7ecf\u6709\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u6709\u6548\u671f\u8d77\u3001\u6b62\u65e5\u671f.", (String)"TaxOrganSaveOp_1", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObjectCollection subColls = currentObj.getDynamicObjectCollection("subtable");
                    for (DynamicObject dynamicObject : subColls) {
                        dynamicObject.set("enablecopy", (Object)"1");
                        dynamicObject.set("statuscopy", (Object)"C");
                        dynamicObject.set("startcopy", (Object)start);
                        dynamicObject.set("endcopy", (Object)(endTimeIsNull ? null : end));
                    }
                }
            }
        });
    }
}

