/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.tctf.article;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ArticleListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ArticleListPlugin.class);
    public static final String BASE_PATH = System.getProperty("user.home") + File.separator + "article" + File.separator;

    public void filterColumnSetFilter(SetFilterEvent args) {
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        if ("organ.fbasedataid.name".equals(fieldName)) {
            QFilter qFilter = new QFilter("tag.number", "=", (Object)"issuingauthority_s").and("enable", "=", (Object)true);
            DynamicObjectCollection treeTag = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,number,tag.number", (QFilter[])qFilter.toArray());
            List numbers = treeTag.stream().map(m -> m.getString("number")).distinct().collect(Collectors.toList());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
            QFilter numberFilter = null;
            for (int i = 0; i < numbers.size(); ++i) {
                String number = (String)numbers.get(i);
                QFilter filter = new QFilter("longnumber", "like", (Object)(number + ".%")).or("longnumber", "like", (Object)("%." + number)).or("longnumber", "like", (Object)("%." + number + ".%"));
                numberFilter = numberFilter == null ? filter : numberFilter.or(filter);
                if (i != numbers.size() - 1) continue;
                qFilters.add(numberFilter);
            }
            qFilters.add(new QFilter("enable", "=", (Object)true));
            filters.addAll(qFilters);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        if ("download".equalsIgnoreCase(operateKey)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billlist.getSelectedRows();
            List ids = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tpo_tax_article", (String)MetadataUtil.getAllFieldToQuery((String)"tpo_tax_article"), (QFilter[])filter.toArray());
            if (load.length > 20) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5927\u540c\u65f6\u4e0b\u8f7d\u91cf\u4e3a20\u6761\u6570\u636e\u3002", (String)"ArticleListPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                return;
            }
            String seqNo = String.valueOf(System.currentTimeMillis());
            String uuidBasePath = BASE_PATH + seqNo + File.separator;
            this.saveDyoFiles(load, uuidBasePath);
            this.downloadZip(seqNo, uuidBasePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadZip(String seqNo, String uuidBasePath) {
        String format = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        String zipFilePath = FilenameUtils.normalize((String)(BASE_PATH + seqNo + ".zip"));
        String fileName = String.format(ResManager.loadKDString((String)"\u6570\u636e_%s", (String)"ArticleListPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), format);
        FileInputStream fileInputStream = null;
        try {
            ArticleListPlugin.zipFolder(uuidBasePath, zipFilePath);
            File zipFile = new File(zipFilePath);
            fileInputStream = new FileInputStream(zipFile);
            String sqlurl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".zip", (InputStream)fileInputStream, 5000);
            sqlurl = this.downControlByurls(sqlurl);
            this.getView().download(sqlurl);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fazip\u5931\u8d25{}", (Object)e.getMessage());
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                FileUtils.delete((File)new File(zipFilePath));
                FileUtils.deleteDirectory((File)new File(FilenameUtils.normalize((String)uuidBasePath)));
            }
            catch (IOException e) {
                logger.error("\u5220\u9664\u6570\u636e\u5931\u8d25{}", (Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDyoFiles(DynamicObject[] load, String uuidBasePath) {
        for (DynamicObject dyo : load) {
            String richTextEditor = dyo.getString("largetext_tag");
            String text = "<html>" + richTextEditor + "</html>";
            String billno = dyo.getString("billno");
            List attachments = AttachmentServiceHelper.getAttachments((String)"tpo_tax_article", (Object)dyo.getLong("id"), (String)"attachmentpanel");
            byte[] buf = text.getBytes(Charset.forName("GBK"));
            FileOutputStream fout = null;
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf);
                 POIFSFileSystem poifsFileSystem = new POIFSFileSystem();){
                File file = new File(FilenameUtils.normalize((String)(uuidBasePath + billno + ".doc")));
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                }
                fout = new FileOutputStream(file);
                DirectoryNode directoryEntry = poifsFileSystem.getRoot();
                directoryEntry.createDocument("WordDocument", (InputStream)byteArrayInputStream);
                poifsFileSystem.writeFilesystem((OutputStream)fout);
            }
            catch (Exception e) {
                logger.info("\u4e0b\u8f7d\u6b63\u6587\u5931\u8d25{}", (Object)e.getMessage());
            }
            finally {
                try {
                    if (fout != null) {
                        fout.close();
                    }
                }
                catch (IOException iOException) {}
            }
            this.saveAttach(uuidBasePath, billno, attachments);
        }
    }

    private void saveAttach(String uuidBasePath, String number, List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        try {
            String dirName = String.format(ResManager.loadKDString((String)"%s_\u9644\u4ef6", (String)"ArticleListPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), number);
            File dirFile = new File(FilenameUtils.normalize((String)(uuidBasePath + dirName + File.separator)));
            if (!dirFile.exists()) {
                dirFile.getParentFile().mkdirs();
            }
            for (Map<String, Object> map : list) {
                String name = String.valueOf(map.get("name"));
                String url = String.valueOf(map.get("url"));
                File aatachFile = new File(FilenameUtils.normalize((String)(uuidBasePath + dirName + File.separator + name)));
                if (!dirFile.exists()) {
                    aatachFile.getParentFile().mkdirs();
                }
                FileOutputStream attachOut = new FileOutputStream(aatachFile);
                byte[] buffer = new byte[512];
                int readLength = 0;
                try (InputStream inputStream = ArticleListPlugin.getInputStreamByFileService(url);){
                    while ((readLength = inputStream.read(buffer, 0, 512)) != -1) {
                        attachOut.write(buffer, 0, readLength);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                attachOut.close();
            }
        }
        catch (IOException e) {
            logger.info("\u4e0b\u8f7d\u9644\u4ef6\u5931\u8d25");
        }
    }

    public static InputStream getInputStreamByFileService(String url) {
        if ((url = url.replace(UrlService.getDomainContextUrl(), "")).contains("tempfile")) {
            TempFileCache tfc = CacheFactory.getCommonCacheFactory().getTempFileCache();
            return tfc.getInputStream(url);
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        String[] urlParam = url.split("path=/");
        String filePath = urlParam[1];
        if (filePath.contains("&")) {
            String[] split = filePath.split("&");
            filePath = split[0];
        }
        return attachmentFileService.getInputStream(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolder(String folderPath, String zipFilePath) throws IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(zipFilePath);
            zos = new ZipOutputStream(fos);
            ArticleListPlugin.addFolderToZip("", new File(FilenameUtils.normalize((String)folderPath)), zos);
        }
        finally {
            if (zos != null) {
                zos.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFolderToZip(String parentPath, File folder, ZipOutputStream zos) throws IOException {
        for (File file : Objects.requireNonNull(folder.listFiles())) {
            if (file.isDirectory()) {
                ArticleListPlugin.addFolderToZip("" + folder.getName() + File.separator, file, zos);
                continue;
            }
            try (FileInputStream fis = null;){
                int length;
                fis = new FileInputStream(file);
                String path = folder.getName() + File.separator + file.getName();
                if (path.contains("\\")) {
                    path = path.replace("\\", File.separator);
                }
                ZipEntry zipEntry = new ZipEntry(path);
                zos.putNextEntry(zipEntry);
                byte[] bytes = new byte[1024];
                while ((length = fis.read(bytes)) >= 0) {
                    zos.write(bytes, 0, length);
                }
            }
        }
    }

    private String downControlByurls(String url) {
        String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
        String entityNum = ((IListView)this.getView()).getBillFormId();
        PermissionUtils.putTempFilePermissionCache((String)url, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000007ae");
        return url;
    }
}

