/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.tctf.article;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ArticleLookPlugin
extends AbstractFormPlugin {
    private static final String TEXT = "text";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";

    public void afterCreateNewData(EventObject e) {
        this.setQuickLookValue();
    }

    private void setQuickLookValue() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        String texttitle = (String)customParams.get("texttitle");
        Date releasedate = DateUtils.stringToDate2((String)((String)customParams.get("releasedate")), (String)"yyyy-MM-dd");
        String issuednum = (String)customParams.get("issuednum");
        List organIds = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(customParams.get("organIds")), Long.class);
        List totaltagIds = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(customParams.get("totaltagIds")), Long.class);
        String editText = (String)customParams.get("editText");
        this.getModel().setValue("texttitle", (Object)texttitle);
        this.getModel().setValue("titleshow", (Object)texttitle);
        this.getModel().setValue("releasedate", (Object)releasedate);
        this.getModel().setValue("issuednum", (Object)issuednum);
        this.setMulDatabase("organ", organIds);
        this.setMulDatabase("totaltags", totaltagIds);
        RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
        edit.setText(editText);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        AttachmentPanel parentPanel = (AttachmentPanel)parentView.getControl(ATTACHMENT_PANEL);
        if (parentPanel == null) {
            return;
        }
        List list = parentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
            attachmentPanel.upload(list);
        }
        this.getModel().setDataChanged(false);
    }

    private void setMulDatabase(String key, List<Long> tagIds) {
        if (CollectionUtils.isEmpty(tagIds)) {
            return;
        }
        MulBasedataDynamicObjectCollection totaltags = (MulBasedataDynamicObjectCollection)this.getModel().getValue(key);
        totaltags.clear();
        ArrayList<Long> idList = new ArrayList<Long>(tagIds);
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] treeTags = BusinessDataServiceHelper.load((String)"tpo_tree_tag", (String)MetadataUtil.getAllFieldToQuery((String)"tpo_tree_tag"), (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> map = Arrays.stream(treeTags).collect(Collectors.groupingBy(r -> r.getLong("id")));
        if (CollectionUtils.isNotEmpty(tagIds)) {
            for (Long id : idList) {
                DynamicObject dynamicObject = totaltags.addNew();
                List objects = map.getOrDefault(id, new ArrayList());
                if (objects.size() != 1) continue;
                DynamicObject object = (DynamicObject)objects.get(0);
                dynamicObject.set("fbasedataid", (Object)object);
                dynamicObject.set("fbasedataid_id", (Object)id);
            }
        }
        this.getView().updateView(key);
    }
}

