/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.tctf.article;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.common.enums.ArticleFieldTagEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ArticlePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String LARGETEXT_TAG = "largetext_tag";
    private static final String TEXT = "text";
    private static final String QUICK_LOOK = "quicklook";

    public void registerListener(EventObject e) {
        List<String> keys = Arrays.asList("filetypes", "taxtypes", "areas", "industries", "others", "influences", "organ");
        for (String key : keys) {
            MulBasedataEdit control = (MulBasedataEdit)this.getView().getControl(key);
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        List<Object> tagRootNumbers = new ArrayList(8);
        List<String> keys = Arrays.asList("filetypes", "taxtypes", "areas", "industries", "others", "influences", "organ");
        String name = null;
        if (keys.contains(fieldKey)) {
            ArticleFieldTagEnum articleFieldEnum = ArticleFieldTagEnum.getEnumMetaByFieldKey(fieldKey);
            if (articleFieldEnum != null) {
                name = articleFieldEnum.getDesc().loadKDString();
                tagRootNumbers = articleFieldEnum.getTagRootNumbers();
            }
            QFilter qFilter = new QFilter("tag.number", "in", tagRootNumbers).and("enable", "=", (Object)true).and("isleaf", "=", (Object)false);
            DynamicObjectCollection treeTag = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,number,tag.number", (QFilter[])qFilter.toArray());
            List<Long> ids = treeTag.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
            HashSet childIds = new HashSet(8);
            if (CollectionUtils.isNotEmpty(ids)) {
                DynamicObjectCollection allTags = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,name,number,parent", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
                ids.forEach(id -> this.getChildIdsIncludeSelf((Long)id, (List<DynamicObject>)allTags, childIds));
            }
            qFilters.add(new QFilter("enable", "=", (Object)true));
            qFilters.add(new QFilter("id", "in", childIds));
            qFilters.add(new QFilter("showtypies", "like", (Object)"%,article,%"));
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("isleaf", "=", (Object)true));
            formShowParameter.getTreeFilterParameter().getQFilters().addAll(qFilters);
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                formShowParameter.setCaption(name);
            }
        }
    }

    private void getChildIdsIncludeSelf(Long parentId, List<DynamicObject> allTags, Set<Long> childIdsIncludeSelf) {
        if (CollectionUtils.isEmpty(allTags)) {
            return;
        }
        childIdsIncludeSelf.add(parentId);
        List childTags = allTags.stream().filter(m -> parentId.compareTo(m.getLong("parent")) == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childTags)) {
            return;
        }
        for (DynamicObject childTag : childTags) {
            long id = childTag.getLong("id");
            childIdsIncludeSelf.add(id);
            this.getChildIdsIncludeSelf(id, allTags, childIdsIncludeSelf);
        }
    }

    public void afterBindData(EventObject e) {
        RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
        edit.setText((String)this.getModel().getValue(LARGETEXT_TAG));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String key = operate.getOperateKey();
        if ("save".equalsIgnoreCase(key) || "submit".equalsIgnoreCase(key)) {
            RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
            this.getModel().setValue(LARGETEXT_TAG, (Object)edit.getText());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (QUICK_LOOK.equalsIgnoreCase(operateKey)) {
            BillShowParameter showParameter = new BillShowParameter();
            DynamicObject dyo = this.getModel().getDataEntity(true);
            String title = dyo.getString("texttitle");
            String releaseDate = DateUtils.format((Date)dyo.getDate("releasedate"), (String)"yyyy-MM-dd");
            String issuednum = dyo.getString("issuednum");
            List<Long> organIds = this.getTagIds("organ");
            List<Long> totalTagIds = this.getTagIds("totaltags");
            RichTextEditor edit = (RichTextEditor)this.getView().getControl(TEXT);
            String editText = edit.getText();
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("texttitle", title);
            customParams.put("releasedate", releaseDate);
            customParams.put("issuednum", issuednum);
            customParams.put("organIds", organIds);
            customParams.put("totaltagIds", totalTagIds);
            customParams.put("editText", editText);
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.setBillStatus(BillOperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("tpo_tax_article_look");
            showParameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private List<Long> getTagIds(String key) {
        ArrayList<Long> ids = new ArrayList<Long>(8);
        DynamicObjectCollection organ = this.getModel().getDataEntity(true).getDynamicObjectCollection(key);
        if (CollectionUtils.isNotEmpty((Collection)organ)) {
            for (DynamicObject dynamicObject : organ) {
                ids.add(dynamicObject.getLong("fbasedataid.id"));
            }
        }
        return ids;
    }
}

