/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.tdzzs;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.common.utils.EndDateUpdateUtil;

public class TdzzsBizDefBillPlugin
extends AbstractBasePlugIn
implements HyperLinkClickListener {
    private static final String SUB_NUMBER = "subnumber";
    private static final String PROJECT_NAME = "projectname";
    private static final String PARENTID = "parent.number";
    private static final String LEVEL = "level";
    private static final String ISLEAF = "isleaf";
    private static final String LONGNUMBER = "longnumber";
    private static final String FULLNAME = "fullname";
    private static final String SUPER_ROOT = "0";
    private static final String TREEENTRYENTITY = "entry_detail";
    public static final String VALID_FROM = "validfrom";
    public static final String EXPIRED = "expired";
    public static final String FILTER = "filter";
    public static final String SETTING = "setting";
    public static final String DESCRIPTION = "description";
    private static Log logger = LogFactory.getLog(TdzzsBizDefBillPlugin.class);

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(TREEENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            EndDateUpdateUtil.doUpdateEndDate(this.getModel().getEntryEntity(TREEENTRYENTITY), EXPIRED);
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObject dynamicObject;
        Object fromId;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String status = String.valueOf(formShowParameter.getStatus());
        if ("ADDNEW".equals(status)) {
            Long id;
            DynamicObject dynamicObject2;
            JSONObject jsonObject = ((JSONObject)formShowParameter.getCustomParams()).getJSONObject("tree_parent_id");
            if (null != jsonObject && null != (dynamicObject2 = QueryServiceHelper.queryOne((String)"tpo_tdzzs_bizdef_tree", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(id = jsonObject.getLong("value")))}))) {
                String number = dynamicObject2.getString("number");
                this.visibleSwitch("LVAT-fclxzm-001".equals(number), FILTER, SETTING, DESCRIPTION);
                return;
            }
        } else if ("EDIT".equals(status) && null != (fromId = ((BaseShowParameter)formShowParameter).getPkId()) && null != (dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tdzzs_bizdef", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", fromId)}))) {
            Long groupId = dynamicObject.getLong("group");
            DynamicObject dynamicObject1 = QueryServiceHelper.queryOne((String)"tpo_tdzzs_bizdef_tree", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)groupId)});
            String number = dynamicObject1.getString("number");
            this.visibleSwitch("LVAT-fclxzm-001".equals(number), FILTER, SETTING, DESCRIPTION);
            return;
        }
        this.visibleSwitch(false, FILTER, SETTING, DESCRIPTION);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        if (event.getFieldName().equals(SETTING)) {
            this.openSettingPage("tdm_tdzzs_clearing_unit", "filtername");
        }
    }

    protected void openSettingPage(String filterpage, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tpo_clear_unit_setting");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityNumber", (Object)filterpage);
        EntryGrid subtable = (EntryGrid)this.getControl(TREEENTRYENTITY);
        int focusRow = subtable.getEntryState().getFocusRow();
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(TREEENTRYENTITY, focusRow);
        formshowParameter.setCustomParam("sdfasdfasdfasd", selectedRow.get(FILTER));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map filterData;
        if ("filtername".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(TREEENTRYENTITY);
            this.getModel().setValue(DESCRIPTION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(FILTER, filterData.get("filtervalue"), currentRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ((EXPIRED.equals(fieldKey) || VALID_FROM.equals(fieldKey)) && null != this.getModel().getValue(EXPIRED)) {
            Date startDate = (Date)this.getModel().getValue(VALID_FROM);
            Date endDate = (Date)this.getModel().getValue(EXPIRED);
            if (null != startDate && !DateUtils.isEffectiveDate((Date)endDate, (Date)DateUtils.addDay((Date)startDate, (int)-1), null)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u65f6\u95f4\u4e0d\u5f97\u65e9\u4e8e\u5f00\u59cb\u65f6\u95f4", (String)"TdzzsBizDefBillPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                this.clearValue(EXPIRED);
            }
        }
    }

    private void clearValue(String ... keys) {
        for (String key : keys) {
            this.getModel().setValue(key, null);
        }
    }

    private void visibleSwitch(boolean onOff, String ... keys) {
        for (String key : keys) {
            this.getView().setVisible(Boolean.valueOf(onOff), new String[]{key});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Map<String, String>> map = this.getTreeMap();
        if (!ObjectUtils.isEmpty(map)) {
            this.updateTreeEntity(map);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Map<String, Map<String, String>> map;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save && !ObjectUtils.isEmpty(map = this.getTreeMap())) {
            this.updateTreeEntity(map);
        }
    }

    private void updateTreeEntity(Map<String, Map<String, String>> map) {
        List<String> noLeafList = this.getNoLeafList(map);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            String longnumber = treeNote.getString(LONGNUMBER);
            if (!StringUtils.isBlank((CharSequence)longnumber)) continue;
            treeNote.set(LONGNUMBER, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, SUB_NUMBER).toArray(), (String)"."));
            treeNote.set(FULLNAME, (Object)StringUtils.join((Object[])this.getLongValue(subnumber, map, PROJECT_NAME).toArray(), (String)"."));
            treeNote.set(LEVEL, (Object)this.getLevel(subnumber, map));
            treeNote.set(ISLEAF, (Object)(!noLeafList.contains(subnumber) ? 1 : 0));
        }
    }

    private Map<String, Map<String, String>> getTreeMap() {
        HashMap<String, Map<String, String>> treesMap = new HashMap<String, Map<String, String>>(10);
        DynamicObjectCollection treeNotes = this.getModel().getEntryEntity(TREEENTRYENTITY);
        for (DynamicObject treeNote : treeNotes) {
            String subnumber = treeNote.getString(SUB_NUMBER);
            if (treesMap.containsKey(subnumber)) continue;
            HashMap<String, String> node = new HashMap<String, String>();
            node.put(SUB_NUMBER, treeNote.getString(SUB_NUMBER));
            node.put(PROJECT_NAME, treeNote.getString(PROJECT_NAME));
            node.put(LEVEL, treeNote.getString(LEVEL));
            node.put(PARENTID, treeNote.getString(PARENTID));
            treesMap.put(subnumber, node);
        }
        return treesMap;
    }

    private List<String> getLongValue(String subNumber, Map<String, Map<String, String>> treeMap, String type) {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> node = treeMap.get(subNumber);
        if (!ObjectUtils.isEmpty(node)) {
            String parentId = node.get(PARENTID);
            if (!ObjectUtils.isEmpty((Object)parentId) || !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
                list.addAll(this.getLongValue(parentId, treeMap, type));
            }
            list.add(node.get(type));
        }
        return list;
    }

    private int getLevel(String subNumber, Map<String, Map<String, String>> treeMap) {
        int level = 1;
        Map<String, String> node = treeMap.get(subNumber);
        if (null == node) {
            return level;
        }
        String parentId = node.get(PARENTID);
        if (!ObjectUtils.isEmpty((Object)parentId) && !StringUtils.equalsIgnoreCase((CharSequence)parentId, (CharSequence)SUPER_ROOT)) {
            level += this.getLevel(parentId, treeMap);
        }
        return level;
    }

    private List<String> getNoLeafList(Map<String, Map<String, String>> map) {
        ArrayList<String> list = new ArrayList<String>();
        map.forEach((key, value) -> {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)value.get(PARENTID)), (CharSequence)SUPER_ROOT)) {
                list.add((String)value.get(PARENTID));
            }
        });
        return list;
    }
}

