/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;

public class EntitySelectPlugin
extends AbstractFormPlugin {
    private static final String ENTITY_SELECT = "entity_select";
    private static final String ROW_TREE = "rowtree";
    private static final String COLUMN_TREE = "columntree";
    private static final String BUTTON_CHANGE = "button_change";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BUTTON_CHANGE});
        this.addClickListeners(new String[]{"btn_cancel", "btn_submit"});
        this.addClickListeners(new String[]{"allchoose_row", "allclear_row", "allchoose_col", "allclear_col"});
    }

    public void afterCreateNewData(EventObject e) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        Map tableMap = TemplateUtils.queryEntityByTypeId((String)templateType);
        Iterator it = tableMap.entrySet().iterator();
        int index = 0;
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(tableMap.size());
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ComboItem item = new ComboItem();
            item.setId((String)entry.getKey());
            item.setValue((String)entry.getKey());
            item.setCaption(new LocaleString((String)entry.getValue()));
            combos.add(item);
            if (index == 0) {
                this.getModel().setValue(ENTITY_SELECT, entry.getKey());
            }
            if (((String)entry.getKey()).equals(entityId)) {
                this.getModel().setValue(ENTITY_SELECT, (Object)entityId);
            }
            ++index;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ENTITY_SELECT);
        comboEdit.setComboItems(combos);
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
        this.initTree(Boolean.TRUE);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_CHANGE.equals(key)) {
            this.changeClick();
        }
        if ("btn_submit".equals(key)) {
            String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
            TreeView rowTreeView = (TreeView)this.getView().getControl(ROW_TREE);
            TreeView columnTreeView = (TreeView)this.getView().getControl(COLUMN_TREE);
            List rowListMap = rowTreeView.getTreeState().getSelectedNodes();
            List columnListMap = columnTreeView.getTreeState().getSelectedNodes();
            int index = 0;
            for (Map map : rowListMap) {
                if ("ROOT".equals(map.get("id"))) {
                    rowListMap.remove(index);
                    break;
                }
                ++index;
            }
            index = 0;
            for (Map map : columnListMap) {
                if ("ROOT".equals(map.get("id"))) {
                    columnListMap.remove(index);
                    break;
                }
                ++index;
            }
            if (rowListMap.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u884c\u7ef4\u5b57\u6bb5", (String)"EntitySelectPlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (columnListMap.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5217\u7ef4\u5b57\u6bb5", (String)"EntitySelectPlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("row", rowListMap);
            returnData.put("column", columnListMap);
            returnData.put("rowfill", this.getView().getModel().getValue("rowfill"));
            returnData.put("columnfill", this.getView().getModel().getValue("columnfill"));
            returnData.put("entityid", entityId);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            returnData.put("entityname", mainEntityType.getDisplayName().getLocaleValue());
            this.getView().setReturnData(returnData);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if ("btn_cancel".equals(key)) {
            this.getView().close();
        }
    }

    private void initTree(Boolean showType) {
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)showType);
        String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
        EntityInfo entityInfo = MetadataUtil.getEntityById((String)entityId);
        TreeNode rowRoot = this.createRoot();
        ArrayList<TreeNode> ewblNodeList = new ArrayList<TreeNode>();
        ArrayList<TreeNode> otherListNode = new ArrayList<TreeNode>();
        for (EntityField entityField : entityInfo.getFieldList()) {
            if ("ewblxh".equals(entityField.getFieldId())) {
                List listCombo = entityField.getComboItems();
                for (ValueMapItem item : listCombo) {
                    TreeNode node = new TreeNode();
                    node.setParentid("");
                    node.setId(entityId + "#" + item.getValue());
                    node.setText(TemplateUtils.getFieldName((String)item.getName().getLocaleValue()));
                    ewblNodeList.add(node);
                }
                continue;
            }
            if (TemplateUtils.getBaseFieldLast().contains(entityField.getFieldId()) || !StringUtils.isNotEmpty((CharSequence)entityField.getFieldName())) continue;
            TreeNode node = new TreeNode();
            node.setId(entityField.getFieldId());
            node.setParentid("");
            node.setText(TemplateUtils.getFieldName((String)entityField.getFieldName()));
            otherListNode.add(node);
        }
        Collections.sort(otherListNode, new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode node1, TreeNode node2) {
                Integer i1 = EntitySelectPlugin.this.getStartNumber(node1.getText());
                Integer i2 = EntitySelectPlugin.this.getStartNumber(node2.getText());
                return i1.compareTo(i2);
            }
        });
        rowRoot.addChildren(ewblNodeList);
        TreeNode columnRoot = this.createRoot();
        columnRoot.addChildren(otherListNode);
        if (showType.booleanValue()) {
            this.setTreeNode(ROW_TREE, rowRoot);
            this.setTreeNode(COLUMN_TREE, columnRoot);
        } else {
            this.setTreeNode(ROW_TREE, columnRoot);
            this.setTreeNode(COLUMN_TREE, rowRoot);
        }
    }

    private Integer getStartNumber(String str) {
        if (str == null) {
            return 0;
        }
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(str);
        if (m.find()) {
            String start = m.group();
            if (str.startsWith(start)) {
                return Integer.valueOf(m.group());
            }
            return 1000;
        }
        return 1000;
    }

    private void setTreeNode(String treeName, TreeNode rootNode) {
        TreeView treeView = (TreeView)this.getView().getControl(treeName);
        treeView.deleteAllNodes();
        treeView.addNode(rootNode);
        TreeUtils.expandAll((TreeView)treeView, (TreeNode)rootNode);
    }

    public void changeClick() {
        Boolean showType = (Boolean)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, Boolean.class);
        this.initTree(showType == false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (ENTITY_SELECT.equals(name)) {
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)BUTTON_CHANGE, (Object)Boolean.TRUE);
            this.initTree(Boolean.TRUE);
            String entityId = (String)this.getView().getModel().getValue(ENTITY_SELECT);
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)ENTITY_SELECT, (Object)entityId);
        }
    }

    private TreeNode createRoot() {
        TreeNode columnRoot = new TreeNode();
        columnRoot.setId("ROOT");
        columnRoot.setText(ResManager.loadKDString((String)"\u6839\u8282\u70b9", (String)"EntitySelectPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        columnRoot.setParentid("");
        return columnRoot;
    }
}

