/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class EntityTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Log logger = LogFactory.getLog(EntityTreePlugin.class);

    public void initialize() {
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        final TreeView treeView = (TreeView)this.getControl("treeviewap");
        sl.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent p0) {
                if (p0.getText() != null && !"".equals(p0.getText())) {
                    SearchUtil.searchMember((String)p0.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)"treeviewap");
                } else {
                    EntityTreePlugin.this.getPageCache().put("_resultlist", null);
                    EntityTreePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"EntityTreePlugin_0", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
            }
        });
        this.addClickListeners(new String[]{"searchbefore", "searchnext", "submit"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        List<TreeNode> nodeList = this.queryEntityList();
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)this.getPageCache(), (boolean)false);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("searchbefore".equals(key) || "searchnext".equals(key)) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)key, (TreeView)((TreeView)this.getControl("treeviewap")), (String[])btns, (String)"treeviewap");
        }
        if ("submit".equals(key)) {
            TreeView treeView = (TreeView)this.getControl("treeviewap");
            List selectIds = treeView.getTreeState().getSelectedNodeId();
            TreeNode root = (TreeNode)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"treeviewap", TreeNode.class);
            ArrayList<Map> list = new ArrayList<Map>();
            for (String id : selectIds) {
                TreeNode node = root.getTreeNode(id, 20);
                if (node.getData() == null) continue;
                list.add((Map)node.getData());
            }
            if (list.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53", (String)"EntityTreePlugin_1", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(list);
            this.getView().close();
        }
    }

    private List<TreeNode> queryEntityList() {
        ArrayList<TreeNode> listNode = new ArrayList<TreeNode>();
        String sql = "SELECT a.Fnumber,a.Fid,a.Fdata,d.Ftablename,e.Fname Entityname,e.Fnumber Entityid,f.fbizunitid FROM t_Meta_Bizapp         a,      t_Meta_Bizcloud       b,      t_Meta_Entitydesign   c,      t_Meta_Entityinfo     d,      t_Meta_Entitydesign_l e,      T_meta_bizunitrelform f WHERE a.Fbizcloudid = b.Fid  AND b.Fnumber = 'TAXC'  AND a.Fid = c.Fbizappid  AND e.Flocaleid = 'zh_CN'  AND c.Fid = e.Fid  AND c.Fid = d.Fentityid  and d.fentityid=f.fformid ORDER BY a.Fnumber, f.fbizunitid, e.Fnumber";
        List columnList = DBUtils.query((String)DBRoute.meta.getRouteKey(), (String)sql);
        ArrayList<String> bizList = new ArrayList<String>();
        for (Map map : columnList) {
            String bizid = map.get("FNUMBER").toString();
            String entityname = map.get("ENTITYNAME").toString();
            String entityid = map.get("ENTITYID").toString();
            Object fbizunitid = map.get("FBIZUNITID");
            String bizunitid = null;
            if (fbizunitid != null) {
                bizunitid = fbizunitid.toString();
            }
            if (!bizList.contains(bizid)) {
                TreeNode bizNode = new TreeNode();
                bizNode.setId(bizid);
                bizNode.setText(bizid);
                bizNode.setParentid("");
                listNode.add(bizNode);
                bizList.add(bizid);
                String fdata = map.get("FDATA").toString();
                this.parseXml(fdata, bizList, listNode, bizid);
            }
            TreeNode node = new TreeNode();
            node.setId(entityid);
            node.setText(entityid + "_" + entityname);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", entityid);
            data.put("name", entityname);
            node.setData(data);
            if (bizList.contains(bizid + bizunitid)) {
                node.setParentid(bizid + bizunitid);
            } else {
                node.setParentid(bizid);
            }
            listNode.add(node);
        }
        return listNode;
    }

    private void parseXml(String xml, List<String> unitList, List<TreeNode> listNode, String parent) {
        String[] packItems;
        int start = xml.indexOf("<AppFunctionPackets>");
        int end = xml.indexOf("</AppFunctionPackets>");
        if (start < 0 || end < 0) {
            start = 0;
            end = xml.length() - 1;
            logger.debug("indexOf(<AppFunctionPackets>)<0:" + xml);
        }
        String pack = xml.substring(start, end);
        for (String item : packItems = pack.split("</AppFunctionPacketElement>")) {
            if (item.indexOf("<Id>") <= 0 || item.indexOf("<Name>") <= 0) continue;
            String name = item.substring(item.indexOf("<Name>") + 6, item.indexOf("</Name>"));
            String id = item.substring(item.indexOf("<Id>") + 4, item.indexOf("</Id>"));
            TreeNode bizNode = new TreeNode();
            bizNode.setId(parent + id);
            bizNode.setText(name);
            bizNode.setParentid(parent);
            listNode.add(bizNode);
            unitList.add(parent + id);
        }
    }
}

