/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class TemplateListPlugin
extends AbstractListPlugin {
    private static final String DELETE_KEY = "delete";
    private static final String FILTERCONFIG = "filterconfig";
    private static final String GENERALBTN = "generalbtn";
    private static final String GENERAL = "general";
    private static String FIELD_TYPE = "type";
    private static String PARAM_TAXTYPE = "taxtype";
    private static final String TPO_FORMULA_EDIT_OLD = "tpo_formula_temp_edit";
    private static final String TPO_FORMULA_EDIT = "tpo_formula_edit";
    private static final String TEMPLATEID = "templateid";
    private static final String KEY_CONDITIONJSON = "conditionjson";
    private static final String KEY_FILTERCONDITION = "filtercondition";
    public static final String KEY_FILTERDESCRIPTION = "filterdescription";
    public static final String KEY_FILTER_VALUE = "filtervalue";
    private static final List<String> VISIBLE_CONFIG_TAX = Arrays.asList("zzs", "tcwat", "ccxws", "tvpt", "qysds", "cwbs", "lat", "qtsf_ty");
    private static final List<String> VISIBLE_GENARAL_TAX = Arrays.asList("zzs", "ccxws", "tvpt", "lat", "cwbs", "qtsf_ty");
    private static Map<String, String> FORMULA_MAP = new HashMap<String, String>(4){
        {
            this.put("tpo_template_old", TemplateListPlugin.TPO_FORMULA_EDIT_OLD);
            this.put("bdtaxr_template_main", TemplateListPlugin.TPO_FORMULA_EDIT);
        }
    };

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
    }

    public void afterCreateNewData(EventObject e) {
        String type = this.getParam(PARAM_TAXTYPE);
        String string = type = type == null ? "zzs" : type;
        if (VISIBLE_CONFIG_TAX.contains(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FILTERCONFIG});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FILTERCONFIG});
        }
        if (VISIBLE_GENARAL_TAX.contains(type)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{GENERALBTN});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{GENERALBTN});
        }
        if ("zlxz".equals(this.getParam("from"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap", "toolbarap"});
        }
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String[] taxtypes;
        if (args.getFieldName().startsWith("type.") && (taxtypes = (String[])TemplateTypeConstant.getTypeMap().get(this.getParam(PARAM_TAXTYPE))) != null) {
            args.getQfilters().add(new QFilter("id", "in", (Object)taxtypes));
        }
    }

    private void filterContainerInit(FilterContainerInitEvent args) {
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        CommonFilterColumn typeColumn = null;
        ArrayList<Object> typeList = new ArrayList<Object>(12);
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(FIELD_TYPE) || !(filterColumn instanceof CommonFilterColumn)) continue;
            typeColumn = (CommonFilterColumn)filterColumn;
            break;
        }
        String type = this.getParam(PARAM_TAXTYPE);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(12);
        String[] types = (String[])TemplateTypeConstant.getTypeMap().get(type);
        if (null != types) {
            for (String tt : types) {
                ComboItem item = new ComboItem();
                item.setValue(tt);
                item.setCaption(new LocaleString((String)TemplateTypeConstant.getMap().getOrDefault(tt, tt)));
                combos.add(item);
                typeList.add(tt);
            }
        } else {
            for (Map.Entry entry : TemplateTypeConstant.getMap().entrySet()) {
                ComboItem item = new ComboItem();
                item.setValue((String)entry.getKey());
                item.setCaption(new LocaleString((String)entry.getValue()));
                combos.add(item);
                typeList.add(item.getValue());
            }
        }
        if (typeColumn != null) {
            if (!combos.isEmpty()) {
                typeColumn.setDefaultValue(((ComboItem)combos.get(0)).getValue());
            }
            typeColumn.setType("enum");
            typeColumn.setMustInput(true);
            typeColumn.setComboItems(combos);
            typeColumn.setComboItems(combos);
        }
        for (FilterColumn filterColumn : schemeColumnList) {
            if (FIELD_TYPE.equals(filterColumn.getFieldName())) {
                SchemeFilterColumn column1 = (SchemeFilterColumn)filterColumn;
                column1.setComboItems(combos);
                if (combos.isEmpty()) break;
                column1.setDefaultValue(((ComboItem)combos.get(0)).getValue());
                break;
            }
            if (typeColumn == null) continue;
            typeColumn.setType("enum");
            typeColumn.setMustInput(true);
            typeColumn.setComboItems(combos);
            typeColumn.setComboItems(combos);
        }
        if (!"zlxz".equals(this.getParam("from"))) {
            BillList billlist = (BillList)this.getControl("billlistap");
            QFilter qFilter = new QFilter("type", "in", typeList);
            billlist.setFilter(qFilter);
        } else {
            filterColumnList.clear();
        }
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramtype = (String)customParams.get(param);
        return paramtype;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        List successPkIds;
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        if (DELETE_KEY.equals(itemKey) && EmptyCheckUtils.isNotEmpty((Object)(successPkIds = (operationResult = afterDoOperationEventArgs.getOperationResult()).getSuccessPkIds()))) {
            BillList billList = (BillList)this.getControl("billlistap");
            String name = billList.getEntityType().getName();
            DeleteServiceHelper.delete((String)FORMULA_MAP.get(name), (QFilter[])new QFilter[]{new QFilter(TEMPLATEID, "in", successPkIds.stream().map(s -> s.toString()).collect(Collectors.toList()))});
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<Object> typeList = new ArrayList<Object>(12);
        String type = this.getParam(PARAM_TAXTYPE);
        String[] types = (String[])TemplateTypeConstant.getTypeMap().get(type);
        if (null != types) {
            for (String tt : types) {
                typeList.add(tt);
            }
        } else {
            for (Map.Entry entry : TemplateTypeConstant.getMap().entrySet()) {
                ComboItem item = new ComboItem();
                item.setValue((String)entry.getKey());
                item.setCaption(new LocaleString((String)entry.getValue()));
                typeList.add(item.getValue());
            }
        }
        QFilter qFilter = new QFilter("type", "in", typeList);
        e.getQFilters().add(qFilter);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
    }

    public void itemClick(ItemClickEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String itemKey = evt.getItemKey();
        List<String> keys = Arrays.asList(GENERALBTN, FILTERCONFIG);
        if (keys.contains(itemKey)) {
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TemplateListPlugin_3", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TemplateListPlugin_2", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)GENERALBTN)) {
            this.confirmGeneral(list.get(0).getPrimaryKeyValue());
        } else if (StringUtils.equals((CharSequence)itemKey, (CharSequence)FILTERCONFIG)) {
            Object primaryKeyValue = list.get(0).getPrimaryKeyValue();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)billlist.getBillFormId());
            if (EmptyCheckUtils.isEmpty((Object)object)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762", (String)"TemplateListPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean general = object.getBoolean(GENERAL);
            if (general) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u6a21\u677f\u4e0d\u53ef\u4ee5\u914d\u7f6e\u9002\u7528\u6027\uff0c\u8bf7\u5148\u5207\u6362\u901a\u7528\u6807\u8bc6", (String)"TemplateListPlugin_4", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            this.openSettingPage(object, KEY_CONDITIONJSON, "setting");
        }
    }

    private void confirmGeneral(Object pkValue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmgeneral", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TemplateListPlugin_7", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TemplateListPlugin_8", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5207\u6362\u4e3a\u901a\u7528\u5417\uff1f", (String)"TemplateListPlugin_6", (String)"taxc-tctb-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, String.valueOf(pkValue));
    }

    public static DynamicObject[] getCoverTemplateObjects(Long pkValue, String templateType, Date startDate, Date endDate, String billFormId) {
        DynamicObject[] load;
        QFilter qFilter1 = new QFilter("type", "=", (Object)templateType);
        QFilter qFilter2 = new QFilter("id", "!=", (Object)pkValue);
        if (endDate != null) {
            QFilter startInRange = new QFilter("startdate", ">=", (Object)startDate).and("startdate", "<=", (Object)DateUtils.getDayLast((Date)endDate));
            QFilter endInRange = new QFilter("enddate", ">=", (Object)startDate).and("enddate", "<=", (Object)DateUtils.getDayLast((Date)endDate));
            QFilter startLessStart = new QFilter("startdate", "<=", (Object)startDate);
            QFilter qFilter = startInRange.or(startLessStart.and(endInRange.or(QFilter.isNull((String)"enddate"))));
            load = BusinessDataServiceHelper.load((String)billFormId, (String)"id,number,general,startdate,enddate", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter1});
        } else {
            QFilter qFilter = QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)startDate);
            load = BusinessDataServiceHelper.load((String)billFormId, (String)"id,number,general,startdate,enddate", (QFilter[])new QFilter[]{qFilter, qFilter2, qFilter1});
        }
        return load;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if ("confirmgeneral".equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            String customVaule = event.getCustomVaule();
            Long pkValue = Long.valueOf(customVaule);
            BillList billlist = (BillList)this.getControl("billlistap");
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)billlist.getBillFormId());
            String type = object.getString("type.id");
            Date startdate = object.getDate("startdate");
            Date enddate = object.getDate("enddate");
            DynamicObject[] templateObjects = TemplateListPlugin.getCoverTemplateObjects(pkValue, type, startdate, enddate, billlist.getBillFormId());
            List<DynamicObject> generalList = Arrays.stream(templateObjects).filter(a -> !String.valueOf(pkValue).equals(a.getString("id")) && a.getBoolean(GENERAL)).collect(Collectors.toList());
            try (TXHandle h = TX.requiresNew();){
                try {
                    if (generalList.size() > 0) {
                        for (DynamicObject dynamicObject : generalList) {
                            dynamicObject.set(GENERAL, (Object)Boolean.FALSE);
                        }
                        SaveServiceHelper.update((DynamicObject[])generalList.toArray(new DynamicObject[generalList.size()]));
                    }
                    object.set(GENERAL, (Object)Boolean.TRUE);
                    object.set(KEY_CONDITIONJSON, null);
                    object.set(KEY_FILTERCONDITION, null);
                    SaveServiceHelper.update((DynamicObject)object);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6807\u8bc6\u901a\u7528\u6210\u529f", (String)"TemplateListPlugin_9", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                }
                catch (Throwable t) {
                    h.markRollback();
                    throw new RuntimeException(t);
                }
            }
            billlist.refresh();
        }
    }

    private void openSettingPage(DynamicObject selectedRow, String conditionjson, String actionId) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("tpo_tcvat_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCustomParam("entityNumber", (Object)"tctb_tax_main_form");
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCaption(ResManager.loadKDString((String)"\u6761\u4ef6\u914d\u7f6e", (String)"TemplateListPlugin_10", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId())) {
            Map filterData = (Map)evt.getReturnData();
            if (filterData == null) {
                return;
            }
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
            DynamicObject selectRecord = BusinessDataServiceHelper.loadSingle((String)billList.getBillFormId(), (String)"id,filtercondition,conditionjson", (QFilter[])new QFilter[]{new QFilter("id", "=", listSelectedRows.get(0).getPrimaryKeyValue())});
            if (EmptyCheckUtils.isEmpty((Object)selectRecord)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u8bb0\u5f55\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762", (String)"TemplateListPlugin_5", (String)"taxc-tctb-formplugin", (Object[])new Object[0]));
                return;
            }
            selectRecord.set(KEY_CONDITIONJSON, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get(KEY_FILTER_VALUE));
            selectRecord.set(KEY_FILTERCONDITION, EmptyCheckUtils.isEmpty((Object)filterData) ? null : filterData.get(KEY_FILTERDESCRIPTION));
            SaveServiceHelper.update((DynamicObject)selectRecord);
            billList.refresh();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow rowInfo = list.getCurrentSelectedRowInfo();
        String name = list.getEntityType().getName();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)rowInfo.getPrimaryKeyValue(), (String)name);
        if (object != null) {
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)name, (Object)rowInfo.getPrimaryKeyValue(), (IFormView)this.getView(), (Map)this.getView().getFormShowParameter().getCustomParams(), (BillOperationStatus)BillOperationStatus.EDIT);
        }
    }
}

