/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TcnfepDeclaredetailTscUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcnfepDeclaredetailTscUpgradeService.class);
    private static final String SQL_SELECT_BD_ADMINDIVISION = "select fid,fcountryid from t_bd_admindivision where fid in (%s)";
    private static final String SQL_SELECT_DECLAREDETAILTSC = "select fid,fvalue,fvaluetype,fentryid,frow from t_tpo_declare_detail_tsc where fcellnumber = 'tcnfep_declare_entry_1#tcnfep_declare_entry_gj' and (fvalue != ' ' and fvalue != '' and fvalue is not null)";
    private static final String SQL_INSERT_DECLAREDETAILTSC = "insert into t_tpo_declare_detail_tsc (fid,fentryid,fvalue,fvaluetype,fcellnumber,frow,fcolumn) values (?,?,?,?,?,?,?)";
    private static final Map<Object, Object> countryIdMap = new HashMap<Object, Object>(){
        {
            this.put("1005772187937808384", "1000005");
            this.put("1005772187937808385", "1000003");
            this.put("1005772187937808386", "1000004");
        }
    };

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.updateDeclareDetailTsc();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void updateDeclareDetailTsc() {
        List needUpdateDatas;
        if (DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_tpo_declare_detail_tsc") && DB.exitsTable((DBRoute)DBRoute.of((String)"sys"), (String)"t_bd_admindivision") && EmptyCheckUtils.isNotEmpty((Object)(needUpdateDatas = DBUtils.query((String)SQL_SELECT_DECLAREDETAILTSC)))) {
            List payeeaddressIds = needUpdateDatas.stream().map(s -> s.get("FVALUE")).collect(Collectors.toList());
            List admindivisionDatas = DBUtils.query((String)"sys", (String)String.format(SQL_SELECT_BD_ADMINDIVISION, StringUtils.join((Object[])payeeaddressIds.toArray(), (String)",")));
            Map<String, Object> idMap = admindivisionDatas.stream().collect(Collectors.toMap(a -> a.get("FID") + "", b -> b.get("FCOUNTRYID"), (m, n) -> m));
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
            long[] detailFids = DB.genLongIds((String)"tpo_declare_detail_tsc", (int)needUpdateDatas.size());
            int index = 0;
            for (Map row : needUpdateDatas) {
                if (idMap.get(row.get("FVALUE") + "") == null) continue;
                Long fid = detailFids[index];
                Object fentryid = row.get("FENTRYID");
                Object fvalue = idMap.get(row.get("FVALUE") + "");
                Object fvaluetype = row.get("FVALUETYPE");
                String fcellnumber = "tcnfep_declare_entry_1#tcnfep_declare_entry_country";
                Object frow = row.get("FROW");
                Long fcolumn = 1839076509734706176L;
                if (countryIdMap.containsKey(row.get("FVALUE") + "")) {
                    fvalue = countryIdMap.get(row.get("FVALUE") + "");
                }
                paramList.add(new Object[]{fid, fentryid, fvalue, fvaluetype, fcellnumber, frow, fcolumn});
                ++index;
            }
            try (TXHandle h = TX.required();){
                try {
                    if (EmptyCheckUtils.isNotEmpty(paramList)) {
                        DBUtils.executeBatch((String)"taxc", (String)SQL_INSERT_DECLAREDETAILTSC, paramList);
                    }
                }
                catch (Exception e) {
                    h.markRollback();
                }
            }
        }
    }
}

