/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.upgradeservice;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.tpo.common.utils.EndDateUpdateUtil;

public class TpoEndDateUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TpoEndDateUpgradePlugin.class);
    private static final String QUERY_FIELD = "id,%s";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "TpoEndDateUpgradePlugin UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("TpoEndDateUpgradePlugin UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        HashMap<String, String> metaMap = new HashMap<String, String>();
        HashMap<String, String> metaEntryMap = new HashMap<String, String>();
        this.doSetMap(metaMap, metaEntryMap);
        try {
            metaMap.forEach(this::update);
            metaEntryMap.forEach(this::updateEntry);
        }
        catch (Exception e) {
            LOGGER.error(ERROR_INFO, (Throwable)e);
            this.addLog(ERROR, this.getStackTraceMessage(e));
        }
    }

    private void update(String meta, String field) {
        try {
            QFilter endDateFilter = QFilter.isNotNull((String)field);
            DynamicObject[] collect = BusinessDataServiceHelper.load((String)meta, (String)String.format(QUERY_FIELD, field), (QFilter[])new QFilter[]{endDateFilter});
            if (collect.length == 0) {
                return;
            }
            List<DynamicObject> updateList = Arrays.stream(collect).filter(d -> EndDateUpdateUtil.needUpdate(d.getDate(field))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateList)) {
                return;
            }
            updateList.forEach(u -> u.set(field, (Object)EndDateUpdateUtil.calEndDate(u.getDate(field))));
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOGGER.error(ERROR_INFO, (Throwable)e);
            this.addLog(ERROR, this.getStackTraceMessage(e));
        }
    }

    private void updateEntry(String meta, String field) {
        try {
            String[] arr = field.split("\\.");
            String entry = arr[0];
            String endDateField = arr[1];
            QFilter endDateFilter = QFilter.isNotNull((String)field);
            DynamicObject[] collect = BusinessDataServiceHelper.load((String)meta, (String)String.format(QUERY_FIELD, field), (QFilter[])new QFilter[]{endDateFilter});
            if (collect.length == 0) {
                return;
            }
            List<DynamicObject> updateCollect = Arrays.stream(collect).filter(c -> this.needUpdate(c.getDynamicObjectCollection(entry), endDateField)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(updateCollect)) {
                return;
            }
            updateCollect.forEach(c -> {
                DynamicObjectCollection entryCollect = c.getDynamicObjectCollection(entry);
                if (CollectionUtils.isEmpty((Collection)entryCollect)) {
                    return;
                }
                entryCollect.forEach(e -> {
                    if (EndDateUpdateUtil.needUpdate(e.getDate(endDateField))) {
                        e.set(endDateField, (Object)EndDateUpdateUtil.calEndDate(e.getDate(endDateField)));
                    }
                });
            });
            SaveServiceHelper.update((DynamicObject[])collect);
        }
        catch (Exception e) {
            LOGGER.error(ERROR_INFO, (Throwable)e);
            this.addLog(ERROR, this.getStackTraceMessage(e));
        }
    }

    private boolean needUpdate(DynamicObjectCollection collection, String endDateField) {
        List collect = collection.stream().filter(c -> EndDateUpdateUtil.needUpdate(c.getDate(endDateField))).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(collect);
    }

    private void doSetMap(Map<String, String> metaMap, Map<String, String> metaEntryMap) {
        metaMap.put("tpo_tcvat_prerate", "enddate");
        metaMap.put("tpo_tcvat_taxrate", "enddate");
        metaMap.put("tpo_taxdeduction", "enddate");
        metaEntryMap.put("tpo_tcvat_assist", "entryentity.enddate");
        metaMap.put("tpo_discount_items", "end");
        metaMap.put("tpo_tccit_yearitems", "end");
        metaMap.put("tpo_standingbook_items", "end");
        metaEntryMap.put("tpo_tccit_bizdef", "entry_detail.expired");
        metaMap.put("tpo_assetlossmap", "enddate");
        metaMap.put("tpo_software_profit_map", "enddate");
        metaMap.put("tpo_tcsd_taxrate", "enddate");
        metaMap.put("tpo_tcret_taxrate", "enddate");
        metaMap.put("tpo_tcct_taxrate", "enddate");
        metaEntryMap.put("tpo_hbs_bizdef", "entry_detail.expired");
        metaEntryMap.put("tpo_szys_bizdef", "entry_detail.expired");
        metaEntryMap.put("tpo_tdzzs_bizdef", "entry_detail.expired");
        metaMap.put("tpo_bbbscwbb", "enddate");
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

