/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TysbsfBizDefUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TysbsfBizDefUpgradePlugin.class);
    private static final String QUERY_UPDATE_DATA1 = "select fentryid,fprojectname,fvalidfrom from t_tpo_tysbsf_bizdef_entry";
    private static final String QUERY_UPDATE_DATA2 = "select fentryid,fcollectsubrate,feffectivestart from t_tctb_qtsf_entry where fcollectsubrate != ' ' and feffectivestart in (select min(feffectivestart) from t_tctb_qtsf_entry group by fcollectsubrate)";
    private static final String INSERT_TYSBSF_BIZDEF_ENTRY = "INSERT INTO T_TPO_TYSBSF_BIZDEF_ENTRY(FID,FPARENT,FPROJECTNAME,FVALUE,FENTRYID,FVALIDFROM,FPARENTNUMBER,FSTATUS,FDESC,FNUMBER) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String QUERY_UPDATE_DATA3 = "select fid,fcollectrate,fcollectsubrate from t_tctb_qtsf_entry where fcollectsubrate != ' ' and fcollectitem = 0";
    private static final String UPDATE_QTSF_ENTRY = "update t_tctb_qtsf_entry set fcollectitem = ? where fcollectsubrate = ?;";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "TysbsfBizDefUpgradePlugin UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("TysbsfBizDefUpgradePlugin UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        List updateList;
        List List1 = DBUtils.query((String)QUERY_UPDATE_DATA1);
        List List2 = DBUtils.query((String)QUERY_UPDATE_DATA2);
        ArrayList<Long> entryidList1 = new ArrayList<Long>(List1.size());
        ArrayList<String> collectsubrateList = new ArrayList<String>(List1.size());
        for (Map map : List1) {
            long entryid = Long.parseLong(String.valueOf(map.get("FENTRYID")));
            String collectsubrate = (String)map.get("FPROJECTNAME");
            entryidList1.add(entryid);
            collectsubrateList.add(collectsubrate);
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>(List2.size());
        ArrayList<Object[]> paramsList1 = new ArrayList<Object[]>(List2.size());
        for (Map map : List2) {
            long entryid = Long.parseLong(String.valueOf(map.get("FENTRYID")));
            String collectsubrate = (String)map.get("FCOLLECTSUBRATE");
            Date effectivestart = (Date)map.get("FEFFECTIVESTART");
            if (entryidList1.contains(entryid) || collectsubrateList.contains(collectsubrate)) continue;
            if (dateMap.get(collectsubrate) == null) {
                paramsList1.add(new Object[]{1538451600912468992L, 1457213271932163072L, collectsubrate, 0, entryid, effectivestart, Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(' ')});
            }
            dateMap.put(collectsubrate, effectivestart);
        }
        if (!CollectionUtils.isEmpty(paramsList1)) {
            DBUtils.executeBatch((String)INSERT_TYSBSF_BIZDEF_ENTRY, paramsList1);
        }
        if (CollectionUtils.isEmpty((Collection)(updateList = DBUtils.query((String)QUERY_UPDATE_DATA3)))) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(updateList.size());
        for (Map payMap : updateList) {
            DynamicObject object;
            long id = Long.parseLong(String.valueOf(payMap.get("FID")));
            String fcollectsubrate = (String)payMap.get("FCOLLECTSUBRATE");
            if (fcollectsubrate.isEmpty() || "null".equals(fcollectsubrate) || null == (object = QueryServiceHelper.queryOne((String)"tpo_tysbsf_bizdef_entry", (String)"id,projectname", (QFilter[])new QFilter[]{new QFilter("projectname", "=", (Object)fcollectsubrate)}))) continue;
            Long collectitem = object.getLong("id");
            String projectname = object.getString("projectname");
            paramsList.add(new Object[]{collectitem, projectname});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_QTSF_ENTRY, paramsList);
    }

    private void addNewData() {
    }
}

