/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.yhs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class YhsTaxSourceAddListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String orgName = (String)customParams.get("orgName");
        List filter = e.getQFilters();
        DynamicObjectCollection taxList = this.getTaxList();
        if (null == taxList) {
            this.getView().getParentView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u672a\u7ef4\u62a4\u5370\u82b1\u7a0e\u7a0e\u76ee\uff0c\u8bf7\u5148\u5728\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"YhsTaxSourceAddListPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), orgName));
            this.getView().close();
            return;
        }
        if (taxList.size() > 0) {
            List taxRateIdList = taxList.stream().map(v -> v.getDynamicObject("taxrate").getLong("id")).collect(Collectors.toList());
            filter.add(new QFilter("id", "in", taxRateIdList));
        }
    }

    private DynamicObjectCollection getTaxList() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object orgid = customParams.get("orgid");
        if (!customParams.containsKey("orgid")) {
            return new DynamicObjectCollection();
        }
        if (null == orgid) {
            return null;
        }
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainYhsByOrgId(Collections.singletonList(Long.parseLong(String.valueOf(orgid))));
        if (EmptyCheckUtils.isEmpty((Object)result.getData()) || EmptyCheckUtils.isEmpty((Object)((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("yhsentity"))) {
            return null;
        }
        DynamicObjectCollection yhsentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("yhsentity");
        yhsentity.removeIf(d -> "acsb".equals(d.getString("declaretype")));
        if (yhsentity.size() <= 0) {
            return null;
        }
        return yhsentity;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                DynamicObjectCollection taxList = YhsTaxSourceAddListPlugin.this.getTaxList();
                if (null != taxList && taxList.size() > 0) {
                    for (DynamicObject taxItem : data) {
                        long id = taxItem.getLong("id");
                        for (DynamicObject tax : taxList) {
                            long aLong = tax.getDynamicObject("taxrate").getLong("id");
                            if (id != aLong) continue;
                            taxItem.set("startDate", (Object)tax.getDate("effectivedate"));
                            taxItem.set("endDate", (Object)tax.getDate("expirydate"));
                        }
                    }
                }
                return data;
            }
        });
    }
}

