/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.formplugin.zldc;

import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.taxc.bdtaxr.common.util.FileEncryptorUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.common.dataexport.DataExportUtil;
import kd.taxc.tpo.common.sql.MalTransInner;

public class DataExportPlugine
extends AbstractListPlugin {
    private final Set<String> ZLJH = Sets.newHashSet((Object[])new String[]{"tpo_formula_temp_edit", "tpo_formula_edit", "tpo_rule_fetch", "tpo_taxdeduction", "tpo_template_old", "bdtaxr_template_main", "tpo_template", "tpo_tax_calendar", "tpo_zspm"});

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("stdx".equals(eventName)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (Objects.isNull(newValue)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
                return;
            }
            if (this.ZLJH.contains(newValue.getString("number"))) {
                this.openFormView(newValue.getString("number"));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u5b9e\u4f53\u5bf9\u8c61\u201d\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u3002", (String)"DataExportPlugine_0", (String)"taxc-tpo", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            Object stdx = this.getModel().getValue("stdx");
            String operateKey = ((Donothing)args.getSource()).getOperateKey();
            if (Objects.isNull(stdx)) {
                if (!"refresh".equals(operateKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DataExportPlugine_1", (String)"taxc-tpo", (Object[])new Object[0]));
                }
                args.setCancel(true);
                return;
            }
            if ("zlexport".equals(operateKey) && !Objects.isNull(stdx)) {
                String number = ((DynamicObject)stdx).getString("number");
                if (!this.ZLJH.contains(number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DataExportPlugine_1", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListView listView = (ListView)this.getView().getView(this.getPageCache().get("flexpanelap"));
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (selectedRows.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DataExportPlugine_1", (String)"taxc-tpo", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        Object stdx = this.getModel().getValue("stdx");
        String number = ((DynamicObject)stdx).getString("number");
        String name = ((DynamicObject)stdx).getString("name");
        if ("refresh".equals(operateKey)) {
            if (this.ZLJH.contains(number)) {
                this.openFormView(number);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u5b9e\u4f53\u5bf9\u8c61\u201d\u6682\u4e0d\u652f\u6301\u6b64\u529f\u80fd\u3002", (String)"DataExportPlugine_2", (String)"taxc-tpo", (Object[])new Object[0]));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            }
        } else {
            ListView listView = (ListView)this.getView().getView(this.getPageCache().get("flexpanelap"));
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            String[] collect = (String[])selectedRows.stream().map(o -> o.getPrimaryKeyValue().toString()).toArray(String[]::new);
            try {
                Map<String, Object> generateSQL = MalTransInner.generateSQL(number, collect);
                this.exportFile(generateSQL, number, name);
                OperatorDialogUtils.operateDialogByAppid((String)"tpo", (String)"tpo_dataexport_main", (String)ResManager.loadKDString((String)"\u8d44\u6599\u5bfc\u51fa", (String)"DataExportPlugine_5", (String)"taxc-tpo", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8d44\u6599\u5bfc\u51fa\u6210\u529f\u3002", (String)"DataExportPlugine_4", (String)"taxc-tpo", (Object[])new Object[0]), name));
            }
            catch (Exception e) {
                throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
            }
        }
    }

    private void exportFile(Map<String, Object> generateSQL, String number, String name) {
        Object sql = generateSQL.get("sql");
        Object xml = generateSQL.get("xml");
        String sqlFileName = String.format("%s_%s.sql", number, new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        HashMap<String, byte[]> allStream = new HashMap<String, byte[]>();
        if (!Objects.isNull(xml)) {
            HashMap longTextDataFile = (HashMap)xml;
            for (Map.Entry entry : longTextDataFile.entrySet()) {
                StringWriter sw = (StringWriter)entry.getValue();
                byte[] barray = sw.toString().getBytes(StandardCharsets.UTF_8);
                allStream.put((String)entry.getKey(), barray);
            }
        }
        allStream.put(sqlFileName, sql.toString().getBytes(StandardCharsets.UTF_8));
        byte[] bytes = DataExportUtil.zipFiles(allStream);
        String dateStr = DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String sqlurl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6587\u4ef6_%1$s_%2$s.zip", (String)"DataExportPlugine_3", (String)"taxc-tpo", (Object[])new Object[0]), name, dateStr), FileEncryptorUtil.encryptDecryptFile((byte[])bytes), 5000);
        this.getView().openUrl(sqlurl);
    }

    private void openFormView(String formId) {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(formId);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        param.setFormId(formConfig.getListFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey("flexpanelap");
        param.setCustomParam("from", (Object)"zlxz");
        param.setShowFilter(false);
        param.setShowQuickFilter(false);
        this.getView().showForm((FormShowParameter)param);
        this.getPageCache().put("flexpanelap", param.getPageId());
    }
}

