/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class ColMemberOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                if ("save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey())) {
                    this.doValidForSaveAndSubmit();
                }
            }

            private void doValidForSaveAndSubmit() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObjectCollection entryentity = obj.getDynamicObjectCollection("entryentity");
                    if (null == entryentity) continue;
                    for (DynamicObject dynamicObject : entryentity) {
                        Date startdate = dynamicObject.getDate("startdate");
                        if (null != startdate && !DateUtils.format((Date)startdate, (String)"yyyy-MM-dd").equalsIgnoreCase(DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)startdate), (String)"yyyy-MM-dd"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u53ea\u80fd\u9009\u62e9\u6708\u521d1\u53f7\u3002", (String)"ColMemberOp_0", (String)"taxc-tpo", (Object[])new Object[0]));
                            return;
                        }
                        Date enddate = dynamicObject.getDate("enddate");
                        if (null != enddate && !DateUtils.format((Date)enddate, (String)"yyyy-MM-dd").equalsIgnoreCase(DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)enddate), (String)"yyyy-MM-dd"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u53ea\u80fd\u9009\u62e9\u6708\u672b\u6700\u540e1\u5929\u3002", (String)"ColMemberOp_1", (String)"taxc-tpo", (Object[])new Object[0]));
                            return;
                        }
                        if (null != startdate && null != enddate && enddate.before(startdate)) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u4e0d\u80fd\u5c0f\u4e8e\u6709\u6548\u671f\u8d77\u3002", (String)"ColMemberOp_2", (String)"taxc-tpo", (Object[])new Object[0]));
                            return;
                        }
                        boolean overlapping = this.hasDateDuplicate(dynamicObject, entryentity);
                        if (!overlapping) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u5b58\u5728\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ColMemberOp_3", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                }
            }

            public boolean hasDateDuplicate(DynamicObject currobj, DynamicObjectCollection objs) {
                List colls = objs.stream().filter(v -> v.getLong("id") != currobj.getLong("id")).collect(Collectors.toList());
                for (DynamicObject obj : colls) {
                    if (!this.hasDateDuplicate(currobj.getDate("startdate"), currobj.getDate("enddate"), obj.getDate("startdate"), obj.getDate("enddate"))) continue;
                    return true;
                }
                return false;
            }

            protected boolean hasDateDuplicate(Date beginTime, Date endTime, Date startDate, Date endDate) {
                Date[] date = DateUtils.getIntersectionDate((Date)beginTime, (Date)endTime, (Date)startDate, (Date)endDate);
                return date != null && date.length > 0;
            }
        });
    }
}

