/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DateRangeSaveValidator
extends AbstractValidator {
    private static final String NUMBER = "number";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String TAX_TYPE = "taxpayertype";
    private static final String FILEDS = "number,startdate,enddate";
    private static final String ID = "id";
    private String entryName;
    private boolean uniqueNumber = false;

    public DateRangeSaveValidator(String entryName) {
        this.entryName = entryName;
    }

    public DateRangeSaveValidator(String entryName, boolean uniqueNumber) {
        this.entryName = entryName;
        this.uniqueNumber = uniqueNumber;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Date enddate;
            StringBuilder errorMess = new StringBuilder();
            Long fid = dataEntity.getDataEntity().getLong(ID);
            String number = dataEntity.getDataEntity().getString(NUMBER);
            String taxType = dataEntity.getDataEntity().getString(TAX_TYPE);
            Date startdate = dataEntity.getDataEntity().getDate(STARTDATE);
            if (null == startdate) {
                errorMess.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!", (String)"DateRangeSaveValidator_0", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            if (null != (enddate = dataEntity.getDataEntity().getDate(ENDDATE)) && null != startdate && enddate.getTime() < startdate.getTime()) {
                errorMess.append(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4!", (String)"DateRangeSaveValidator_1", (String)"taxc-tpo", (Object[])new Object[0]));
            }
            QFilter f1 = new QFilter(NUMBER, "=", (Object)number);
            QFilter f2 = new QFilter(ID, "!=", (Object)fid);
            QFilter f3 = new QFilter(TAX_TYPE, "=", (Object)taxType);
            QFilter[] filters = new QFilter[]{f1, f2, f3};
            if (this.uniqueNumber) {
                filters = new QFilter[]{f2, f3};
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entryName, (String)FILEDS, (QFilter[])filters);
            for (DynamicObject c : collection) {
                Date sdate = c.getDate(STARTDATE);
                Date edate = c.getDate(ENDDATE);
                if ("ybnsr".equalsIgnoreCase(taxType) || "xgmnsr".equalsIgnoreCase(taxType) || "".equalsIgnoreCase(taxType)) continue;
                if (null == edate) {
                    errorMess.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5165\u4e0a\u4e00\u6761\u6570\u636e\u7684\u7ed3\u675f\u65f6\u95f4,\u624d\u80fd\u65b0\u589e\u6570\u636e!", (String)"DateRangeSaveValidator_2", (String)"taxc-tpo", (Object[])new Object[0]));
                    break;
                }
                if (null == edate || null == sdate || null == startdate || null == enddate || startdate.getTime() > edate.getTime() || enddate.getTime() < sdate.getTime()) continue;
                errorMess.append(ResManager.loadKDString((String)"\u65b0\u589e\u7684\u6570\u636e\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u524d\u4e00\u6761\u6570\u636e\u7684\u7ed3\u675f\u65f6\u95f4!", (String)"DateRangeSaveValidator_3", (String)"taxc-tpo", (Object[])new Object[0]));
                break;
            }
            if (errorMess.length() <= 0) continue;
            this.addErrorMessage(dataEntity, errorMess.toString());
        }
    }
}

