/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DateValiditySaveValidator
extends AbstractValidator {
    private static final String NUMBER = "number";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String NAME = "name";
    private static final String FILEDS = "name,number,startdate,enddate";
    private static final String ID = "id";
    private String entryName;
    private boolean uniqueNumber = false;

    public DateValiditySaveValidator(String entryName) {
        this.entryName = entryName;
    }

    public DateValiditySaveValidator(String entryName, boolean uniqueNumber) {
        this.entryName = entryName;
        this.uniqueNumber = uniqueNumber;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject[] collection;
            StringBuilder errorMess = new StringBuilder();
            String fid = dataEntity.getDataEntity().getString(ID);
            String number = dataEntity.getDataEntity().getString(NUMBER);
            Date startdate = dataEntity.getDataEntity().getDate(STARTDATE);
            Date enddate = dataEntity.getDataEntity().getDate(ENDDATE);
            if (null != enddate && null != startdate && enddate.getTime() < startdate.getTime()) {
                errorMess.append(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65f6\u95f4!", (String)"DateValiditySaveValidator_0", (String)"taxc-tpo", (Object[])new Object[0]));
                this.addFatalErrorMessage(dataEntity, errorMess.toString());
                return;
            }
            QFilter f1 = new QFilter(NUMBER, "=", (Object)number);
            QFilter f2 = new QFilter(ID, "!=", (Object)Long.valueOf(fid));
            QFilter[] filters = new QFilter[]{f1, f2};
            if (this.uniqueNumber) {
                filters = new QFilter[]{f2};
            }
            for (DynamicObject c : collection = BusinessDataServiceHelper.load((String)this.entryName, (String)FILEDS, (QFilter[])filters)) {
                Date sdate = c.getDate(STARTDATE);
                Date edate = c.getDate(ENDDATE);
                String cnumber = c.getString(NUMBER);
                String cname = c.getLocaleString(NAME).getLocaleValue();
                String emsg = String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u7a0e\u76ee\u53ca\u7a0e\u7387(\u7f16\u7801\uff1a%1$s,\u540d\u79f0\uff1a%2$s)", (String)"DateValiditySaveValidator_1", (String)"taxc-tpo", (Object[])new Object[0]), cnumber, cname);
                if (Objects.isNull(edate) && Objects.nonNull(enddate) && !sdate.after(enddate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"DateValiditySaveValidator_2", (String)"DateValiditySaveValidator_4", (Object[])new Object[0]));
                    break;
                }
                if (Objects.isNull(enddate) && Objects.nonNull(edate) && !startdate.after(edate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"DateValiditySaveValidator_3", (String)"DateValiditySaveValidator_5", (Object[])new Object[0]));
                    break;
                }
                if (Objects.isNull(edate) && Objects.isNull(enddate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"DateValiditySaveValidator_4", (String)"DateValiditySaveValidator_6", (Object[])new Object[0]));
                    break;
                }
                if (DateUtils.isEffectiveDate((Date)startdate, (Date)sdate, (Date)edate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"DateValiditySaveValidator_5", (String)"DateValiditySaveValidator_7", (Object[])new Object[0]));
                    break;
                }
                if (!Objects.nonNull(enddate) || !DateUtils.isEffectiveDate((Date)enddate, (Date)sdate, (Date)edate)) continue;
                errorMess.append(ResManager.loadKDString((String)emsg, (String)"DateValiditySaveValidator_6", (String)"DateValiditySaveValidator_8", (Object[])new Object[0]));
                break;
            }
            if (errorMess.length() <= 0) continue;
            this.addFatalErrorMessage(dataEntity, errorMess.toString());
        }
    }
}

