/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FcsApanageSaveOp
extends AbstractOperationServicePlugIn {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String APANAGE_AREA = "apanagearea";
    private static final String PROVINCE = "province";
    private static final String CITY = "city";
    private static final String APANAGE = "basedatafield";
    private static final String TAX_PAY_LIMIT = "taxpaylimit";
    private static final String FCS_BY_PRICE_LIMIT = "fcsbypricelimit";
    private static final String FCS_BY_HIRE_LIMIT = "fcsbyhirelimit";
    private static final String SELECTED_FIELDS = "fcsbyhirelimit,tdm_house_rental_edit.skssq,tdm_house_rental_edit.rent";
    private static final String FCS_APANAGE = "fcsapanage";
    private static final String FULL_NAME = "fullname";
    private static final String LOCATION_ENTITY_NAME = "bd_admindivision";
    private static final String FCS_ENTITY_NAME = "tpo_tcret_fcs_apanage";
    private static final String TDM_FCS_BASIC_INFO_ENTITY = "tdm_fcs_basic_info";
    private static final String HOUSE_RENTAL_INFO_ENTITY_NAME = "tdm_house_rental_info";
    private static final String HOUSE_RENTAL_EDIT_ENTITY_NAME = "tdm_house_rental_edit";
    private static final String REGEX = "_";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObjectCollection collection = QueryServiceHelper.query((String)FcsApanageSaveOp.FCS_ENTITY_NAME, (String)"number,name,id", null);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    QFilter fcsHireFilter;
                    DynamicObject[] fcsHireObjects;
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    String currentName = currentObj.getString(FcsApanageSaveOp.NAME);
                    String currentNumber = currentObj.getString(FcsApanageSaveOp.NUMBER);
                    for (DynamicObject c : collection) {
                        if (c.getString(FcsApanageSaveOp.ID).equals(currentObj.getString(FcsApanageSaveOp.ID))) continue;
                        String name = c.getString(FcsApanageSaveOp.NAME);
                        String number = c.getString(FcsApanageSaveOp.NUMBER);
                        if (name.equals(currentName)) {
                            this.addErrorMessage(dataEntity, FcsApanageSaveOp.getNameErrorMsg(name));
                            break;
                        }
                        if (!number.equals(currentNumber)) continue;
                        this.addErrorMessage(dataEntity, FcsApanageSaveOp.getNumberErrorMsg(number));
                        break;
                    }
                    FcsApanageSaveOp.this.addAddr(currentObj);
                    Object id = currentObj.get(FcsApanageSaveOp.ID);
                    QFilter filter = new QFilter(FcsApanageSaveOp.APANAGE, "=", id);
                    DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)FcsApanageSaveOp.TDM_FCS_BASIC_INFO_ENTITY, (String)FcsApanageSaveOp.TAX_PAY_LIMIT, (QFilter[])new QFilter[]{filter});
                    if (null != genericObjects && genericObjects.length != 0) {
                        FcsApanageSaveOp.this.updateFcsBasicInfo(genericObjects, currentObj.getString(FcsApanageSaveOp.FCS_BY_PRICE_LIMIT));
                    }
                    if (null == (fcsHireObjects = BusinessDataServiceHelper.load((String)FcsApanageSaveOp.HOUSE_RENTAL_INFO_ENTITY_NAME, (String)FcsApanageSaveOp.SELECTED_FIELDS, (QFilter[])new QFilter[]{fcsHireFilter = new QFilter(FcsApanageSaveOp.FCS_APANAGE, "=", id)})) || fcsHireObjects.length == 0) continue;
                    FcsApanageSaveOp.this.updateFcsHireInfo(fcsHireObjects, currentObj.getString(FcsApanageSaveOp.FCS_BY_HIRE_LIMIT));
                }
            }
        });
    }

    private void updateFcsHireInfo(DynamicObject[] genericObjects, String fcsbyhirelimit) {
        if (fcsbyhirelimit.equals(genericObjects[0].getString(FCS_BY_HIRE_LIMIT))) {
            return;
        }
        for (DynamicObject object : genericObjects) {
            object.set(FCS_BY_HIRE_LIMIT, (Object)fcsbyhirelimit);
            object.set(HOUSE_RENTAL_EDIT_ENTITY_NAME, null);
        }
        SaveServiceHelper.save((DynamicObject[])genericObjects);
    }

    private void updateFcsBasicInfo(DynamicObject[] genericObjects, String fcsbypricelimit) {
        if (fcsbypricelimit.equals(genericObjects[0].getString(TAX_PAY_LIMIT))) {
            return;
        }
        for (DynamicObject object : genericObjects) {
            object.set(TAX_PAY_LIMIT, (Object)fcsbypricelimit);
        }
        SaveServiceHelper.save((DynamicObject[])genericObjects);
    }

    private static String getNameErrorMsg(String name) {
        return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u623f\u4ea7\u7a0e\u5c5e\u5730\u7ba1\u7406\u540d\u79f0\uff1a%s", (String)"FcsApanageSaveOp_0", (String)"taxc-tpo", (Object[])new Object[0]), name);
    }

    private static String getNumberErrorMsg(String number) {
        return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u623f\u4ea7\u7a0e\u5c5e\u5730\u7ba1\u7406\u7f16\u7801: %s", (String)"FcsApanageSaveOp_1", (String)"taxc-tpo", (Object[])new Object[0]), number);
    }

    private void addAddr(DynamicObject currentObj) {
        String[] splitName;
        DynamicObject addr;
        String names;
        Long fieldId = currentObj.getLong(APANAGE_AREA);
        if (null != fieldId && !StringUtil.isEmpty((CharSequence)(names = (String)(addr = QueryServiceHelper.queryOne((String)LOCATION_ENTITY_NAME, (String)FULL_NAME, (QFilter[])new QFilter(ID, "=", (Object)fieldId).toArray())).get(0))) && (splitName = names.split(REGEX)).length >= 2) {
            currentObj.set(PROVINCE, (Object)splitName[0]);
            currentObj.set(CITY, (Object)splitName[1]);
        }
    }
}

