/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class PreRateSaveValidator
extends AbstractValidator {
    private static final String NUMBER = "number";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String FILEDS = "id,name,number,startdate,enddate";
    private static final String GENERAL = "general";
    private String entryName;

    public PreRateSaveValidator(String entryName) {
        this.entryName = entryName;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder errorMess = new StringBuilder();
            Boolean general = dataEntity.getDataEntity().getBoolean(GENERAL);
            if (!general.booleanValue()) continue;
            Long fid = dataEntity.getDataEntity().getLong(ID);
            Date startdate = dataEntity.getDataEntity().getDate(STARTDATE);
            Date enddate = dataEntity.getDataEntity().getDate(ENDDATE);
            QFilter f1 = new QFilter(ID, "!=", (Object)fid);
            QFilter f2 = new QFilter(GENERAL, "=", (Object)(general != false ? "1" : "0"));
            QFilter f3 = new QFilter("name.locale", "=", (Object)"zh_CN");
            QFilter[] filters = new QFilter[]{f1, f2, f3};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)this.entryName, (String)FILEDS, (QFilter[])filters);
            for (DynamicObject c : collection) {
                Date sdate = c.getDate(STARTDATE);
                Date edate = c.getDate(ENDDATE);
                String cnumber = c.getString(NUMBER);
                String cname = c.getString(NAME);
                String emsg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u901a\u7528\u9884\u5f81\u7387(\u7f16\u7801\uff1a%1$s,\u540d\u79f0\uff1a%2$s),\u8bf7\u5148\u53d6\u6d88\u901a\u7528!", (String)"PreRateSaveValidator_0", (String)"taxc-tpo", (Object[])new Object[0]), cnumber, cname);
                if (Objects.isNull(edate) && Objects.nonNull(enddate) && !sdate.after(enddate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"GeneralDateRangeSaveValidator_1", (String)"PreRateSaveValidator_4", (Object[])new Object[0]));
                    break;
                }
                if (Objects.isNull(enddate) && Objects.nonNull(edate) && !startdate.after(edate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"GeneralDateRangeSaveValidator_1", (String)"PreRateSaveValidator_4", (Object[])new Object[0]));
                    break;
                }
                if (Objects.isNull(edate) && Objects.isNull(enddate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"GeneralDateRangeSaveValidator_1", (String)"PreRateSaveValidator_4", (Object[])new Object[0]));
                    break;
                }
                if (DateUtils.isEffectiveDate((Date)startdate, (Date)sdate, (Date)edate)) {
                    errorMess.append(ResManager.loadKDString((String)emsg, (String)"GeneralDateRangeSaveValidator_1", (String)"PreRateSaveValidator_4", (Object[])new Object[0]));
                    break;
                }
                if (!Objects.nonNull(enddate) || !DateUtils.isEffectiveDate((Date)enddate, (Date)sdate, (Date)edate)) continue;
                errorMess.append(ResManager.loadKDString((String)emsg, (String)"GeneralDateRangeSaveValidator_2", (String)"PreRateSaveValidator_5", (Object[])new Object[0]));
                break;
            }
            if (errorMess.length() <= 0) continue;
            this.addFatalErrorMessage(dataEntity, errorMess.toString());
        }
    }
}

