/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class QhbbxmSaveOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new SaveDataValidator());
    }

    private static class SaveDataValidator
    extends AbstractValidator {
        private SaveDataValidator() {
        }

        public void validate() {
            List nameList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getString("name")).collect(Collectors.toList());
            List idList = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("id")).collect(Collectors.toList());
            QFilter nameQ = new QFilter("name", "in", nameList);
            QFilter idQ = new QFilter("id", "not in", idList);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"tpo_qhbbxm", (String)"name,validfrom,validto", (QFilter[])new QFilter[]{idQ, nameQ});
            HashMap map = new HashMap();
            collection.stream().forEach(o -> {
                String name = o.getString("name");
                if (ObjectUtils.isEmpty(map.get(name))) {
                    ArrayList<List<Date>> list = new ArrayList<List<Date>>(8);
                    List<Date> row = Arrays.asList(o.getDate("validfrom"), o.getDate("validto"));
                    list.add(row);
                    map.put(name, list);
                } else {
                    List list = (List)map.get(name);
                    List<Date> row = Arrays.asList(o.getDate("validfrom"), o.getDate("validto"));
                    list.add(row);
                }
            });
            block0: for (ExtendedDataEntity dataEntity : this.dataEntities) {
                List<Date> row2;
                DynamicObject dynamicObject = dataEntity.getDataEntity();
                String name = dynamicObject.getString("name");
                Date validfrom = dynamicObject.getDate("validfrom");
                Date validto = dynamicObject.getDate("validto");
                List list = (List)map.get(name);
                if (ObjectUtils.isNotEmpty((Object)list)) {
                    for (List<Date> row2 : list) {
                        Date[] date = DateUtils.getIntersectionDate((Date)((Date)row2.get(0)), (Date)((Date)row2.get(1)), (Date)validfrom, (Date)validto);
                        if (null == date) continue;
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u6709\u6548\u671f\u8d77\u6b62\u8303\u56f4\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u62a5\u8868\u9879\u76ee\u540d\u79f0\uff0c\u8bf7\u4fee\u6539", (String)"QhbbxmSaveOp_0", (String)"taxc-tpo", (Object[])new Object[0]));
                        continue block0;
                    }
                    List<Date> row3 = Arrays.asList(validfrom, validto);
                    list.add(row3);
                    continue;
                }
                ArrayList<List<Date>> newList = new ArrayList<List<Date>>(8);
                row2 = Arrays.asList(validfrom, validto);
                newList.add(row2);
                map.put(name, newList);
            }
        }
    }
}

