/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.tpo.business.depreciation.TaxDepreciationServiceHelper;

public class TaxDepreciationPolicyEnableOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("taxationsys");
        e.getFieldKeys().add("taxarea");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashSet<Long> taxationsysIds = new HashSet<Long>(10);
                HashSet<Long> taxareaIds = new HashSet<Long>(10);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Long taxareaId;
                    DynamicObject object = dataEntity.getDataEntity();
                    String entity = this.getEntityKey();
                    String depreciationtype = "tpo_js_depreciation".equals(entity) ? "jszj" : "ybzj";
                    String number = object.getString("number");
                    DynamicObject taxationsys = object.getDynamicObject("taxationsys");
                    DynamicObject taxarea = object.getDynamicObject("taxarea");
                    Long taxationsysId = taxationsys != null ? taxationsys.getLong("id") : 0L;
                    boolean isexist = TaxDepreciationServiceHelper.isExistDepreciation(entity, number, taxationsysId, taxareaId = Long.valueOf(taxarea != null ? taxarea.getLong("id") : 0L), depreciationtype);
                    if (isexist || taxationsysIds.contains(taxationsysId) && taxareaIds.contains(taxareaId)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u76f8\u540c\u7a0e\u5236\u548c\u8f96\u533a\u5df2\u5b58\u5728\u53ef\u7528\u7684\u7a0e\u52a1\u4e00\u822c\u6298\u65e7\u653f\u7b56\u3002", (String)"TaxDepreciationPolicyEnableOpPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                    }
                    taxationsysIds.add(taxationsysId);
                    taxareaIds.add(taxareaId);
                }
            }
        });
    }
}

