/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxarea.TaxcAreaDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TaxDepreciationPolicySaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("taxationsys");
        e.getFieldKeys().add("taxarea");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject object = dataEntity.getDataEntity();
                    DynamicObject taxarea = object.getDynamicObject("taxarea");
                    TaxResult taxareaTaxResult = TaxcAreaDataServiceHelper.loadTaxcAreaAvailable();
                    if (taxareaTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)taxareaTaxResult.getData()))) {
                        List areaAvailableGroupIds = ((List)taxareaTaxResult.getData()).stream().map(o -> o.getLong("group.id")).collect(Collectors.toList());
                        if (taxarea != null && !areaAvailableGroupIds.contains(taxarea.getLong("id"))) {
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPolicyPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                            return;
                        }
                    } else {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7a0e\u6536\u8f96\u533a\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"TaxDepreciationPolicyPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]));
                        return;
                    }
                    if (!object.containsProperty("entryentity")) continue;
                    DynamicObjectCollection entryentity = object.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entity : entryentity) {
                        Date enddate;
                        Date startdate = entity.getDate("startdate");
                        if (this.checkDate(startdate, enddate = entity.getDate("enddate"), dataEntity)) continue;
                        return;
                    }
                    String type = "";
                    if ("tpo_yb_depreciation".equals(this.getEntityKey())) {
                        type = ResManager.loadKDString((String)"\u7a0e\u52a1\u8d44\u4ea7\u7c7b\u522b", (String)"TaxDepreciationPolicyPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]);
                    } else if ("tpo_js_depreciation".equals(this.getEntityKey())) {
                        type = ResManager.loadKDString((String)"\u52a0\u901f\u6298\u65e7\u7c7b\u522b", (String)"TaxDepreciationPolicyPlugin_9", (String)"taxc-tpo", (Object[])new Object[0]);
                    }
                    if (entryentity.size() <= 1) continue;
                    Map<String, List<DynamicObject>> entryentityGroupByClassNumber = entryentity.stream().collect(Collectors.groupingBy(p -> p.getString("classnumber")));
                    for (Map.Entry<String, List<DynamicObject>> entry : entryentityGroupByClassNumber.entrySet()) {
                        Map<String, List<DynamicObject>> entryentityGroupByClass;
                        if (entry.getValue().size() > 1 && (entryentityGroupByClass = entry.getValue().stream().collect(Collectors.groupingBy(p -> p.getString("class")))).size() > 1) {
                            this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5%1$s\u7f16\u7801\u4e0b\u5b58\u5728\u540d\u79f0\u4e0d\u540c\u7684%2$s\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"TaxDepreciationPolicyPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), type, type));
                            return;
                        }
                        if (this.checkDate(entry.getValue())) continue;
                        this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5%s\u5728\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u6298\u65e7\u653f\u7b56\uff0c\u8bf7\u6838\u5bf9\u4fe1\u606f\u3002", (String)"TaxDepreciationPolicyPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]), type));
                        return;
                    }
                }
            }

            private boolean checkDate(Date skssqq, Date skssqz, ExtendedDataEntity dataEntity) {
                if (skssqq == null) {
                    return false;
                }
                int dayOfDate = DateUtils.getDayOfDate((Date)skssqq);
                if (dayOfDate != 1) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u5fc5\u987b\u662f\u6708\u521d\u3002", (String)"TaxDepreciationPolicyPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]));
                    return false;
                }
                if (skssqz != null) {
                    int dayOfDate2;
                    int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)skssqz));
                    if (dayOfDate1 != (dayOfDate2 = DateUtils.getDayOfDate((Date)skssqz))) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u6b62\u5fc5\u987b\u662f\u6708\u672b\u3002", (String)"TaxDepreciationPolicyPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]));
                        return false;
                    }
                    if (skssqq.after(skssqz)) {
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6709\u6548\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u671f\u6b62\u3002", (String)"TaxDepreciationPolicyPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]));
                        return false;
                    }
                }
                return true;
            }

            private boolean checkDate(List<DynamicObject> list) {
                if (list.size() > 1) {
                    for (int i = 0; i < list.size(); ++i) {
                        Date startdate = list.get(i).getDate("startdate");
                        Date enddate = list.get(i).getDate("enddate");
                        for (int j = 0; j < list.size(); ++j) {
                            Date enddate2;
                            Date startdate2;
                            boolean flag;
                            if (i == j || (flag = DateUtils.checkTimeRepeat((Date)startdate, (Date)enddate, (Date)(startdate2 = list.get(j).getDate("startdate")), (Date)(enddate2 = list.get(j).getDate("enddate"))))) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        });
    }
}

