/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tpo.opplugin.TaxRateNode;
import org.apache.commons.lang.StringUtils;

public class TaxRateImportPlugin
implements IImportPlugin {
    public final String YBJS = ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TaxRateImportPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]);
    private static final List<String> zoreList = new ArrayList<String>();
    public static final String ZORE_18 = "000000000000000000";
    public static final String ZORE_16 = "0000000000000000";
    public static final String ZORE_14 = "00000000000000";
    public static final String ZORE_12 = "000000000000";
    public static final String ZORE_10 = "0000000000";
    public static final String ZORE_08 = "00000000";
    public static final String ZORE_06 = "000000";
    public static final String ZORE_04 = "0000";
    public static final String ZORE_02 = "00";
    private static final Map<String, String> TAXMETHOD_MAP;
    private static final Map<String, String> TAXMETHOD_SPECIAL;
    private static final Map<String, String> TAXMETHOD_VAL;

    private String dealWithMergeCode(String code) {
        if (code != null) {
            for (String s : zoreList) {
                if (!code.endsWith(s)) continue;
                int i = code.indexOf(s);
                if (i % 2 == 0) {
                    ++i;
                }
                return code.substring(0, i);
            }
        }
        return code;
    }

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        DynamicObject dobj = this.saveTaxRate(data);
        this.handleDatasForTaxMethodAndRate(dobj);
        Object[] objects = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return Arrays.asList(objects);
    }

    private DynamicObject saveTaxRate(Map<String, Object> data) {
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            String shortNumber;
            String number = (String)data.get("number");
            DeleteServiceHelper.delete((String)"tpo_tcvat_taxrate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            Date now = new Date();
            DynamicObject taxRateObj = BusinessDataServiceHelper.newDynamicObject((String)"tpo_tcvat_taxrate");
            taxRateObj.set("number", (Object)number);
            taxRateObj.set("name", data.get("name"));
            taxRateObj.set("taxpayertype", data.get("taxpayertype"));
            taxRateObj.set("startdate", (Object)DateUtils.stringToDate((String)((String)data.get("startdate"))));
            if (data.get("enddate") != null) {
                taxRateObj.set("enddate", (Object)DateUtils.stringToDate((String)((String)data.get("enddate"))));
            }
            taxRateObj.set("status", (Object)"C");
            taxRateObj.set("enable", (Object)"1");
            taxRateObj.set("creator", (Object)RequestContext.get().getUserId());
            taxRateObj.set("modifier", (Object)RequestContext.get().getUserId());
            taxRateObj.set("createtime", (Object)now);
            taxRateObj.set("createtime", (Object)now);
            DynamicObjectCollection entryentity = taxRateObj.getDynamicObjectCollection("entryentity");
            List list = (List)data.get("entryentity");
            HashMap<String, TaxRateNode> map = new HashMap<String, TaxRateNode>(list.size());
            for (Map entryMap : list) {
                TaxRateNode taxRateNode = new TaxRateNode((String)entryMap.get("taxrate"), (String)entryMap.get("taxmethod"));
                shortNumber = this.dealWithMergeCode((String)entryMap.get("mergecode"));
                map.put(shortNumber, taxRateNode);
            }
            int i = 0;
            for (Map entryMap : list) {
                shortNumber = this.dealWithMergeCode((String)entryMap.get("mergecode"));
                DynamicObject object = entryentity.addNew();
                object.set("id", (Object)(number + shortNumber));
                object.set("subnumber", (Object)shortNumber);
                object.set("longnumber", (Object)this.getLongNumber(shortNumber));
                object.set("mergecode", entryMap.get("mergecode"));
                object.set("subname", entryMap.get("subname"));
                if (shortNumber.length() > 1) {
                    String key = shortNumber.substring(0, shortNumber.length() - 2);
                    if (StringUtils.isEmpty((String)key)) {
                        object.set("parent", (Object)(number + shortNumber));
                    } else {
                        object.set("parent", (Object)(number + key));
                    }
                }
                Map<String, String> taxMap = this.getTaxRateAndMethodMap(map, shortNumber);
                object.set("taxrate", (Object)taxMap.get("taxrate"));
                String taxmethod = taxMap.get("taxmethod");
                if (taxmethod == null || taxmethod.trim().isEmpty()) {
                    object.set("taxmethod", (Object)this.YBJS);
                } else {
                    object.set("taxmethod", (Object)(this.YBJS + "\u3001" + taxmethod));
                }
                Object sumitem = entryMap.get("sumitem");
                object.set("sumitem", sumitem);
                if (sumitem != null) {
                    object.set("isleaf", (Object)(!Boolean.parseBoolean(String.valueOf(sumitem)) ? 1 : 0));
                }
                object.set("subdescription", entryMap.get("description"));
                object.set("substatus", (Object)"C");
                object.set("subenable", (Object)"1");
                object.set("level", (Object)this.getLevelFromNumber(shortNumber));
                object.set("creator1", (Object)RequestContext.get().getUserId());
                object.set("createtime1", (Object)now);
                object.set("modifier1", (Object)RequestContext.get().getUserId());
                object.set("modifytime1", (Object)now);
                object.set("seq", (Object)i++);
            }
            DynamicObject dynamicObject = taxRateObj;
            return dynamicObject;
        }
        catch (Throwable e) {
            try {
                tx.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private int getLevelFromNumber(String shortNumber) {
        int length = shortNumber.length();
        return length / 2;
    }

    private Map<String, String> getTaxRateAndMethodMap(Map<String, TaxRateNode> map, String shortNumber) {
        HashSet<String> taxrateSet = new HashSet<String>();
        HashSet<String> taxmethodSet = new HashSet<String>();
        for (Map.Entry<String, TaxRateNode> next : map.entrySet()) {
            if (!next.getKey().startsWith(shortNumber)) continue;
            TaxRateNode taxRateNode = next.getValue();
            if (StringUtils.isNotBlank((String)taxRateNode.getTaxrate())) {
                taxrateSet.addAll(Arrays.asList(taxRateNode.getTaxrate().split("\u3001")));
            }
            if (!StringUtils.isNotBlank((String)taxRateNode.getTaxmethod())) continue;
            taxmethodSet.addAll(Arrays.asList(taxRateNode.getTaxmethod().split("\u3001")));
        }
        String taxrate = taxrateSet.stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.joining("\u3001"));
        String taxmethod = taxmethodSet.stream().filter(s -> !s.trim().isEmpty()).collect(Collectors.joining("\u3001"));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("taxrate", taxrate);
        result.put("taxmethod", taxmethod);
        return result;
    }

    private String getLongNumber(String shortNumber) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= shortNumber.length(); i += 2) {
            sb.append(shortNumber, 0, i);
            if (i == shortNumber.length()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    private DynamicObject createDynamicObject(String entryName, String name, String number, String fid) {
        QFilter q1 = new QFilter("name", "=", (Object)name);
        DynamicObject dispatchorder = BusinessDataServiceHelper.loadSingle((String)entryName, (String)"id,status,creator,enable,masterid,name,number", (QFilter[])new QFilter[]{q1});
        if (dispatchorder == null) {
            dispatchorder = BusinessDataServiceHelper.newDynamicObject((String)entryName);
            dispatchorder.set("id", (Object)fid);
        }
        dispatchorder.set("name", (Object)name);
        dispatchorder.set("number", (Object)number);
        dispatchorder.set("status", (Object)"C");
        dispatchorder.set("creator", (Object)"0");
        dispatchorder.set("enable", (Object)"1");
        dispatchorder.set("masterid", (Object)0);
        return dispatchorder;
    }

    private void handleDatasForTaxMethodAndRate(DynamicObject dobj) {
        String entryNameMethod = "tpo_tcvat_taxperiod";
        String entryNameRate = "tpo_tcvat_taxrates";
        List list = (List)dobj.get("entryentity");
        HashSet<String> methods = new HashSet<String>(list.size());
        HashSet<String> rates = new HashSet<String>(list.size());
        ArrayList<DynamicObject> methodList = new ArrayList<DynamicObject>(list.size());
        ArrayList<DynamicObject> rateList = new ArrayList<DynamicObject>(list.size());
        for (DynamicObject entryMap : list) {
            String[] rateArr;
            String string = (String)entryMap.get("taxmethod");
            String rateStr = (String)entryMap.get("taxrate");
            if (string != null && !string.isEmpty()) {
                String[] methodArr;
                for (String str : methodArr = string.split("\u3001")) {
                    methods.add(str);
                }
            }
            if (rateStr == null || rateStr.isEmpty()) continue;
            for (String str : rateArr = rateStr.split("\u3001")) {
                rates.add(str);
            }
        }
        Set<Map.Entry<String, String>> endtrySet = TAXMETHOD_SPECIAL.entrySet();
        for (Map.Entry<String, String> entry : endtrySet) {
            rates.add(entry.getValue());
        }
        for (String str : methods) {
            String number = TAXMETHOD_MAP.get(str);
            String fid = TAXMETHOD_VAL.get(number);
            methodList.add(this.createDynamicObject(entryNameMethod, str, number, fid));
        }
        for (String str : rates) {
            String fid = "0".equals(str.split("%")[0]) ? "101" : str.split("%")[0];
            rateList.add(this.createDynamicObject(entryNameRate, str, str, fid));
        }
        DynamicObject[] dynamicObjectArray2 = new DynamicObject[methodList.size()];
        dynamicObjectArray2 = methodList.toArray(dynamicObjectArray2);
        DynamicObject[] rateArr = new DynamicObject[rateList.size()];
        rateArr = rateList.toArray(rateArr);
        SaveServiceHelper.save((DynamicObject[])dynamicObjectArray2);
        SaveServiceHelper.save((DynamicObject[])rateArr);
    }

    static {
        zoreList.add(ZORE_18);
        zoreList.add(ZORE_16);
        zoreList.add(ZORE_14);
        zoreList.add(ZORE_12);
        zoreList.add(ZORE_10);
        zoreList.add(ZORE_08);
        zoreList.add(ZORE_06);
        zoreList.add(ZORE_04);
        zoreList.add(ZORE_02);
        TAXMETHOD_MAP = new HashMap<String, String>();
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e", (String)"TaxRateImportPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), "BZS");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u4e00\u822c\u8ba1\u7a0e", (String)"TaxRateImportPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), "YBJS");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u514d\u7a0e", (String)"TaxRateImportPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), "MS");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"TaxRateImportPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]), "JYZS_3");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"TaxRateImportPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]), "JYZS_5");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536\u4e14\u5373\u5f81\u5373\u900070%", (String)"TaxRateImportPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), "A_3_JYZSQJZJT_70");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536\u4e14\u5373\u5f81\u5373\u900050%", (String)"TaxRateImportPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]), "A_3_JYZSQJZJT_50");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (String)"TaxRateImportPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]), "A_5_JYZSJA_1.5_JZ");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5148\u5f81\u540e\u9000100%", (String)"TaxRateImportPlugin_8", (String)"taxc-tpo", (Object[])new Object[0]), "XZHT_100");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5148\u5f81\u540e\u900050%", (String)"TaxRateImportPlugin_9", (String)"taxc-tpo", (Object[])new Object[0]), "XZHT_0");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5148\u5f81\u540e\u9000", (String)"TaxRateImportPlugin_10", (String)"taxc-tpo", (Object[])new Object[0]), "XZHT");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u9000100%", (String)"TaxRateImportPlugin_11", (String)"taxc-tpo", (Object[])new Object[0]), "JZJT_100");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u900070%", (String)"TaxRateImportPlugin_12", (String)"taxc-tpo", (Object[])new Object[0]), "JZJT_70");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u900050%", (String)"TaxRateImportPlugin_13", (String)"taxc-tpo", (Object[])new Object[0]), "JZJT_50");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u5373\u5f81\u5373\u900030%", (String)"TaxRateImportPlugin_14", (String)"taxc-tpo", (Object[])new Object[0]), "JZJT_30");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000", (String)"TaxRateImportPlugin_15", (String)"taxc-tpo", (Object[])new Object[0]), "CSF_3_JZJT");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000", (String)"TaxRateImportPlugin_16", (String)"taxc-tpo", (Object[])new Object[0]), "CSF_8_JZJT");
        TAXMETHOD_MAP.put(ResManager.loadKDString((String)"\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000", (String)"TaxRateImportPlugin_17", (String)"taxc-tpo", (Object[])new Object[0]), "CSF_12_JZJT");
        TAXMETHOD_SPECIAL = new HashMap<String, String>();
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u4e0d\u5f81\u7a0e", (String)"TaxRateImportPlugin_1", (String)"taxc-tpo", (Object[])new Object[0]), "0%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u514d\u7a0e", (String)"TaxRateImportPlugin_2", (String)"taxc-tpo", (Object[])new Object[0]), "0%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536", (String)"TaxRateImportPlugin_3", (String)"taxc-tpo", (Object[])new Object[0]), "3%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536", (String)"TaxRateImportPlugin_4", (String)"taxc-tpo", (Object[])new Object[0]), "5%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (String)"TaxRateImportPlugin_7", (String)"taxc-tpo", (Object[])new Object[0]), "15%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536\u4e14\u5373\u5f81\u5373\u900070%", (String)"TaxRateImportPlugin_5", (String)"taxc-tpo", (Object[])new Object[0]), "3%");
        TAXMETHOD_SPECIAL.put(ResManager.loadKDString((String)"\u63093%\u7b80\u6613\u5f81\u6536\u4e14\u5373\u5f81\u5373\u900050%", (String)"TaxRateImportPlugin_6", (String)"taxc-tpo", (Object[])new Object[0]), "3%");
        TAXMETHOD_VAL = new HashMap<String, String>();
        TAXMETHOD_VAL.put("BZS", "1");
        TAXMETHOD_VAL.put("YBJS", "2");
        TAXMETHOD_VAL.put("MS", "3");
        TAXMETHOD_VAL.put("JYZS_3", "4");
        TAXMETHOD_VAL.put("JYZS_5", "5");
        TAXMETHOD_VAL.put("A_3_JYZSQJZJT_70", "6");
        TAXMETHOD_VAL.put("A_3_JYZSQJZJT_50", "7");
        TAXMETHOD_VAL.put("A_5_JYZSJA_1.5_JZ", "8");
        TAXMETHOD_VAL.put("XZHT_100", "9");
        TAXMETHOD_VAL.put("XZHT_0", "10");
        TAXMETHOD_VAL.put("XZHT", "11");
        TAXMETHOD_VAL.put("JZJT_100", "12");
        TAXMETHOD_VAL.put("JZJT_70", "13");
        TAXMETHOD_VAL.put("JZJT_50", "14");
        TAXMETHOD_VAL.put("JZJT_30", "15");
        TAXMETHOD_VAL.put("CSF_3_JZJT", "16");
        TAXMETHOD_VAL.put("CSF_8_JZJT", "17");
        TAXMETHOD_VAL.put("CSF_12_JZJT", "18");
    }
}

