/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TaxRefundInfoOp
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        DynamicObject[] taxRefundInfos = BusinessDataServiceHelper.load((Object[])Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tpo_tax_refund_info"));
        if ("confirmtaxrefund".equals(operationKey)) {
            Arrays.stream(taxRefundInfos).forEach(t -> {
                t.set("taxrefundstatus", (Object)"1");
                if (BigDecimal.ZERO.compareTo(t.getBigDecimal("actualrefundamount")) == 0) {
                    t.set("actualrefundamount", (Object)t.getBigDecimal("refundableamount"));
                }
                if (t.getDate("accountdate") == null) {
                    t.set("accountdate", (Object)new Date());
                }
            });
        }
        if ("canceltaxrefund".equals(operationKey)) {
            Arrays.stream(taxRefundInfos).forEach(t -> {
                t.set("taxrefundstatus", (Object)"0");
                t.set("accountdate", null);
                t.set("actualrefundamount", (Object)BigDecimal.ZERO);
            });
        }
        SaveServiceHelper.update((DynamicObject[])taxRefundInfos);
    }
}

