/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TdsysApanageSaveOp
extends AbstractOperationServicePlugIn {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String TDS_APANAGE = "tdsapanage";
    private static final String APANAGE_AREA = "apanagearea";
    private static final String TDS_LIMIT = "tdsyslimit";
    private static final String TDS_BASIC_LIMIT = "taxtimelimit";
    private static final String FULL_NAME = "fullname";
    private static final String PROVINCE = "province";
    private static final String CITY = "city";
    private static final String LOCATION_ENTITY_NAME = "bd_admindivision";
    private static final String TDSYS_ENTITY_NAME = "tpo_tcret_tds_apanage";
    private static final String TDS_BASIC_INFO_ENTITY_NAME = "tdm_tds_basic_info";
    private static final String REGEX = "_";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObjectCollection collection = QueryServiceHelper.query((String)TdsysApanageSaveOp.TDSYS_ENTITY_NAME, (String)"number,name,id", null);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    String currentName = currentObj.getString(TdsysApanageSaveOp.NAME);
                    String currentNumber = currentObj.getString(TdsysApanageSaveOp.NUMBER);
                    for (DynamicObject c : collection) {
                        if (c.getString(TdsysApanageSaveOp.ID).equals(currentObj.getString(TdsysApanageSaveOp.ID))) continue;
                        String name = c.getString(TdsysApanageSaveOp.NAME);
                        String number = c.getString(TdsysApanageSaveOp.NUMBER);
                        if (name.equals(currentName)) {
                            this.addErrorMessage(dataEntity, TdsysApanageSaveOp.getNameErrorMsg(name));
                            break;
                        }
                        if (!number.equals(currentNumber)) continue;
                        this.addErrorMessage(dataEntity, TdsysApanageSaveOp.getNumberErrorMsg(number));
                        break;
                    }
                    TdsysApanageSaveOp.this.addAddr(currentObj);
                    Object id = currentObj.get(TdsysApanageSaveOp.ID);
                    QFilter filter = new QFilter(TdsysApanageSaveOp.TDS_APANAGE, "=", id);
                    DynamicObject[] genericObjects = BusinessDataServiceHelper.load((String)TdsysApanageSaveOp.TDS_BASIC_INFO_ENTITY_NAME, (String)TdsysApanageSaveOp.TDS_BASIC_LIMIT, (QFilter[])new QFilter[]{filter});
                    if (null == genericObjects || genericObjects.length == 0) continue;
                    TdsysApanageSaveOp.this.updateTdsBasicInfo(genericObjects, (String)currentObj.get(TdsysApanageSaveOp.TDS_LIMIT));
                }
            }
        });
    }

    private void updateTdsBasicInfo(DynamicObject[] genericObjects, String fcsbypricelimit) {
        for (DynamicObject object : genericObjects) {
            object.set(TDS_BASIC_LIMIT, (Object)fcsbypricelimit);
        }
        SaveServiceHelper.save((DynamicObject[])genericObjects);
    }

    private static String getNameErrorMsg(String name) {
        return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u571f\u5730\u4f7f\u7528\u7a0e\u5c5e\u5730\u7ba1\u7406\u540d\u79f0\uff1a%s", (String)"TdsysApanageSaveOp_0", (String)"taxc-tpo", (Object[])new Object[0]), name);
    }

    private static String getNumberErrorMsg(String number) {
        return String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u571f\u5730\u4f7f\u7528\u7a0e\u5c5e\u5730\u7ba1\u7406\u7f16\u7801: %s", (String)"TdsysApanageSaveOp_1", (String)"taxc-tpo", (Object[])new Object[0]), number);
    }

    private void addAddr(DynamicObject currentObj) {
        String[] splitName;
        DynamicObject addr;
        String names;
        String fieldId = (String)currentObj.get(APANAGE_AREA);
        if (!StringUtil.isBlank((CharSequence)fieldId) && !StringUtil.isEmpty((CharSequence)(names = (String)(addr = QueryServiceHelper.queryOne((String)LOCATION_ENTITY_NAME, (String)FULL_NAME, (QFilter[])new QFilter(ID, "=", (Object)Long.valueOf(fieldId)).toArray())).get(0))) && (splitName = names.split(REGEX)).length >= 2) {
            currentObj.set(PROVINCE, (Object)splitName[0]);
            currentObj.set(CITY, (Object)splitName[1]);
        }
    }
}

