/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class TdzzsTaxRatePlugin
extends AbstractOperationServicePlugIn {
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObjectCollection tdzzsTaxrate;
                    Long fid = dataEntity.getDataEntity().getLong("id");
                    QFilter idFilter = new QFilter("id", "!=", (Object)fid);
                    Date startdate = dataEntity.getDataEntity().getDate(TdzzsTaxRatePlugin.STARTDATE);
                    if (startdate == null) continue;
                    Date enddate = dataEntity.getDataEntity().getDate(TdzzsTaxRatePlugin.ENDDATE);
                    QFilter enddateFilter = new QFilter(TdzzsTaxRatePlugin.ENDDATE, "is null", null).or(new QFilter(TdzzsTaxRatePlugin.ENDDATE, ">=", (Object)startdate));
                    QFilter startdateFilter = null;
                    if (enddate != null) {
                        startdateFilter = new QFilter(TdzzsTaxRatePlugin.STARTDATE, "<", (Object)DateUtils.getDayLast((Date)enddate));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)(tdzzsTaxrate = QueryServiceHelper.query((String)"tpo_tdzzs_taxrate", (String)"number,name", (QFilter[])new QFilter[]{idFilter, enddateFilter, startdateFilter})))) continue;
                    this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u7a0e\u7387\u8868\uff08\u7f16\u7801\uff1a%1$s,\u540d\u79f0\uff1a%2$s\uff09", (String)"TdzzsTaxRatePlugin_0", (String)"taxc-tpo", (Object[])new Object[0]), ((DynamicObject)tdzzsTaxrate.get(0)).getString("number"), ((DynamicObject)tdzzsTaxrate.get(0)).getString("name")));
                }
            }
        });
    }
}

