/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tpo.common.utils.TimeCheckUtil;

public class ZspmSaveAndEnableOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ZspmValidator());
    }

    private static class ZspmValidator
    extends AbstractValidator {
        private ZspmValidator() {
        }

        public void validate() {
            List<Object> zspmNames = new ArrayList();
            ArrayList<String> zspmNumbers = new ArrayList<String>();
            DynamicObjectCollection zspmByNnumbers = new DynamicObjectCollection();
            if (StringUtils.equals((CharSequence)"enable", (CharSequence)this.getOperateKey())) {
                for (ExtendedDataEntity dataEntity2 : this.dataEntities) {
                    if (StringUtils.equals((CharSequence)"1", (CharSequence)dataEntity2.getDataEntity().getString("enable"))) continue;
                    zspmNames.add(dataEntity2.getDataEntity().getString("name"));
                    zspmNumbers.add(dataEntity2.getDataEntity().getString("number"));
                }
                if (CollectionUtils.isEmpty(zspmNumbers)) {
                    return;
                }
                QFilter enableFilter = new QFilter("number", "in", zspmNumbers);
                zspmByNnumbers = QueryServiceHelper.query((String)"tpo_zspm", (String)"number,taxtype,starttime,endtime", (QFilter[])enableFilter.toArray());
            } else if (StringUtils.equals((CharSequence)"save", (CharSequence)this.getOperateKey())) {
                zspmNames = Arrays.stream(this.dataEntities).map(dataEntity -> dataEntity.getDataEntity().getString("name")).collect(Collectors.toList());
            }
            QFilter commonFilter = new QFilter("name", "in", zspmNames).and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection zspmByNames = QueryServiceHelper.query((String)"tpo_zspm", (String)"name,number,taxtype,starttime,endtime", (QFilter[])commonFilter.toArray());
            this.checkTime(this.dataEntities, zspmByNames, zspmByNnumbers);
        }

        private void checkTime(ExtendedDataEntity[] dataEntities, DynamicObjectCollection zspmByNames, DynamicObjectCollection zspmByNnumbers) {
            ArrayList<Map<String, Object>> successDatas = new ArrayList<Map<String, Object>>();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Long taxcTypeId;
                Date end;
                Date begin;
                String name = dataEntity.getDataEntity().getString("name");
                String number = dataEntity.getDataEntity().getString("number");
                if (StringUtils.equals((CharSequence)"save", (CharSequence)this.getOperateKey())) {
                    begin = dataEntity.getDataEntity().getDate("starttime");
                    if (!this.checkSingle(begin, end = dataEntity.getDataEntity().getDate("endtime"), taxcTypeId = Long.valueOf(dataEntity.getDataEntity().getDynamicObject("taxtype").getLong("id")), name, number, successDatas, zspmByNames)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6216\u4fdd\u5b58\u6570\u636e\u4e0e\u73b0\u5b58\u6570\u636e\u6709\u6548\u671f\u8303\u56f4\u51b2\u7a81\uff0c\u5f15\u5165\u6216\u4fdd\u5b58\u5931\u8d25", (String)"ZspmSaveAndEnableOp_0", (String)"taxc-tpo", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"enable", (CharSequence)this.getOperateKey()) || StringUtils.equals((CharSequence)"1", (CharSequence)dataEntity.getDataEntity().getString("enable"))) continue;
                for (DynamicObject byNnumber : zspmByNnumbers) {
                    if (!StringUtils.equals((CharSequence)number, (CharSequence)byNnumber.getString("number"))) continue;
                    taxcTypeId = byNnumber.getLong("taxtype");
                    begin = byNnumber.getDate("starttime");
                    if (!this.checkSingle(begin, end = byNnumber.getDate("endtime"), taxcTypeId, name, number, successDatas, zspmByNames)) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u76f8\u540c\u5f81\u6536\u54c1\u76ee\u7684\u7981\u7528\u6570\u636e\u4e0e\u542f\u7528\u6570\u636e\u5b58\u5728\u6709\u6548\u671f\u8303\u56f4\u51b2\u7a81\uff0c\u65e0\u6cd5\u542f\u7528", (String)"ZspmSaveAndEnableOp_1", (String)"taxc-tpo", (Object[])new Object[0]), new Object[0]));
                }
            }
        }

        private boolean checkSingle(Date begin, Date end, Long taxcTypeId, String name, String number, List<Map<String, Object>> successDatas, DynamicObjectCollection zspmByNames) {
            for (Map<String, Object> datum : successDatas) {
                if (!StringUtils.equals((CharSequence)name, (CharSequence)((String)datum.get("name"))) || !taxcTypeId.equals(datum.get("taxcTypeId"))) continue;
                Date endtime = null;
                if (datum.get("endtime") != null) {
                    endtime = (Date)datum.get("endTime");
                }
                if (TimeCheckUtil.timeCheck(begin, end, (Date)datum.get("startTime"), endtime)) continue;
                return true;
            }
            for (DynamicObject zspm : zspmByNames) {
                Date date2;
                Date date1;
                if (!StringUtils.equals((CharSequence)name, (CharSequence)zspm.getString("name")) || !taxcTypeId.equals(zspm.getLong("taxtype")) || StringUtils.equals((CharSequence)number, (CharSequence)zspm.getString("number")) || TimeCheckUtil.timeCheck(begin, end, date1 = zspm.getDate("starttime"), date2 = zspm.getDate("endtime"))) continue;
                return true;
            }
            HashMap<String, Object> successData = new HashMap<String, Object>();
            successData.put("name", name);
            successData.put("taxcTypeId", taxcTypeId);
            successData.put("startTime", begin);
            successData.put("endTime", end);
            successDatas.add(successData);
            return false;
        }
    }
}

