/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bd.admindivision.AdminDivisionDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tpo.business.zys.ZysTaxitemService;

public class ZysTaxitemSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("admindivision");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                List<Long> dataAdmindivisionIds = Arrays.stream(this.dataEntities).map(o -> o.getDataEntity().getLong("admindivision")).collect(Collectors.toList());
                Map<Long, String> dataProvinceMap = this.dealprovinceMap(dataAdmindivisionIds);
                DynamicObjectCollection existObjects = ZysTaxitemService.queryZysTaxitem();
                List ids = existObjects.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                List<Long> admindivisionIds = existObjects.stream().map(o -> o.getLong("admindivision")).collect(Collectors.toList());
                Map<Long, String> existProvinceMap = this.dealprovinceMap(admindivisionIds);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String province;
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    if (CollectionUtils.isEmpty((Collection)existObjects) || dynamicObject == null || dataProvinceMap.get(dynamicObject.getLong("admindivision")) == null || !existProvinceMap.containsValue(province = dataProvinceMap.get(dynamicObject.getLong("admindivision"))) || ids.contains(dynamicObject.getLong("id"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u201c\u5c5e\u5730\u533a\u57df\u201d\u5df2\u5b58\u5728\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ZysTaxitemSaveOpPlugin_0", (String)"taxc-tpo", (Object[])new Object[0]));
                }
            }

            private Map<Long, String> dealprovinceMap(List<Long> admindivisionIds) {
                Map<Long, List> locationMap = new HashMap();
                HashMap<Long, String> provinceMap = new HashMap<Long, String>();
                TaxResult taxResult = AdminDivisionDataServiceHelper.getPathNameByIds(admindivisionIds);
                if (taxResult.isSuccess() && EmptyCheckUtils.isNotEmpty((Object)taxResult.getData())) {
                    locationMap = (Map)taxResult.getData();
                    locationMap.forEach((key, value) -> provinceMap.put((Long)key, value != null ? (String)value.get(0) : ""));
                }
                return provinceMap;
            }
        });
    }
}

