/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin.sdsjt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DraftTabSettingOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject[] tabs = BusinessDataServiceHelper.load((String)"tpo_provision_tab", (String)"number", (QFilter[])new QFilter[]{new QFilter("systemset", "=", (Object)"1")});
                List systemsetNumbers = Arrays.stream(tabs).map(o -> o.getString("number")).collect(Collectors.toList());
                List numbers = Arrays.stream(tabs).map(o -> o.getString("number")).collect(Collectors.toList());
                List<Long> validTaxationsys = DraftTabSettingOp.this.getValidTaxationsys();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    MulBasedataDynamicObjectCollection dynamicObjectCollection = (MulBasedataDynamicObjectCollection)dynamicObject.get("taxationsys");
                    boolean exitFlag = Boolean.FALSE;
                    for (DynamicObject obj : dynamicObjectCollection) {
                        long id = obj.getLong("fbasedataid.id");
                        if (validTaxationsys.contains(id)) continue;
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6709\u6548\u7684\u7a0e\u6536\u5236\u5ea6\uff1a%s", (String)"DraftTabSettingOp_0", (String)"taxc-tpo", (Object[])new Object[0]), obj.getString("fbasedataid.name")));
                        exitFlag = Boolean.TRUE;
                    }
                    if (exitFlag) break;
                    if (!systemsetNumbers.contains(dynamicObject.getString("number"))) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u8bbe\u7684\u6570\u636e\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"DraftTabSettingOp_1", (String)"taxc-tpo", (Object[])new Object[0]), new Object[0]));
                }
            }
        });
    }

    public List<Long> getValidTaxationsys() {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>();
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("activedate", "<=", (Object)new Date());
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)"bd_taxationsys", (String)"id,number,expdate", (QFilter[])new QFilter[]{filter})) {
            if (bd.getDate("expdate") != null && bd.getDate("expdate").getTime() < new Date().getTime()) continue;
            bids.add(bd.getLong("id"));
        }
        return bids;
    }
}

