/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin.tctf.article;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.tpo.common.enums.ArticleFieldTagEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ArticleOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object)dataEntities)) {
                    return;
                }
                Map vas = this.getOption().getVariables();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dyo = dataEntity.getDataEntity();
                    if ("submit".equals(operateKey) && "true".equals(vas.get("islistviewop4mutex"))) continue;
                    try {
                        Date releasedate = (Date)dyo.get("releasedate");
                        Date effectdate = (Date)dyo.get("effectdate");
                        Date expdate = (Date)dyo.get("expdate");
                        if (vas.containsKey("importtype") && Stream.of("new").anyMatch(p -> p.equals(vas.get("importtype")))) {
                            dyo.set("billstatus", (Object)"C");
                        }
                        if (effectdate != null && expdate != null && effectdate.compareTo(expdate) > 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"ArticleOp_0", (String)"taxc-tpo", (Object[])new Object[0]));
                            continue;
                        }
                        if (releasedate != null && expdate != null && releasedate.compareTo(expdate) > 0) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u53d1\u5e03\u65e5\u671f\u3002", (String)"ArticleOp_1", (String)"taxc-tpo", (Object[])new Object[0]));
                            continue;
                        }
                        String texttitle = dyo.getString("texttitle");
                        MulBasedataDynamicObjectCollection organs = (MulBasedataDynamicObjectCollection)dyo.get("organ");
                        List orgIds = organs.stream().map(m -> m.getLong("fbasedataid.id")).distinct().collect(Collectors.toList());
                        String issuednum = dyo.getString("issuednum");
                        QFilter filter = new QFilter("texttitle", "=", (Object)texttitle).and("issuednum", "=", (Object)issuednum).and("id", "!=", (Object)dyo.getLong("id"));
                        DynamicObject[] tpoTaxArticles = BusinessDataServiceHelper.load((String)"tpo_tax_article", (String)"id,texttitle,issuednum,organ", (QFilter[])filter.toArray());
                        boolean exists = false;
                        for (DynamicObject tpoTaxArticle : tpoTaxArticles) {
                            MulBasedataDynamicObjectCollection localOrgans = (MulBasedataDynamicObjectCollection)tpoTaxArticle.get("organ");
                            List collect = localOrgans.stream().map(m -> m.getLong("fbasedataid.id")).distinct().collect(Collectors.toList());
                            boolean equalCollection = CollectionUtils.isEqualCollection(orgIds, collect);
                            if (!equalCollection) continue;
                            exists = true;
                            break;
                        }
                        if (exists) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u6807\u9898\u3001\u53d1\u6587\u673a\u5173\u3001\u53d1\u6587\u5b57\u53f7\u6570\u636e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ArticleOp_2", (String)"taxc-tpo", (Object[])new Object[0]));
                            continue;
                        }
                        List<String> keys = Arrays.asList("filetypes", "taxtypes", "areas", "industries", "others", "influences", "organ");
                        for (String fieldKey : keys) {
                            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
                            List<Object> tagRootNumbers = new ArrayList(8);
                            ArticleFieldTagEnum articleFieldEnum = ArticleFieldTagEnum.getEnumMetaByFieldKey(fieldKey);
                            if (articleFieldEnum != null) {
                                tagRootNumbers = articleFieldEnum.getTagRootNumbers();
                            }
                            QFilter qFilter = new QFilter("tag.number", "in", tagRootNumbers).and("enable", "=", (Object)true).and("isleaf", "=", (Object)false);
                            DynamicObjectCollection treeTag = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,number,tag.number", (QFilter[])qFilter.toArray());
                            List<Long> ids = treeTag.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
                            HashSet childIds = new HashSet(8);
                            if (CollectionUtils.isNotEmpty(ids)) {
                                DynamicObjectCollection allTags = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,name,number,parent", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
                                ids.forEach(id -> ArticleOp.this.getChildIdsIncludeSelf(id, (List)allTags, childIds));
                            }
                            qFilters.add(new QFilter("enable", "=", (Object)true));
                            qFilters.add(new QFilter("id", "in", childIds));
                            qFilters.add(new QFilter("showtypies", "like", (Object)"%,article,%"));
                            qFilters.add(new QFilter("isleaf", "=", (Object)"1"));
                            LinkedHashSet<Long> fieldKeyIds = new LinkedHashSet<Long>(8);
                            MulBasedataDynamicObjectCollection mulBasedata = (MulBasedataDynamicObjectCollection)dyo.get(fieldKey);
                            if (!CollectionUtils.isNotEmpty((Collection)mulBasedata)) continue;
                            for (DynamicObject sbxmxx : mulBasedata) {
                                fieldKeyIds.add(sbxmxx.getLong("fbasedataid.id"));
                            }
                            qFilters.add(new QFilter("id", "in", fieldKeyIds));
                            DynamicObjectCollection objects = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
                            if (objects.size() == fieldKeyIds.size()) continue;
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b57\u6bb5\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ArticleOp_3", (String)"taxc-tpo", (Object[])new Object[0]));
                            break;
                        }
                        ArticleOp.this.setToatlTags(dyo);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void setToatlTags(DynamicObject dyo) {
        List<String> keys = Arrays.asList("filetypes", "taxtypes", "areas", "industries", "others", "influences");
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(8);
        for (String key : keys) {
            MulBasedataDynamicObjectCollection mulBasedata = (MulBasedataDynamicObjectCollection)dyo.get(key);
            if (!CollectionUtils.isNotEmpty((Collection)mulBasedata)) continue;
            for (DynamicObject sbxmxx : mulBasedata) {
                ids.add(sbxmxx.getLong("fbasedataid.id"));
            }
        }
        MulBasedataDynamicObjectCollection totaltags = (MulBasedataDynamicObjectCollection)dyo.get("totaltags");
        totaltags.clear();
        ArrayList idList = new ArrayList(ids);
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] treeTags = BusinessDataServiceHelper.load((String)"tpo_tree_tag", (String)MetadataUtil.getAllFieldToQuery((String)"tpo_tree_tag"), (QFilter[])qFilter.toArray());
        Map<Long, List<DynamicObject>> map = Arrays.stream(treeTags).collect(Collectors.groupingBy(r -> r.getLong("id")));
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : idList) {
                DynamicObject dynamicObject = totaltags.addNew();
                List objects = map.getOrDefault(id, new ArrayList());
                if (objects.size() != 1) continue;
                DynamicObject object = (DynamicObject)objects.get(0);
                dynamicObject.set("fbasedataid", (Object)object);
                dynamicObject.set("fbasedataid_id", (Object)id);
            }
        }
    }

    private void getChildIdsIncludeSelf(Long parentId, List<DynamicObject> allTags, Set<Long> childIdsIncludeSelf) {
        if (CollectionUtils.isEmpty(allTags)) {
            return;
        }
        childIdsIncludeSelf.add(parentId);
        List childTags = allTags.stream().filter(m -> parentId.compareTo(m.getLong("parent")) == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childTags)) {
            return;
        }
        for (DynamicObject childTag : childTags) {
            long id = childTag.getLong("id");
            childIdsIncludeSelf.add(id);
            this.getChildIdsIncludeSelf(id, allTags, childIdsIncludeSelf);
        }
    }
}

