/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tpo.opplugin.tctf.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class TreeTagOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object)dataEntities)) {
                    return;
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dyo = dataEntity.getDataEntity();
                    long parentId = 0L;
                    long tagId = 0L;
                    Object parent = dyo.get("parent");
                    Object tag = dyo.get("tag");
                    if (parent instanceof DynamicObject) {
                        parentId = dyo.get("parent") == null ? 0L : dyo.getLong("parent.id");
                    } else if (parent instanceof Long) {
                        parentId = dyo.getLong("parent");
                    }
                    if (tag instanceof DynamicObject) {
                        tagId = dyo.get("tag") == null ? 0L : dyo.getLong("tag.id");
                    } else if (tag instanceof Long) {
                        tagId = dyo.getLong("tag");
                    }
                    QFilter filter = new QFilter("parent", "=", (Object)parentId).and("tag", "=", (Object)tagId).and("id", "!=", (Object)dyo.getLong("id"));
                    DynamicObject otherTreeTag = QueryServiceHelper.queryOne((String)"tpo_tree_tag", (String)"id,tag.name", (QFilter[])filter.toArray());
                    if (otherTreeTag != null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u4e0a\u7ea7\u6807\u7b7e\u4e0b\uff0c\u201c%s\u201d\u6807\u7b7e\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TreeTagOp_0", (String)"taxc-tpo", (Object[])new Object[0]), otherTreeTag.getString("tag.name")));
                        continue;
                    }
                    boolean issystem = dyo.getBoolean("issystem");
                    if (issystem) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\uff0c\u4e0d\u80fd\u7f16\u8f91\u3002", (String)"TreeTagOp_1", (String)"taxc-tpo", (Object[])new Object[0]));
                        continue;
                    }
                    QFilter qFilter = new QFilter("id", "=", (Object)tagId);
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tag", (String)"id,number,name", (QFilter[])qFilter.toArray());
                    String name = dynamicObject == null ? "" : dynamicObject.getString("name");
                    dyo.set("name", (Object)name);
                    QFilter parentFilter = new QFilter("id", "=", (Object)parentId);
                    DynamicObject parentTreeTag = QueryServiceHelper.queryOne((String)"tpo_tree_tag", (String)"id,showtypies", (QFilter[])parentFilter.toArray());
                    if (parentTreeTag == null) continue;
                    String showtypies = StringUtils.isNotEmpty((CharSequence)parentTreeTag.getString("showtypies")) ? parentTreeTag.getString("showtypies") : null;
                    dyo.set("showtypies", (Object)showtypies);
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject[] treeTags;
            DynamicObjectCollection allTags = QueryServiceHelper.query((String)"tpo_tree_tag", (String)"id,name,number,parent", (QFilter[])new QFilter("id", "!=", (Object)0L).toArray());
            String showtypies = dataEntity.getString("showtypies");
            ArrayList<Long> childIds = new ArrayList<Long>(8);
            this.getChildIds(dataEntity.getLong("id"), (List<DynamicObject>)allTags, childIds);
            if (!CollectionUtils.isNotEmpty(childIds)) continue;
            for (DynamicObject treeTag : treeTags = BusinessDataServiceHelper.load((Object[])childIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tpo_tree_tag"))) {
                treeTag.set("showtypies", (Object)showtypies);
                updateList.add(treeTag);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }

    private void getChildIds(Long parentId, List<DynamicObject> allTags, List<Long> childIds) {
        List childTags = allTags.stream().filter(m -> parentId.compareTo(m.getLong("parent")) == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childTags)) {
            return;
        }
        for (DynamicObject childTag : childTags) {
            long id = childTag.getLong("id");
            childIds.add(id);
            this.getChildIds(id, allTags, childIds);
        }
    }
}

