/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.baseinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.StatusConvert;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PageShowCommon;

public class DeclareChannelInfoConfigListPlugin
extends AbstractListPlugin {
    private static final String CHANNEL = "declarechannel";
    private static final String CHANNEL_NAME = "channelName";
    private static final String TAXORGAN_COPY = "taxorgancopy";
    private static final String TAXORGAN_NUMBER = "taxorganNumber";
    private static final String TAXTYPE_COPY = "taxtypecopy";
    private static final String TAXORGAN = "taxorgan";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BILLNO = "billno";
    private static final String TSATE_DECLARE_CHANNEL = "tsate_declare_channel";
    private static final String ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY = "id,channel,taxorgancopy,taxtypecopy,billno,declarechannel";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Delete) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billlist.getSelectedRows();
            if (rows == null || rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DeclareChannelInfoConfigListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        } else if (args.getSource() instanceof Donothing && "tbsynuser".equals(((Donothing)args.getSource()).getOperateKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tsate_declare_dynuser", (IFormView)this.getView(), null);
        } else if (args.getSource() instanceof Donothing && "tbsynsh".equals(((Donothing)args.getSource()).getOperateKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tsate_declare_dynsh", (IFormView)this.getView(), null);
        } else if (args.getSource() instanceof StatusConvert && "enable".equalsIgnoreCase(((StatusConvert)args.getSource()).getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            DynamicObject[] selectObjs = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY, (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)listSelectedData.getPrimaryKeyValues()).and("enable", "=", (Object)"0")});
            ArrayList<DynamicObject> allEableChannels = new ArrayList<DynamicObject>();
            allEableChannels.addAll(Arrays.asList(objs));
            allEableChannels.addAll(Arrays.asList(selectObjs));
            StringBuilder failMessage = new StringBuilder();
            for (DynamicObject selectObj : selectObjs) {
                allEableChannels.remove(selectObj);
                DynamicObjectCollection taxorgancopy = selectObj.getDynamicObjectCollection(TAXORGAN_COPY);
                DynamicObjectCollection taxtypecopy = selectObj.getDynamicObjectCollection(TAXTYPE_COPY);
                String billno = selectObj.getString(BILLNO);
                this.dealChannelRelation(allEableChannels, args, taxorgancopy, taxtypecopy, failMessage, billno);
            }
            if (failMessage.length() > 0) {
                this.dealMessage(failMessage);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        this.getPageCache().remove("defaultchannel");
        this.getPageCache().remove("channel");
        List<ComboItem> channelComboItem = this.getChannelComboItem();
        for (FilterColumn column : filterColumnList) {
            if (!column.getFieldName().startsWith("declarechannel.")) continue;
            CommonFilterColumn channelColumn = (CommonFilterColumn)column;
            if (CollectionUtils.isEmpty(channelComboItem)) continue;
            channelColumn.setDefaultValue(this.getPageCache().get("defaultchannel"));
            channelColumn.setComboItems(channelComboItem);
        }
        this.getView().setVisible(Boolean.valueOf(SupplierEnum.SZYH.getCode().equals(this.getPageCache().get("channel"))), new String[]{"tbsynuser", "tbsynsh"});
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("declarechannel.enable", "=", (Object)"1"));
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        Object object = args.getFilterValue("declarechannel.id");
        if (object == null) {
            return;
        }
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)object, (String)"tsate_channel");
        if (dyn != null) {
            String channel = dyn.getString(NUMBER);
            boolean flag = SupplierEnum.SZYH.getCode().equals(channel);
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"tbsynuser", "tbsynsh"});
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("tsate_channel".equals(args.getRefEntityId())) {
            QFilter q = new QFilter("enable", "=", (Object)"1");
            args.getCustomQFilters().add(q);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List channels = this.getControlFilters().getFilter("declarechannel.id");
        if (!CollectionUtils.isEmpty((Collection)channels)) {
            String channel = this.getControlFilters().getFilter("declarechannel.id").get(0).toString();
            e.getParameter().getShowParameter().getCustomParams().put(CHANNEL, channel);
        }
    }

    private void dealChannelRelation(List<DynamicObject> tobjs, BeforeDoOperationEventArgs args, DynamicObjectCollection inputorgans, DynamicObjectCollection inputypes, StringBuilder failMessage, String billno) {
        HashMap records = new HashMap();
        for (DynamicObject dynamicObject : tobjs) {
            DynamicObjectCollection taxorgans = (DynamicObjectCollection)dynamicObject.get(TAXORGAN_COPY);
            DynamicObjectCollection taxtypes = (DynamicObjectCollection)dynamicObject.get(TAXTYPE_COPY);
            DynamicObject declarechannel = dynamicObject.getDynamicObject(CHANNEL);
            String channelName = declarechannel == null ? "" : declarechannel.getString(NAME);
            for (DynamicObject taxorgan : taxorgans) {
                Iterator iterator = taxtypes.iterator();
                while (iterator.hasNext()) {
                    DynamicObject taxtype = (DynamicObject)iterator.next();
                    String organid = ((DynamicObject)taxorgan.get(1)).getString(ID);
                    String typename = ((DynamicObject)taxtype.get(1)).getString(NAME);
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(NUMBER, dynamicObject.getString(BILLNO));
                    temp.put(TAXORGAN_COPY, ((DynamicObject)taxorgan.get(1)).getString(NAME));
                    temp.put(TAXTYPE_COPY, ((DynamicObject)taxtype.get(1)).getString(NAME));
                    temp.put(CHANNEL_NAME, channelName);
                    records.put(organid + typename, temp);
                }
            }
        }
        ArrayList cdbf = new ArrayList(12);
        for (DynamicObject inputorgan : inputorgans) {
            for (DynamicObject inputype : inputypes) {
                String organid = ((DynamicObject)inputorgan.get(1)).getString(ID);
                String typename = ((DynamicObject)inputype.get(1)).getString(NAME);
                if (!records.containsKey(organid + typename)) continue;
                cdbf.add(records.get(organid + typename));
                cdbf.add(records.get(organid + typename));
            }
        }
        if (cdbf.size() > 0) {
            HashSet<String> hashSet = new HashSet<String>(16);
            for (Map cdb : cdbf) {
                String number = (String)cdb.get(NUMBER);
                String organ = (String)cdb.get(TAXORGAN_COPY);
                String type = (String)cdb.get(TAXTYPE_COPY);
                String key = number + organ + type;
                if (hashSet.contains(key)) continue;
                failMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff1a\u7533\u62a5\u7a0e\u5c40\u4e3a\u201c%2$s\u201d\u3001\u7a0e\u79cd\u4e3a\u201c%3$s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u53ef\u7528\u7684\u901a\u9053\u8bb0\u5f55\u201c%4$s \u7f16\u53f7%5$s\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u6307\u5b9a\u3002", (String)"DeclareChannelInfoConfigListPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), billno, organ, type, cdb.get(CHANNEL_NAME), number)).append(SEPARATOR);
                hashSet.add(key);
            }
            args.setCancel(true);
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)message)) {
                    return;
                }
                int i = message.toString().indexOf("\uff1a", 1) + 1;
                this.getView().showErrorNotification(message.substring(i, message.length()));
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private List<ComboItem> getChannelComboItem() {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tsate_channel", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(objs.length);
        int index = -1;
        int orgIndex = -1;
        for (DynamicObject obj : objs) {
            ++index;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(obj.getString(NAME)));
            item.setValue(obj.getString(ID));
            combos.add(item);
            if (!"3".equals(obj.getString(NUMBER))) continue;
            orgIndex = index;
            this.getPageCache().put("defaultchannel", obj.getString(ID));
            this.getPageCache().put("channel", obj.getString(NUMBER));
        }
        if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get("defaultchannel")) && !CollectionUtils.isEmpty(combos)) {
            this.getPageCache().put("defaultchannel", ((ComboItem)combos.get(0)).getValue());
        }
        if (orgIndex > 0) {
            Collections.swap(combos, 0, orgIndex);
        }
        return combos;
    }
}

