/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.baseinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;

public class DeclareChannelInfoConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CHANNEL = "declarechannel";
    private static final String TAXORGAN_COPY = "taxorgancopy";
    private static final String CHANNEL_NAME = "channelName";
    private static final String TAXTYPE_COPY = "taxtypecopy";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BILLNO = "billno";
    private static final String TSATE_DECLARE_CHANNEL = "tsate_declare_channel";
    private static final String ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY = "id,declarechannel,channel,taxorgancopy,taxtypecopy,billno";
    private static final String TAXORGAN = "taxorgan";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(TAXORGAN_COPY);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit1 = (BasedataEdit)this.getControl(TAXTYPE_COPY);
        basedataEdit1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object obj;
        if (args.getSource() instanceof Save && (obj = this.getModel().getValue(TAXORGAN_COPY)) != null) {
            long rid = this.getModel().getDataEntity().getLong(ID);
            DynamicObject[] channels = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY, (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)rid)});
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)ID_CHANNEL_TAXORGANCOPY_TAXTYPECOPY, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
            ArrayList<DynamicObject> tobjs = new ArrayList<DynamicObject>(Arrays.asList(objs));
            if (channels != null && channels.length > 0) {
                tobjs.removeIf(o -> channels[0].getString(ID).equals(o.getString(ID)));
            }
            DynamicObjectCollection inputorgans = (DynamicObjectCollection)this.getModel().getValue(TAXORGAN_COPY);
            DynamicObjectCollection inputypes = (DynamicObjectCollection)this.getModel().getValue(TAXTYPE_COPY);
            this.dealChannelRelation(tobjs, args, inputorgans, inputypes);
        }
    }

    private void dealChannelRelation(List<DynamicObject> tobjs, BeforeDoOperationEventArgs args, DynamicObjectCollection inputorgans, DynamicObjectCollection inputypes) {
        HashMap records = new HashMap();
        for (DynamicObject dynamicObject : tobjs) {
            DynamicObjectCollection taxorgans = (DynamicObjectCollection)dynamicObject.get(TAXORGAN_COPY);
            DynamicObjectCollection taxtypes = (DynamicObjectCollection)dynamicObject.get(TAXTYPE_COPY);
            DynamicObject declareChannel = dynamicObject.getDynamicObject(CHANNEL);
            String channelName = declareChannel == null ? "" : declareChannel.getString(NAME);
            for (DynamicObject taxorgan : taxorgans) {
                for (DynamicObject taxtype : taxtypes) {
                    String organid = ((DynamicObject)taxorgan.get(1)).getString(ID);
                    String typename = ((DynamicObject)taxtype.get(1)).getString(NAME);
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put(NUMBER, dynamicObject.getString(BILLNO));
                    temp.put(TAXORGAN_COPY, ((DynamicObject)taxorgan.get(1)).getString(NAME));
                    temp.put(TAXTYPE_COPY, ((DynamicObject)taxtype.get(1)).getString(NAME));
                    temp.put(CHANNEL_NAME, channelName);
                    records.put(organid + typename, temp);
                }
            }
        }
        ArrayList cdbf = new ArrayList(12);
        for (DynamicObject inputorgan : inputorgans) {
            for (DynamicObject inputype : inputypes) {
                String organid = ((DynamicObject)inputorgan.get(1)).getString(ID);
                String typename = ((DynamicObject)inputype.get(1)).getString(NAME);
                if (!records.containsKey(organid + typename)) continue;
                cdbf.add(records.get(organid + typename));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (cdbf.size() > 0) {
            HashSet<String> results = new HashSet<String>();
            for (Map cdb : cdbf) {
                String number = (String)cdb.get(NUMBER);
                String organ = (String)cdb.get(TAXORGAN_COPY);
                String type = (String)cdb.get(TAXTYPE_COPY);
                String key = number + organ + type;
                if (results.contains(key)) continue;
                stringBuilder.append(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u7a0e\u5c40\u4e3a\u201c%1$s\u201d\u3001\u7a0e\u79cd\u4e3a\u201c%2$s\u201d\u7684\u7ec4\u5408\u503c\u5df2\u5b58\u5728\u53ef\u7528\u7684\u901a\u9053\u8bb0\u5f55\u201c%3$s \u7f16\u53f7%4$s\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u6307\u5b9a\u3002", (String)"DeclareChannelInfoConfigListPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), organ, type, cdb.get(CHANNEL_NAME), number)).append(SEPARATOR);
                results.add(key);
            }
            args.setCancel(true);
            this.dealMessage(stringBuilder);
        }
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.equals(TAXORGAN_COPY)) {
            this.getModel().setValue(TAXTYPE_COPY, null);
        } else if (CHANNEL.equals(name)) {
            this.getModel().setValue(TAXORGAN_COPY, null);
            this.getModel().setValue(TAXTYPE_COPY, null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldKey, (CharSequence)TAXORGAN_COPY)) {
            if (EmptyCheckUtils.isEmpty((Object)this.getModel().getValue(CHANNEL))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7533\u62a5\u901a\u9053\u201d\u3002", (String)"DeclareChannelInfoConfigPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObject channelObj = (DynamicObject)this.getModel().getValue(CHANNEL);
            qFilter.and(new QFilter(CHANNEL, "=", (Object)channelObj.getLong(ID)));
            DynamicObject[] temp = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)"id,taxorgan", (QFilter[])new QFilter[]{qFilter});
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(true);
            if (temp != null && temp.length > 0) {
                List taxOrganIds = Arrays.stream(temp).map(o -> o.getDynamicObject(TAXORGAN).getLong(ID)).collect(Collectors.toList());
                QFilter idQFilter = new QFilter(ID, "in", taxOrganIds);
                formShowParameter.getListFilterParameter().setFilter(idQFilter);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(idQFilter);
                formShowParameter.getTreeFilterParameter().setQFilters(qFilters);
            } else {
                formShowParameter.getListFilterParameter().setFilter(new QFilter(ID, "=", (Object)-1));
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter(ID, "=", (Object)-1));
                formShowParameter.getTreeFilterParameter().setQFilters(qFilters);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)fieldKey, (CharSequence)TAXTYPE_COPY)) {
            DynamicObject[] querys;
            DynamicObjectCollection taxorgans = (DynamicObjectCollection)this.getModel().getValue(TAXORGAN_COPY);
            if (null == taxorgans || taxorgans.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7533\u62a5\u7a0e\u5c40\u201d\u3002", (String)"DeclareChannelInfoConfigPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> taxorganId = new ArrayList<Long>(taxorgans.size());
            for (DynamicObject taxorgan : taxorgans) {
                long id = ((DynamicObject)taxorgan.get(1)).getLong(ID);
                taxorganId.add(id);
            }
            DynamicObject channelObj = (DynamicObject)this.getModel().getValue(CHANNEL);
            DynamicObject[] qys = querys = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)"sblx", (QFilter[])new QFilter[]{new QFilter(TAXORGAN, "in", taxorganId).and(CHANNEL, "=", (Object)channelObj.getLong(ID))});
            ArrayList<String> tids = new ArrayList<String>(12);
            for (DynamicObject qy : qys) {
                DynamicObjectCollection colls = (DynamicObjectCollection)qy.get("sblx");
                for (DynamicObject object : colls) {
                    if (object == null || object.get(1) == null) continue;
                    DynamicObject dyo = (DynamicObject)object.get(1);
                    tids.add(dyo.getString(ID));
                }
            }
            HashMap<Long, List> result = new HashMap<Long, List>();
            for (DynamicObject qy : qys) {
                DynamicObjectCollection colls = (DynamicObjectCollection)qy.get("sblx");
                for (DynamicObject object : colls) {
                    if (object == null || object.get(1) == null) continue;
                    DynamicObject dyo = (DynamicObject)object.get(1);
                    if (result.containsKey(qy.getLong(ID))) {
                        List rs = (List)result.get(qy.getLong(ID));
                        rs.add(dyo.getString(ID));
                        result.put(qy.getLong(ID), rs);
                        continue;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(dyo.getString(ID));
                    result.put(qy.getLong(ID), list);
                }
            }
            Collection values = result.values();
            if (values.size() > 1) {
                for (List next : values) {
                    tids.retainAll(next);
                }
            }
            ListShowParameter ls = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ls.getListFilterParameter().setFilter(new QFilter(ID, "in", tids));
            ls.setMultiSelect(true);
            ls.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7533\u62a5\u7a0e\u79cd", (String)"DeclareChannelInfoConfigPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject e) {
        Object pk;
        DynamicObject[] load;
        if (this.getView().getFormShowParameter().getCustomParam(CHANNEL) != null) {
            String channel = this.getView().getFormShowParameter().getCustomParam(CHANNEL).toString();
            this.getView().getModel().setValue(CHANNEL, (Object)channel);
        }
        if ((load = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)"id,enable", (QFilter[])new QFilter[]{new QFilter(ID, "=", pk = this.getModel().getDataEntity().getPkValue())})) != null && load.length > 0) {
            boolean hasSpecificPerm;
            if (EmptyCheckUtils.isNotEmpty((Object)pk) && !StringUtils.equals((CharSequence)"0", (CharSequence)String.valueOf(pk)) && !(hasSpecificPerm = PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4715a0df000000ac"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"save", TAXORGAN_COPY, TAXTYPE_COPY});
            }
            if ("0".equalsIgnoreCase(load[0].getString("enable"))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"save", TAXORGAN_COPY, TAXTYPE_COPY});
            }
        }
    }
}

