/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.baseinfo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.tsate.common.util.DBUtils;

public class DeclareChannelUpgradePlugin
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(DeclareChannelUpgradePlugin.class);
    private static final String TSATE_DECLARE_CHANNEL = "tsate_declare_channel";
    private static final String TSATE_CHANNEL_CONFIG = "tsate_channel_config";
    private static final String T_TSATE_DECLARE_TAXORGAN = "t_tsate_declare_taxorgan";
    private static final String T_TSATE_DECLARE_TAXTYPE = "t_tsate_declare_taxtype";

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    private void update() {
        DynamicObject[] dyos;
        Boolean isExist = this.metaIsExist(TSATE_DECLARE_CHANNEL);
        if (!isExist.booleanValue()) {
            this.addLog(ERROR, String.format("The %s is not exist!", TSATE_DECLARE_CHANNEL));
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)TSATE_DECLARE_CHANNEL, (String)"id,channel,taxorgan", (QFilter[])new QFilter[0]);
        this.addLog(INFO, "SELECT fid,ftaxorganid FROM t_tsate_channel_config");
        List qys = DBUtils.query((String)"SELECT fid,ftaxorganid FROM t_tsate_channel_config");
        this.addLog(INFO, "SELECT DISTINCT fid from t_tsate_declare_taxorgan");
        List taxorgans = DBUtils.query((String)"SELECT DISTINCT fid from t_tsate_declare_taxorgan;");
        HashMap<Long, Long> temp = new HashMap<Long, Long>(12);
        for (Map taxorgan : taxorgans) {
            temp.put((Long)taxorgan.get("FID"), (Long)taxorgan.get("FID"));
        }
        Iterator iterator = qys.iterator();
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        while (iterator.hasNext()) {
            Map next = (Map)iterator.next();
            if (temp.get(next.get("FID")) != null) {
                iterator.remove();
                continue;
            }
            map.put((Long)next.get("FID"), (Long)next.get("FTAXORGANID"));
        }
        for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)TSATE_DECLARE_CHANNEL, (String)"id,channel,taxorgan,taxorgancopy,taxtypecopy,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())})) {
            if (map.get(dyo.getLong("id")) != null && !"0".equals(((DynamicObject)dyo.get("taxorgan")).getString("id"))) {
                ArrayList<Long> list = new ArrayList<Long>();
                ArrayList<String> ls = new ArrayList<String>();
                list.add(((DynamicObject)dyo.get("taxorgan")).getLong("id"));
                ls.add("zzsybnsr");
                DeclareChannelUpgradePlugin.buildBaseDataIds(list, dyo, "taxorgancopy");
                DeclareChannelUpgradePlugin.buildBaseDataIds1(ls, dyo, "taxtypecopy");
            }
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            String number = codeRuleService.getNumber(TSATE_DECLARE_CHANNEL, dyo, null);
            this.addLog(INFO, ResManager.loadKDString((String)"\u751f\u6210\u7684\u7f16\u7801\uff1a%s", (String)"DeclareChannelUpgradePlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[]{number}));
            dyo.set("billno", (Object)number);
        }
        DynamicObject[] saves = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dyos);
        this.addLog(INFO, ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u6210\u529f\uff0c\u5171\uff1a%s\u6761", (String)"DeclareChannelUpgradePlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[]{saves.length}));
        for (DynamicObject save : saves) {
            this.addLog(INFO, save.getString("id"));
        }
    }

    private static void buildBaseDataIds(List<Long> ids, DynamicObject dynamicObject, String targetFieldName) {
        DataEntityPropertyCollection dpc = dynamicObject.getDataEntityType().getProperties();
        ids.stream().forEach(o -> {
            DynamicObject dynamicObj = ((DynamicObjectCollection)dynamicObject.get(((IDataEntityProperty)dpc.get((Object)targetFieldName)).getName())).addNew();
            dynamicObj.set("fbasedataid", o);
        });
    }

    private static void buildBaseDataIds1(List<String> ids, DynamicObject dynamicObject, String targetFieldName) {
        DataEntityPropertyCollection dpc = dynamicObject.getDataEntityType().getProperties();
        ids.stream().forEach(o -> {
            DynamicObject dynamicObj = ((DynamicObjectCollection)dynamicObject.get(((IDataEntityProperty)dpc.get((Object)targetFieldName)).getName())).addNew();
            dynamicObj.set("fbasedataid", o);
        });
    }
}

