/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.baseinfo;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.OrgUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TreeUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.lang3.StringUtils;

public class DeclareInfoConfigListPlugin
extends AbstractListPlugin {
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private String orgField = null;
    private static Map<String, Object> cacheQFilterMap = new HashMap<String, Object>(16);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.getOrgField();
        if (this.orgField == null) {
            return;
        }
        CommonFilterColumn orgColumn = this.getOrgFilterColumn(filterColumnList);
        if (orgColumn == null) {
            return;
        }
        List<ComboItem> combos = this.getOrgComboItem();
        String defaultOrg = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (defaultOrg == null && !combos.isEmpty()) {
            defaultOrg = combos.get(0).getValue();
        }
        orgColumn.setDefaultValue(defaultOrg);
        orgColumn.setType("enum");
        orgColumn.setComboItems(combos);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put("customfilter", new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put("FieldName", fieldName);
                if (filterColumn.getFieldName().startsWith(this.orgField + ".")) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(defaultOrg);
                    customFiter.put("Value", value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put("Value", filterColumn.getDefaultValues());
                }
                if (customFiter.get("Value") == null) continue;
                this.filterValues.get("customfilter").add(customFiter);
            }
            this.customfilter = this.filterValues.get("customfilter");
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put("customfilter", customfilterSer);
            this.getPageCache().put("CACHE_DEFAULT_ORG", defaultOrg);
            this.getPageCache().put("verifyOrg", defaultOrg);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObjectCollection objs;
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tsate_declare_config");
        DynamicObject org = object.getDynamicObject("org");
        if ("nsrmc".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            this.showTargetForm(org.getLong("id"));
        } else if ("validatestatus".equals(args.getHyperLinkClickEvent().getFieldName()) && !CollectionUtils.isEmpty((Collection)(objs = QueryServiceHelper.query((String)"tsate_declare_record", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")).and(new QFilter("executetype", "=", (Object)"SJYZ"))}, (String)"createtime desc")))) {
            this.showTargetForm(((DynamicObject)objs.get(0)).getLong("id"), "tsate_declare_record");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List<Long> orgIds = this.getOrgListHasPermission();
        List qFilters = e.getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            boolean isHasOrg = qFilters.stream().filter(o -> o.getProperty().startsWith("org.")).findFirst().isPresent();
            if (!isHasOrg && !CollectionUtils.isEmpty(orgIds)) {
                e.getQFilters().add(new QFilter("org", "in", orgIds));
            }
        } else if (!CollectionUtils.isEmpty(orgIds)) {
            e.getQFilters().add(new QFilter("org", "in", orgIds));
        }
        cacheQFilterMap.put(this.getPageCache().getPageId(), e.getQFilters());
    }

    public void itemClick(ItemClickEvent evt) {
        BillList billlist = (BillList)this.getControl("billlistap");
        if ("tblrefresh".equals(evt.getItemKey())) {
            billlist.refresh();
            this.refreshStatus();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl("billlistap");
            if ("sjyz".equals(args.getOperateKey())) {
                ListSelectedRowCollection list = billlist.getSelectedRows();
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"DeclareInfoConfigListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org, unifiedsocialcode", null);
                if (!CollectionUtils.isEmpty((Collection)taxOrgs)) {
                    Map<Long, String> taxOrgMap = taxOrgs.stream().collect(Collectors.toMap(o -> o.getLong("org"), o -> o.getString("unifiedsocialcode"), (key1, key2) -> key1));
                    Object[] pkIds = list.getPrimaryKeyValues();
                    DynamicObject[] configs = BusinessDataServiceHelper.load((String)"tsate_declare_config", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_config"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds).and(new QFilter("validatestatus", "!=", (Object)"3"))});
                    if (configs != null && configs.length > 0) {
                        for (DynamicObject obj : configs) {
                            HashMap<String, Object> paramMap = new HashMap<String, Object>();
                            DynamicObject org = obj.getDynamicObject("org");
                            paramMap.put("nsrsbh", taxOrgMap.get(org.getLong("id")));
                            DynamicObject[] recordLog = DeclareInfoConfigListPlugin.assembleDeclareRecord(org.getLong("id"), "SJYZ");
                            DynamicObject recordObj = recordLog[0];
                            paramMap.put("recordid", recordObj.getLong("id"));
                            paramMap.put("key", "verify");
                            paramMap.put("configid", obj.getLong("id"));
                            Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                            Date skssqz = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                            paramMap.put("skssqq", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
                            paramMap.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
                            paramMap.put("type", "zzsybnsr");
                            obj.set("validatestatus", (Object)"3");
                            paramMap.put("supplier", SupplierEnum.ZWY.getCode());
                            JobUtils.submitJob(paramMap);
                        }
                        SaveServiceHelper.save((DynamicObject[])configs);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u9a8c\u8bc1\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u67e5\u770b\u9a8c\u8bc1\u7ed3\u679c\u6216\u524d\u5f80\u4efb\u52a1\u76d1\u63a7\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"DeclareInfoConfigListPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                        billlist.refresh();
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8bb0\u5f55\u90fd\u5728\u9a8c\u8bc1\u4e2d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u9a8c\u8bc1\u3002", (String)"DeclareInfoConfigListPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("sbblx".equals(columnDesc.getKey())) {
            this.dealSbblx(e);
        } else if ("nsrmc".equals(columnDesc.getKey()) || "nsrsbh".equals(columnDesc.getKey())) {
            this.dealNsrxx(e, columnDesc);
        }
    }

    private void dealNsrxx(PackageDataEvent e, AbstractColumnDesc columnDesc) {
        DynamicObject data = e.getRowData();
        if (data == null) {
            return;
        }
        DynamicObject org = data.getDynamicObject("org");
        if (org == null) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"taxpayer, unifiedsocialcode", (QFilter[])new QFilter[]{qFilter});
        if (temp != null) {
            if ("nsrmc".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("taxpayer"));
            } else if ("nsrsbh".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("unifiedsocialcode"));
            }
        }
    }

    private void dealSbblx(PackageDataEvent e) {
        Set taxTypes;
        DynamicObject data = e.getRowData();
        if (data.getDynamicObject("taxorgan") == null) {
            return;
        }
        QFilter qFilter = new QFilter("taxorgan", "=", (Object)data.getDynamicObject("taxorgan").getLong("id"));
        DynamicObject[] baseObjs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)"id,sblx,logintype", (QFilter[])new QFilter[]{qFilter});
        if (baseObjs != null && baseObjs.length > 0 && !CollectionUtils.isEmpty(taxTypes = Arrays.stream(baseObjs).filter(o -> o != null && !CollectionUtils.isEmpty((Collection)o.getDynamicObjectCollection("sblx"))).flatMap(o -> o.getDynamicObjectCollection("sblx").stream()).filter(k -> k != null && k.getDynamicObject("fbasedataid") != null).map(k -> k.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet()))) {
            e.setFormatValue((Object)StringUtils.join(taxTypes, (String)" "));
        }
    }

    private String getOrgField() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_declare_config");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            BasedataProp decProp;
            if (!(property instanceof BasedataProp) || !"bos_org".equals((decProp = (BasedataProp)property).getBaseEntityId())) continue;
            this.orgField = decProp.getName();
            break;
        }
        return this.orgField;
    }

    private CommonFilterColumn getOrgFilterColumn(List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(this.orgField + ".") || !(filterColumn instanceof CommonFilterColumn)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return null;
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"tsate_declare_config"}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    private void showTargetForm(Long orgId) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{new QFilter("orgid", "=", (Object)orgId)});
        if (obj != null) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tctb_tax_info_home");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowTitle(true);
            showParameter.setCustomParam("listOrgId", (Object)String.valueOf(orgId));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taxOrgInfo");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    private void showTargetForm(Long pkId, String formId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(formId);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)pkId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgId, String executeType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", null);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", null);
        dynamicObject.set("type", null);
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("executetype", (Object)executeType);
        dynamicObject.set("channel", (Object)SupplierEnum.ZWY.getCode());
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void refreshStatus() {
        DynamicObjectCollection dynamicObjects;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("validatestatus", "=", (Object)"3");
        qFilters.add(qFilter);
        if (cacheQFilterMap.get(this.getPageCache().getPageId()) != null) {
            qFilters.addAll((List)cacheQFilterMap.get(this.getPageCache().getPageId()));
        }
        if (!CollectionUtils.isEmpty((Collection)(dynamicObjects = QueryServiceHelper.query((String)"tsate_declare_config", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_config"), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]))))) {
            List<Long> orgIds = dynamicObjects.stream().map(o -> o.getLong("org")).collect(Collectors.toList());
            Map<Long, String> taxOrgMap = this.getTaxOrgMap(orgIds);
            DynamicObjectCollection records = QueryServiceHelper.query((String)"tsate_declare_record", (String)"id, org, executestatus, type, executetype", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds).and(new QFilter("executestatus", "=", (Object)"1")).and(new QFilter("createtime", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)new Date()))).and(new QFilter("createtime", "<=", (Object)DateUtils.getLastDateOfMonth((Date)new Date()))).and(new QFilter("executetype", "=", (Object)"SJYZ"))});
            if (!CollectionUtils.isEmpty((Collection)records)) {
                Map<Long, List<DynamicObject>> recordMap = records.stream().collect(Collectors.groupingBy(a -> a.getLong("org")));
                for (DynamicObject obj : dynamicObjects) {
                    List<DynamicObject> recordObjs = recordMap.get(obj.getLong("org"));
                    if (CollectionUtils.isEmpty(recordObjs)) continue;
                    for (DynamicObject record : recordObjs) {
                        JSONObject customMap = new JSONObject();
                        Long orgId = record.getLong("org");
                        customMap.put("recordid", record.getLong("id"));
                        customMap.put("key", "verify");
                        customMap.put("isQuery", true);
                        customMap.put("nsrsbh", taxOrgMap.get(orgId));
                        customMap.put("formPkId", obj.get("id"));
                        Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                        Date skssqz = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                        customMap.put("skssqq", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
                        customMap.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
                        customMap.put("type", "zzsybnsr");
                        customMap.put("supplier", SupplierEnum.ZWY.getCode());
                        JobUtils.submitJob((Map<String, Object>)customMap);
                    }
                }
            }
        }
    }

    private Map<Long, String> getTaxOrgMap(List<Long> orgIds) {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org, unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        Map<Long, String> taxOrgMap = new HashMap<Long, String>();
        if (!CollectionUtils.isEmpty((Collection)taxOrgs)) {
            taxOrgMap = taxOrgs.stream().collect(Collectors.toMap(o -> o.getLong("org"), o -> o.getString("unifiedsocialcode"), (key1, key2) -> key1));
        }
        return taxOrgMap;
    }

    private List<Long> getOrgListHasPermission() {
        DynamicObjectCollection col;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgs != null && !hasPermOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)(col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false)))) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }
}

