/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.baseinfo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import org.apache.commons.lang3.StringUtils;

public class DeclareInfoConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String[] LOGIN_FIELDS = new String[]{"org", "taxorgan", "logintype", "taxusername", "taxpassword", "telephone", "taxmanname", "taxmanpassword", "capassword", "jghm", "jgport"};
    private static final String[] NULL_FIELDS = new String[]{"taxorgan", "nsrsbh", "nsrmc"};
    private static final List<SupplierEnum> CHANNELS = Arrays.asList(SupplierEnum.YZF, SupplierEnum.QXY);

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("taxorgan");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        boolean isCopy;
        boolean bl = isCopy = this.getView().getFormShowParameter().getCustomParam("iscopy") != null ? (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy") : false;
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) && !isCopy) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"jgmb", "capassword"});
            this.getModel().setValue("logintype", null);
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl("logintype");
            comboEdit.setComboItems(null);
        } else {
            this.dealFields();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (Arrays.asList(LOGIN_FIELDS).contains(e.getProperty().getName())) {
            this.getModel().setValue("validatestatus", (Object)"0");
            this.getModel().setDataChanged(false);
        }
        if (e.getProperty().getName().equals("org")) {
            this.buildFormFiledValueByOrgId();
        } else if (e.getProperty().getName().equals("taxorgan")) {
            this.dealData();
        } else if (e.getProperty().getName().equals("logintype")) {
            this.dealFields();
        }
    }

    private void buildFormFiledValueByOrgId() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        this.setNullValue(NULL_FIELDS);
        if (org == null) {
            return;
        }
        Long id = org.getLong("id");
        Long taxorganId = BastaxTaxorgBusiness.queryTopTaxauthorityByOrgId((Long)id);
        this.getModel().setValue("taxorgan", (Object)taxorganId);
        DynamicObject temp = BastaxTaxorgBusiness.queryTaxcOrgInfoByOrgId((Long)id);
        if (temp == null) {
            return;
        }
        this.getModel().setValue("nsrmc", (Object)temp.getString("entry_taxpayer"));
        this.getModel().setValue("nsrsbh", (Object)temp.getString("entry_unifiedsocialcode"));
    }

    private void setNullValue(String[] orgChangeFields) {
        for (String field : orgChangeFields) {
            this.getModel().setValue(field, null);
        }
    }

    private void dealFields() {
        String value = String.valueOf(this.getModel().getValue("logintype"));
        FieldEdit fieldEdit = (FieldEdit)this.getControl("telephone");
        FieldEdit caEdit = (FieldEdit)this.getControl("capassword");
        FieldEdit jghmEdit = (FieldEdit)this.getControl("jghm");
        FieldEdit jgportEdit = (FieldEdit)this.getControl("jgport");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)value)) {
            fieldEdit.setMustInput(true);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"jgmb", "capassword"});
        } else if (StringUtils.equals((CharSequence)"3", (CharSequence)value)) {
            fieldEdit.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"jgmb", "capassword"});
            caEdit.setMustInput(true);
            jghmEdit.setMustInput(true);
            jgportEdit.setMustInput(true);
        } else if (StringUtils.equals((CharSequence)"2", (CharSequence)value) || StringUtils.equals((CharSequence)"4", (CharSequence)value) || StringUtils.equals((CharSequence)"6", (CharSequence)value) || StringUtils.equals((CharSequence)"5", (CharSequence)value) || StringUtils.isBlank((CharSequence)value)) {
            fieldEdit.setMustInput(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"jgmb", "capassword"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"taxorgan")) {
            QFilter qFilter = new QFilter("parent", "is null", null).or(new QFilter("parent", "=", (Object)0L));
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            ArrayList<QFilter> treeFilters = new ArrayList<QFilter>();
            treeFilters.add(qFilter);
            treeFilterParameter.setQFilters(treeFilters);
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"sblx")) {
            Object obj = this.getModel().getValue("taxorgan");
            if (obj != null) {
                DynamicObject dynamicObject = (DynamicObject)obj;
                QFilter qFilter = new QFilter("taxorgan", "=", (Object)dynamicObject.getLong("id"));
                DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_channel", (String)"id,channel, declarechannel", (QFilter[])new QFilter[]{qFilter});
                if (temp != null) {
                    QFilter baseFilter;
                    DynamicObject[] baseObjs;
                    DynamicObject channelObj = temp.getDynamicObject("declarechannel");
                    if (channelObj != null && (baseObjs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)"id,sblx", (QFilter[])new QFilter[]{baseFilter = new QFilter("declarechannel", "=", (Object)channelObj.getLong("id"))})) != null && baseObjs.length > 0) {
                        List sblxIds = Arrays.stream(baseObjs).flatMap(o -> o.getDynamicObjectCollection("sblx").stream()).map(k -> k.getDynamicObject("fbasedataid").getString("id")).collect(Collectors.toList());
                        QFilter idQFilter = new QFilter("id", "in", sblxIds);
                        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7c7b\u578b", (String)"DeclareInfoConfigPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                        formShowParameter.getListFilterParameter().setFilter(idQFilter);
                    }
                } else {
                    formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)-1));
                }
            }
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            List<Object> orgList = new ArrayList();
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                orgList = hasPermOrgResult.getHasPermOrgs();
            } else {
                DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty(orgList)) {
                orgList = DeclareInfoConfigPlugin.excludeByTaxPayer(orgList);
            }
            QFilter idsFilter = new QFilter("id", "in", orgList);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().setFilter(idsFilter.and(statusFilter));
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"DeclareInfoConfigPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && args.getOperateKey().equals("save")) {
            this.dealSyncData(args);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object obj;
        if (args.getSource() instanceof Save && (obj = this.getModel().getValue("org")) != null) {
            DynamicObject[] objs;
            Object nsrsbh = this.getModel().getValue("nsrsbh");
            if (EmptyCheckUtils.isEmpty((Object)nsrsbh)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"DeclareInfoConfigPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = (DynamicObject)obj;
            QFilter qFilter = new QFilter("org", "=", (Object)dynamicObject.getLong("id"));
            if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                Long pkId = this.getModel().getDataEntity().getLong("id");
                qFilter.and(new QFilter("id", "!=", (Object)pkId));
            }
            if ((objs = BusinessDataServiceHelper.load((String)"tsate_declare_config", (String)"id", (QFilter[])new QFilter[]{qFilter})) != null && objs.length > 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u5141\u8bb8\u5b58\u5728\u4e24\u6761\u914d\u7f6e\u6570\u636e\u3002", (String)"DeclareInfoConfigPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void dealSyncData(AfterDoOperationEventArgs args) {
        Object obj = this.getModel().getValue("taxorgan");
        if (EmptyCheckUtils.isEmpty((Object)obj)) {
            return;
        }
        DynamicObject taxcOrganObj = (DynamicObject)obj;
        Long organId = taxcOrganObj.getLong("id");
        Set<SupplierEnum> needSyncDatas = DeclareInfoConfigPlugin.getNeedSyncData(organId);
        if (!DeclareInfoConfigPlugin.isNeedSyncData(needSyncDatas)) {
            return;
        }
        Map<String, Object> commonParamMap = this.buildCommonParam(organId);
        for (SupplierEnum supplier : needSyncDatas) {
            ApiResult result;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.putAll(commonParamMap);
            paramMap.put("type", "zzsybnsr");
            paramMap.put("supplier", supplier.getCode());
            DynamicObject areaObj = DeclareInfoConfigPlugin.getAreaInfoByNsrsbh(organId, supplier);
            if (areaObj != null) {
                paramMap.put("sbdq", areaObj.getString("xzqh"));
            }
            if ((result = this.doCompanyBusiness(paramMap)).getSuccess()) continue;
            this.getView().showErrorNotification(supplier.getName() + ":" + result.getMessage());
            args.getOperationResult().setSuccess(false);
            args.getOperationResult().setShowMessage(false);
            return;
        }
    }

    private ApiResult doCompanyBusiness(Map<String, Object> paramMap) {
        return (ApiResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{paramMap});
    }

    private Map<String, Object> buildCommonParam(Long organId) {
        HashMap<String, Object> commonParamMap = new HashMap<String, Object>();
        commonParamMap.put("nsrsbh", this.getModel().getValue("nsrsbh"));
        commonParamMap.put("key", "verify");
        Date skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
        Date skssqz = DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
        commonParamMap.put("skssqq", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
        commonParamMap.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long id = org.getLong("id");
        commonParamMap.put("org", id);
        QFilter qFilter = new QFilter("org", "=", (Object)id);
        DynamicObject tempOrg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"taxpayer, unifiedsocialcode", (QFilter[])new QFilter[]{qFilter});
        commonParamMap.put("orgname", tempOrg.getString("taxpayer"));
        return commonParamMap;
    }

    public void afterBindData(EventObject e) {
        this.dealData();
    }

    private void dealData() {
        DynamicObject dynamicObject;
        DynamicObject temp;
        Object org;
        Object obj = this.getModel().getValue("taxorgan");
        if (obj != null) {
            DynamicObject dynamicObject2 = (DynamicObject)obj;
            QFilter qFilter = new QFilter("taxorgan", "=", (Object)dynamicObject2.getLong("id"));
            DynamicObject[] baseObjs = BusinessDataServiceHelper.load((String)"tsate_declare_base", (String)"id,sblx,logintype", (QFilter[])new QFilter[]{qFilter});
            if (baseObjs != null && baseObjs.length > 0) {
                Set taxTypes = Arrays.stream(baseObjs).filter(o -> o != null && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)o.getDynamicObjectCollection("sblx"))).flatMap(o -> o.getDynamicObjectCollection("sblx").stream()).filter(k -> k != null && k.getDynamicObject("fbasedataid") != null).map(k -> k.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toSet());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taxTypes)) {
                    this.getModel().setValue("sbblx", (Object)StringUtils.join(taxTypes, (String)" "));
                    this.getModel().setDataChanged(false);
                }
                Set loginTypes = Arrays.stream(baseObjs).flatMap(o -> Arrays.stream(o.getString("logintype").split(",")).filter(a -> StringUtils.isNotBlank((CharSequence)a))).collect(Collectors.toSet());
                ComboEdit loginTypeEdit = (ComboEdit)this.getControl("logintype");
                loginTypeEdit.setComboItems(null);
                ComboProp property = (ComboProp)loginTypeEdit.getProperty();
                List valueMapItems = property.getComboItems();
                ArrayList comboItems = new ArrayList(valueMapItems.size());
                valueMapItems.stream().filter(o -> loginTypes.contains(o.getValue())).forEach(k -> comboItems.add(new ComboItem(k.getName(), k.getValue())));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(comboItems) && this.getModel().getValue("logintype") == null) {
                    this.getModel().setValue("logintype", (Object)((ComboItem)comboItems.get(0)).getValue());
                }
                loginTypeEdit.setComboItems(comboItems);
            } else {
                ComboEdit loginTypeEdit = (ComboEdit)this.getControl("logintype");
                loginTypeEdit.setComboItems(null);
                this.getModel().setValue("logintype", null);
            }
        }
        if ((org = this.getModel().getValue("org")) != null && (temp = BastaxTaxorgBusiness.queryTaxcOrgInfoByOrgId((Long)(dynamicObject = (DynamicObject)org).getLong("id"))) != null) {
            this.getModel().setValue("nsrmc", (Object)temp.getString("entry_taxpayer"));
            this.getModel().setValue("nsrsbh", (Object)temp.getString("entry_unifiedsocialcode"));
            this.getModel().setDataChanged(false);
        }
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        return BastaxTaxorgBusiness.queryIsTaxpayerAndCheckedOrgIds(orgList);
    }

    public static Set<SupplierEnum> getNeedSyncData(Long taxOrganId) {
        return TsateChannelBusiness.getChannelInfoByOrganId((Long)taxOrganId, CHANNELS);
    }

    public static boolean isNeedSyncData(Set<SupplierEnum> channels) {
        return org.apache.commons.collections.CollectionUtils.isNotEmpty(channels);
    }

    private static DynamicObject getAreaInfoByNsrsbh(Long taxorganId, SupplierEnum supplier) {
        Long taxOfficeId = CommonInfoUtil.getParentTaxauthorityById((Long)taxorganId);
        if (taxOfficeId != null) {
            QFilter baseFilter = new QFilter("taxorgan", "=", (Object)taxOfficeId).and(new QFilter("declarechannel.number", "=", (Object)supplier.getCode()));
            return QueryServiceHelper.queryOne((String)"tsate_declare_base", (String)"xzqh,isspecial", (QFilter[])new QFilter[]{baseFilter});
        }
        return null;
    }
}

