/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.checklist;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareChecklistBusiness;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.PermissionUtils;

public class ChecklistImportPlugin
extends BatchImportPlugin {
    private static final String UNIQUEGROUPKEY = "org,zsxm,zspm,skssqq,skssqz";
    private static final String SBSX_IMPORT_PER = "4730fc9f000003ae";
    private static final String TEMPKEY_ORGID = "temp_orgid";
    private static final String TEMPKEY_TAXORGID = "temp_taxorgid";
    private static final String TEMPKEY_ZSXMID = "temp_zsxmid";
    private static final String TEMPKEY_ZSPMID = "temp_zspmid";
    private static final String TEMPKEY_VALIDATE = "temp_validate";
    private static final String TEMPKEY_DBEXIST = "temp_dbexist";
    private static final String TEMPKEY_DBID = "temp_dbid";
    private static final String TEMPKEY_UNIQUECODE = "temp_uniquecode";

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        this.validateOrg(billdatas, logger);
        this.validateZsxm(billdatas, logger);
        this.validateZspm(billdatas, logger);
        this.validateSkssq(billdatas, logger);
        this.validateSbqx(billdatas, logger);
        this.validateSbrq(billdatas, logger);
        this.validateDeclareStatus(billdatas, logger);
        this.validatePayStatus(billdatas, logger);
        this.checkDbExist(billdatas);
        this.validateOptionType(billdatas, logger);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            if (!data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            it.remove();
        }
        Map option = this.ctx.getOption();
        String optype = option.get("importtype").toString();
        ArrayList<ImportBillData> addList = new ArrayList<ImportBillData>();
        ArrayList<ImportBillData> updateList = new ArrayList<ImportBillData>();
        for (ImportBillData data : rowdatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            boolean dbexist = (Boolean)data.getData().getOrDefault((Object)TEMPKEY_DBEXIST, (Object)false);
            if (dbexist) {
                updateList.add(data);
                continue;
            }
            addList.add(data);
        }
        ArrayList<Map<String, Object>> importResult = new ArrayList<Map<String, Object>>();
        if (!"override".equals(optype)) {
            importResult.addAll(this.addByImportData(addList, logger));
        }
        if (!"new".equals(optype)) {
            importResult.addAll(this.updateByImportData(updateList, logger));
        }
        for (int i = 0; i < importResult.size(); ++i) {
            ((Map)importResult.get(i)).put("dindex", i);
        }
        ApiResult result = new ApiResult();
        result.setSuccess(true);
        result.setMessage("");
        result.setData(importResult);
        return result;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List list = super.getOverrideFieldsConfig();
        list.forEach(item -> {
            if (!UNIQUEGROUPKEY.contains(item.getValue())) {
                item.setDisable(true);
                item.setItemVisible(false);
            }
        });
        return list;
    }

    public String getDefaultKeyFields() {
        return UNIQUEGROUPKEY;
    }

    private void checkDbExist(List<ImportBillData> billdatas) {
        Date ssqqMin;
        ArrayList<String> uniquecodes = new ArrayList<String>(8);
        Date ssqzMax = ssqqMin = new Date();
        for (ImportBillData data : billdatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Long orgid = data.getData().getLong(TEMPKEY_ORGID);
            Long zsxmid = data.getData().getLong(TEMPKEY_ZSXMID);
            Long zspmid = data.getData().getLong(TEMPKEY_ZSPMID);
            Date skssqq = DateUtils.stringToDate((String)data.getData().getString("skssqq"));
            Date skssqz = DateUtils.stringToDate((String)data.getData().getString("skssqz"));
            if (ssqqMin.after(skssqq)) {
                ssqqMin = skssqq;
            }
            if (ssqzMax.before(skssqz)) {
                ssqzMax = skssqz;
            }
            String unicode = TsateDeclareChecklistBusiness.getUniqueCode((Long)orgid, (Long)zsxmid, (Long)zspmid, (Date)skssqq, (Date)skssqz);
            data.getData().put(TEMPKEY_UNIQUECODE, (Object)unicode);
            uniquecodes.add(unicode);
        }
        TsateDeclareChecklistBusiness.getByUniqueCodeAndSkssq((String[])uniquecodes.toArray(new String[0]), (Date)ssqqMin, (Date)ssqzMax).forEach(dyn -> {
            for (ImportBillData data : billdatas) {
                if (data.getData().containsKey((Object)TEMPKEY_VALIDATE) || !data.getData().getString(TEMPKEY_UNIQUECODE).equals(dyn.getString("uniquecode")) || !this.checkSameUnique((DynamicObject)dyn, data)) continue;
                data.getData().put(TEMPKEY_DBEXIST, (Object)true);
                data.getData().put(TEMPKEY_DBID, (Object)dyn.getLong("id"));
            }
        });
    }

    private boolean checkSameUnique(DynamicObject dyn, ImportBillData importData) {
        String orgNumber1 = dyn.getString("org.number");
        String zsxmNumber1 = dyn.getString("zsxm.number");
        String zspmNumber1 = dyn.getString("zspm.number");
        String skssqq1 = DateUtils.format((Date)dyn.getDate("skssqq"));
        String skssqz1 = DateUtils.format((Date)dyn.getDate("skssqz"));
        String orgNumber2 = (String)this.getImportValue(importData, "org.number");
        String zsxmNumber2 = (String)this.getImportValue(importData, "zsxm.number");
        String zspmNumber2 = (String)this.getImportValue(importData, "zspm.number");
        String skssqq2 = importData.getData().getString("skssqq");
        String skssqz2 = importData.getData().getString("skssqz");
        if (!orgNumber1.equals(orgNumber2)) {
            return false;
        }
        if (!zsxmNumber1.equals(zsxmNumber2)) {
            return false;
        }
        if (zspmNumber1 != null && !zspmNumber1.equals(zspmNumber2)) {
            return false;
        }
        if (zspmNumber2 != null && !zspmNumber2.equals(zspmNumber1)) {
            return false;
        }
        if (!skssqq1.equals(skssqq2)) {
            return false;
        }
        return skssqz1.equals(skssqz2);
    }

    private void validateOrg(List<ImportBillData> billData, ImportLogger logger) {
        Set orgNumbers = billData.stream().map(data -> (String)this.getImportValue((ImportBillData)data, "org.number")).collect(Collectors.toSet());
        Set<Long> perOrgs = this.getPerOrg();
        Map channelInfos = TsateChannelBusiness.getDeclareConfigByOrgNumber(orgNumbers, null, null, null);
        for (ImportBillData data2 : billData) {
            Integer index = data2.getStartIndex();
            String orgnumber = (String)this.getImportValue(data2, "org.number");
            if (StringUtils.isEmpty((String)orgnumber)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (channelInfos.get(orgnumber) == null) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728", (String)"ChecklistImportPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            Long orgid = (Long)((Map)channelInfos.get(orgnumber)).get("id");
            data2.getData().put(TEMPKEY_ORGID, (Object)orgid);
            boolean istaxpayer = ((Map)channelInfos.get(orgnumber)).getOrDefault("istaxpayer", false);
            if (!istaxpayer) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u662f\u7eb3\u7a0e\u4e3b\u4f53", (String)"ChecklistImportPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            data2.getData().put(TEMPKEY_TAXORGID, ((Map)channelInfos.get(orgnumber)).get("taxofficeid"));
            if (((Map)channelInfos.get(orgnumber)).getOrDefault("status", "0").equals("0")) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u88ab\u7981\u7528", (String)"ChecklistImportPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (perOrgs.contains(orgid)) continue;
            data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u65e0\u5f15\u5165\u6743\u9650", (String)"ChecklistImportPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validateZsxm(List<ImportBillData> billDatas, ImportLogger logger) {
        HashSet zsxmNumbers = new HashSet();
        billDatas.stream().forEach(data -> zsxmNumbers.add((String)this.getImportValue((ImportBillData)data, "zsxm.number")));
        DynamicObjectCollection dyns = TsateDeclareChecklistBusiness.getZsxmByNumbers(zsxmNumbers);
        Map<String, DynamicObject> maps = dyns.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        for (ImportBillData data2 : billDatas) {
            if (data2.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data2.getStartIndex();
            String number = (String)this.getImportValue(data2, "zsxm.number");
            if (StringUtils.isEmpty((String)number)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (!maps.containsKey(number)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5f81\u6536\u9879\u76ee", (String)"ChecklistImportPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            data2.getData().put(TEMPKEY_ZSXMID, (Object)maps.get(number).getLong("id"));
            Date now = new Date();
            Date start = maps.get(number).getDate("activedate");
            Date end = maps.get(number).getDate("expdate");
            if (start.after(now) || end != null && end.before(now)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7cfb\u7edf\u5bf9\u5e94\u7684\u5f81\u6536\u9879\u76ee\uff08\u7a0e\u79cd\uff09\u672a\u751f\u6548", (String)"ChecklistImportPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (!"0".equals(maps.get(number).getString("enable"))) continue;
            data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\uff08\u7a0e\u79cd\uff09\u88ab\u7981\u7528", (String)"ChecklistImportPlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validateZspm(List<ImportBillData> billDatas, ImportLogger logger) {
        HashSet zspmNumbers = new HashSet();
        billDatas.stream().forEach(data -> zspmNumbers.add((String)this.getImportValue((ImportBillData)data, "zspm.number")));
        DynamicObjectCollection dyns = TsateDeclareChecklistBusiness.getZspmByNumbers(zspmNumbers);
        Map<String, DynamicObject> maps = dyns.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v));
        for (ImportBillData data2 : billDatas) {
            if (data2.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data2.getStartIndex();
            String number = (String)this.getImportValue(data2, "zspm.number");
            if (number == null) continue;
            if (!maps.containsKey(number)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5f81\u6536\u54c1\u76ee", (String)"ChecklistImportPlugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            data2.getData().put(TEMPKEY_ZSPMID, (Object)maps.get(number).getLong("id"));
            Date now = new Date();
            Date start = maps.get(number).getDate("starttime");
            Date end = maps.get(number).getDate("endtime");
            if (start.after(now) || end != null && end.before(now)) {
                data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7cfb\u7edf\u5bf9\u5e94\u7684\u5f81\u6536\u54c1\u76ee\uff08\u54c1\u76ee\uff09\u672a\u751f\u6548", (String)"ChecklistImportPlugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (!"0".equals(maps.get(number).getString("enable"))) continue;
            data2.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u7cfb\u7edf\u5bf9\u5e94\u7684\u5f81\u6536\u54c1\u76ee\uff08\u54c1\u76ee\uff09\u88ab\u7981\u7528", (String)"ChecklistImportPlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validateSkssq(List<ImportBillData> billDatas, ImportLogger logger) {
        for (ImportBillData data : billDatas) {
            Date qz;
            Date qq;
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            String qqStr = data.getData().getString("skssqq");
            String qzStr = data.getData().getString("skssqz");
            if (StringUtils.isEmpty((String)qqStr)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (StringUtils.isEmpty((String)qzStr)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_13", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            try {
                qq = DateUtils.stringToDate((String)qqStr);
                qz = DateUtils.stringToDate((String)qzStr);
            }
            catch (Exception e) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ChecklistImportPlugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (qq.after(qz)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5e94\u665a\u4e8e\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77", (String)"ChecklistImportPlugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            Date firstDay = DateUtils.getFirstDateOfMonth((Date)qq);
            Date lastDay = DateUtils.getLastDateOfMonth((Date)qz);
            String firstStr = DateUtils.format((Date)firstDay);
            String lastStr = DateUtils.format((Date)lastDay);
            if (!firstStr.equals(qqStr)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u5e94\u8be5\u7b49\u4e8e\u6708\u521d\u7b2c\u4e00\u5929", (String)"ChecklistImportPlugin_16", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (lastStr.equals(qzStr)) continue;
            data.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u5e94\u8be5\u7b49\u4e8e\u6708\u672b\u6700\u540e\u4e00\u5929", (String)"ChecklistImportPlugin_17", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validateSbqx(List<ImportBillData> billDatas, ImportLogger logger) {
        for (ImportBillData data : billDatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            String sbqxStr = data.getData().getString("sbqx");
            if (StringUtils.isEmpty((String)sbqxStr)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7533\u62a5\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_18", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            try {
                DateUtils.stringToDate((String)sbqxStr);
            }
            catch (Exception e) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7533\u62a5\u671f\u9650\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ChecklistImportPlugin_19", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
            }
        }
    }

    private void validateSbrq(List<ImportBillData> billDatas, ImportLogger logger) {
        for (ImportBillData data : billDatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            String sbrqStr = data.getData().getString("sbrq");
            if (StringUtils.isEmpty((String)sbrqStr)) continue;
            try {
                DateUtils.stringToDate((String)sbrqStr);
            }
            catch (Exception e) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"ChecklistImportPlugin_30", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
            }
        }
    }

    private void validateDeclareStatus(List<ImportBillData> billDatas, ImportLogger logger) {
        for (ImportBillData data : billDatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            String sbzt = data.getData().getString("sbzt");
            if (StringUtils.isEmpty((String)sbzt)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7533\u62a5\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_20", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            String zts = ResManager.loadKDString((String)"\u672a\u7533\u62a5,\u5df2\u7533\u62a5", (String)"ChecklistImportPlugin_21", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            if (zts.indexOf(sbzt) != -1) continue;
            data.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u7533\u62a5\u72b6\u6001\u4e0d\u6b63\u786e", (String)"ChecklistImportPlugin_22", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validatePayStatus(List<ImportBillData> billDatas, ImportLogger logger) {
        for (ImportBillData data : billDatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            String jkzt = data.getData().getString("jkzt");
            if (StringUtils.isEmpty((String)jkzt)) {
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u7f34\u6b3e\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (String)"ChecklistImportPlugin_23", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            String zts = ResManager.loadKDString((String)"\u65e0\u9700\u7f34\u6b3e,\u672a\u7f34\u6b3e,\u5df2\u7f34\u6b3e", (String)"ChecklistImportPlugin_24", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            if (zts.indexOf(jkzt) != -1) continue;
            data.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u7f34\u6b3e\u72b6\u6001\u4e0d\u6b63\u786e", (String)"ChecklistImportPlugin_25", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private void validateOptionType(List<ImportBillData> billDatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        String optype = option.get("importtype").toString();
        for (ImportBillData data : billDatas) {
            if (data.getData().containsKey((Object)TEMPKEY_VALIDATE)) continue;
            Integer index = data.getStartIndex();
            boolean dbexist = (Boolean)data.getData().getOrDefault((Object)TEMPKEY_DBEXIST, (Object)false);
            if ("new".equals(optype)) {
                if (!dbexist) continue;
                data.getData().put(TEMPKEY_VALIDATE, (Object)false);
                logger.log(index, ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5df2\u5b58\u5728\u8bb0\u5f55", (String)"ChecklistImportPlugin_26", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
                continue;
            }
            if (!"override".equals(optype) || dbexist) continue;
            data.getData().put(TEMPKEY_VALIDATE, (Object)false);
            logger.log(index, ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8bb0\u5f55", (String)"ChecklistImportPlugin_27", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).fail();
        }
    }

    private Set<Long> getPerOrg() {
        ArrayList ids = new ArrayList();
        HasPermOrgResult tsate = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_declare_checklist", (String)SBSX_IMPORT_PER, (Long)RequestContext.get().getCurrUserId());
        if (tsate != null) {
            if (!tsate.hasAllOrgPerm()) {
                ids.addAll(tsate.getHasPermOrgs());
            } else {
                QFilter qFilter = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
                qFilter.and(new QFilter("status", "=", (Object)"1"));
                DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{qFilter});
                ids.addAll(taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList()));
            }
        }
        HashSet<Long> orgs = new HashSet<Long>();
        orgs.addAll(ids);
        return orgs;
    }

    private List<Map<String, Object>> addByImportData(List<ImportBillData> importDatas, ImportLogger logger) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(8);
        for (ImportBillData item2 : importDatas) {
            DynamicObject obj = this.getDynobjByImportdata(item2);
            datas.add(obj);
        }
        SaveServiceHelper.save((DynamicObject[])datas.toArray(new DynamicObject[0]));
        importDatas.forEach(item -> {
            Integer index = item.getStartIndex();
            result.add(this.genImportResult(null, index, true, ResManager.loadKDString((String)"\u65b0\u589e\u6210\u529f", (String)"ChecklistImportPlugin_28", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
        });
        return result;
    }

    private List<Map<String, Object>> updateByImportData(List<ImportBillData> importDatas, ImportLogger logger) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(8);
        for (ImportBillData item2 : importDatas) {
            DynamicObject obj = this.getDynobjByImportdata(item2);
            datas.add(obj);
        }
        SaveServiceHelper.update((DynamicObject[])datas.toArray(new DynamicObject[0]));
        importDatas.forEach(item -> {
            Integer index = item.getStartIndex();
            result.add(this.genImportResult(null, index, true, ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"ChecklistImportPlugin_29", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
        });
        return result;
    }

    private DynamicObject getDynobjByImportdata(ImportBillData item) {
        String payStatus;
        String declareStatus;
        Long id = item.getData().getLong(TEMPKEY_DBID);
        Long orgId = item.getData().getLong(TEMPKEY_ORGID);
        Long taxorgId = item.getData().getLong(TEMPKEY_TAXORGID);
        String sbsx = item.getData().getString("sbsx");
        Long zsxmId = item.getData().getLong(TEMPKEY_ZSXMID);
        Long zspmId = item.getData().getLong(TEMPKEY_ZSPMID);
        Date ssqq = DateUtils.stringToDate((String)item.getData().getString("skssqq"));
        Date ssqz = DateUtils.stringToDate((String)item.getData().getString("skssqz"));
        Date sbqx = DateUtils.stringToDate((String)item.getData().getString("sbqx"));
        Date sbrq = null;
        String sbrqStr = item.getData().getString("sbrq");
        if (StringUtils.isNotEmpty((String)sbrqStr)) {
            sbrq = DateUtils.stringToDate((String)sbrqStr);
        }
        switch (declareStatus = item.getData().getString("sbzt")) {
            case "\u5df2\u7533\u62a5": {
                declareStatus = "1";
                break;
            }
            default: {
                declareStatus = "0";
            }
        }
        switch (payStatus = item.getData().getString("jkzt")) {
            case "\u65e0\u9700\u7f34\u6b3e": {
                payStatus = "2";
                break;
            }
            case "\u5df2\u7f34\u6b3e": {
                payStatus = "1";
                break;
            }
            default: {
                payStatus = "0";
            }
        }
        String source = "2";
        Long createor = RequestContext.get().getCurrUserId();
        Date operateTime = new Date();
        return TsateDeclareChecklistBusiness.newInstance((Long)id, (Long)orgId, (Long)taxorgId, (String)sbsx, (Long)zsxmId, (Long)zspmId, (Date)ssqq, (Date)ssqz, (Date)sbqx, (Date)sbrq, (String)declareStatus, (String)payStatus, (String)source, (Long)createor, (Date)operateTime);
    }

    private Object getImportValue(ImportBillData billData, String path) {
        String[] nodePath = path.split("\\.");
        Object temp = billData.getData();
        for (int i = 0; i < nodePath.length && temp instanceof JSONObject; ++i) {
            JSONObject json = temp;
            temp = json.get((Object)nodePath[i]);
        }
        return temp;
    }

    private Map<String, Object> genImportResult(Long id, Integer index, Boolean success, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        map.put("dindex", index);
        map.put("success", success);
        map.put("message", message);
        return map;
    }
}

