/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.checklist;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.business.CheckListCompareBusiness;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateTaskTypeBusiness;
import kd.taxc.tsate.business.checklist.CheckListDownloadedDataBusiness;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.FileUploadUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.enums.CheckListHiddenEnums;
import kd.taxc.tsate.formplugin.enums.CheckListMappingEnums;
import kd.taxc.tsate.formplugin.enums.MethodSupportChannelEnums;

public class TsateDeclareChecklistPlugin
extends AbstractListPlugin {
    private static final String FORM_ID = "tsate_checklist_group";
    private static final String BTN_DECLARECHECK = "declarecheck";
    private static final String HIDDING_FLAG = "hidden";
    private static final String ORG_CHANLE_CACHE = "orgcCacheFlag";
    private static final String TASK_TYPE_IDS = "typeIds";
    private static final String TASK_ID = "tasktype.id";
    private static final String SPLIT_STRING = "-";
    private static final String TASK_TYPES = "SBSXXZ,YQXX,SBJGXX,JKJGXX,WDTX,WDDB,DJKXX";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"btn_resource", "btn_imort", "btn_export", BTN_DECLARECHECK});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("xqzs".equals(fieldName)) {
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Object primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
            ArrayList<Object> pkIds = new ArrayList<Object>();
            pkIds.add(primaryKeyValue);
            List urls = FileUploadUtils.getFilePaths((String)FORM_ID, pkIds, (String)"attachmentpanelap", (boolean)false);
            if (CollectionUtils.isEmpty((Collection)urls)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a", (String)"TsateDeclareChecklistPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showPictureView(urls.toArray(new String[0]), 0);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.declareCheckShow();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void packageData(PackageDataEvent e) {
        String skssSwjgmc;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        DynamicObject dyn = e.getRowData();
        String swjgmc = dyn.getString("swjgmc");
        String key = columnDesc.getKey();
        if ("nsrmc".equals(key) || "nsrsbh".equals(key)) {
            this.dealNsrxx(e, columnDesc);
        } else if ("taxorg.name".equals(key)) {
            if (StringUtils.isNotEmpty((String)swjgmc)) {
                e.setFormatValue((Object)swjgmc);
            }
        } else if ("skssswjgmc".equals(key) && StringUtils.isEmpty((String)(skssSwjgmc = dyn.getString("checklist.skssswjgmc")))) {
            e.setFormatValue((Object)swjgmc);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String sourceKey = args.getVarMap().getOrDefault("source.operateKey", "none");
        if ("comparestatus".equals(sourceKey)) {
            DynamicObjectCollection dyns;
            Set orgNames;
            Object[] ls = this.getSelectedRows().getEntryPrimaryKeyValues();
            List entryIds = Arrays.stream(ls).map(v -> (Long)v).collect(Collectors.toList());
            if (entryIds.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TsateDeclareChecklistPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((orgNames = (dyns = CheckListCompareBusiness.checkBeforCompare(entryIds)).stream().map(item -> item.getString("org.name")).collect(Collectors.toSet())).size() > 0) {
                args.setCancel(true);
                String title = ResManager.loadKDString((String)"%d\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7533\u62a5\u6e05\u518c\u6570\u636e\u6b63\u5728\u6bd4\u5bf9\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TsateDeclareChecklistPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
                title = String.format(title, orgNames.size());
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId("bos_operationresult");
                parameters.setShowTitle(true);
                parameters.setCustomParam("operateName", (Object)"");
                parameters.setCustomParam("title", (Object)title);
                parameters.setCustomParam("errorMsg", orgNames);
                this.getView().showForm(parameters);
            }
        } else if ("refresh".equals(sourceKey)) {
            CheckListDownloadedDataBusiness.sendDownloadQxySbqcMsg();
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        String defaultName = ResManager.loadKDString((String)"\u7533\u62a5\u6e05\u518c", (String)"TsateDeclareChecklistPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
        CommonFilterColumn taskTypeColumn = (CommonFilterColumn)args.getFilterColumn("tasktype.name");
        ArrayList<Long> selectedOrgIds = new ArrayList();
        List comboItems = taskTypeColumn.getComboItems();
        ComboItem defaultComboItem = comboItems.stream().filter(combo -> defaultName.equals(combo.getCaption().getLocaleValue().trim())).findFirst().get();
        taskTypeColumn.setDefaultValues(new Object[]{defaultComboItem.getValue()});
        if (controlFilters == null || EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(ORG_CHANLE_CACHE))) {
            long orgId = RequestContext.get().getOrgId();
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)FORM_ID, (String)"47150e89000000ac", (Long)RequestContext.get().getCurrUserId());
            List<Object> orgList = new ArrayList();
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                orgList = hasPermOrgResult.getHasPermOrgs();
            } else {
                DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty(orgList)) {
                orgList = TsateDeclareChecklistPlugin.excludeByTaxPayer(orgList, true);
            }
            if (!CollectionUtils.isEmpty(orgList)) {
                Long defaultOrgId = orgList.contains(orgId) ? Long.valueOf(orgId) : (Long)orgList.get(0);
                selectedOrgIds.add(defaultOrgId);
                args.getFilterColumn("org.number").setDefaultValue(String.valueOf(defaultOrgId));
            }
            if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(HIDDING_FLAG))) {
                this.getPageCache().put(HIDDING_FLAG, "SBSXXZ");
            }
            Map orgInfos = TsateChannelBusiness.getDeclareConfigByOrgId(orgList, (Boolean)true, (Boolean)true, (Boolean)true);
            this.buildOrgAndChanelChache(orgInfos, this.getPageCache());
        } else {
            List orgIds = controlFilters.getFilter("org.id");
            selectedOrgIds = orgIds.stream().filter(o -> StringUtils.isNotEmpty((String)o.toString())).map(o -> Long.valueOf(o.toString())).collect(Collectors.toList());
            args.getFilterColumn("org.number").setDefaultValue(null);
        }
        List<String> taskIds = this.getSupportTaskId(selectedOrgIds);
        taskTypeColumn.setComboItems(this.buildSupportComboItem(taskIds, comboItems, defaultComboItem));
        taskIds.add(defaultComboItem.getValue());
        this.getPageCache().put(TASK_TYPE_IDS, JSON.toJSONString(taskIds));
    }

    private List<ComboItem> buildSupportComboItem(List<String> taskIds, List<ComboItem> comboItems, ComboItem defaultComboItem) {
        if (CollectionUtils.isEmpty(taskIds)) {
            return Collections.singletonList(defaultComboItem);
        }
        return comboItems.stream().filter(item -> taskIds.contains(item.getValue())).collect(Collectors.toList());
    }

    private List<String> getSupportTaskId(List<Long> orgList) {
        List allOrgIds = JSON.parseArray((String)this.getPageCache().get(ORG_CHANLE_CACHE), Long.class);
        if (CollectionUtils.isEmpty(orgList)) {
            orgList = allOrgIds;
        }
        HashSet<String> types = new HashSet<String>(8);
        for (CheckListMappingEnums mappingEnum : CheckListMappingEnums.values()) {
            String[] supportTypes;
            List orgs = JSON.parseArray((String)this.getPageCache().get(mappingEnum.getCacheKey()), Long.class);
            if (CollectionUtils.isEmpty((Collection)orgs) || !this.judgeIntersection(orgs, orgList)) continue;
            for (String type : supportTypes = mappingEnum.getSupportTypes().split(SPLIT_STRING)) {
                types.add(type);
            }
        }
        return this.buildDefultTaskValues(types);
    }

    private List<String> buildDefultTaskValues(Set<String> types) {
        ArrayList<String> taskTypeIds = new ArrayList<String>(8);
        for (String type : types) {
            if (this.getPageCache().get(type) == null) {
                this.buildTypeIdCache();
            }
            taskTypeIds.add(this.getPageCache().get(type));
        }
        return taskTypeIds;
    }

    private void buildTypeIdCache() {
        DynamicObjectCollection objects = TsateTaskTypeBusiness.getByTakeNumber((String)TASK_TYPES, (String)",");
        for (DynamicObject task : objects) {
            this.getPageCache().put(task.getString("number"), task.getString("id"));
        }
    }

    private boolean judgeIntersection(List<Long> list1, List<Long> list2) {
        boolean flag = false;
        list1.retainAll(list2);
        if (list1.size() > 0) {
            flag = true;
        }
        return flag;
    }

    private void buildOrgAndChanelChache(Map<Long, Map<String, Object>> orgInfos, IPageCache pageCache) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashSet<String> supplierAndOrgInfos = new HashSet<String>(64);
        for (Map.Entry<Long, Map<String, Object>> entry : orgInfos.entrySet()) {
            List channelConfigs;
            Long orgid = entry.getKey();
            Map<String, Object> org = entry.getValue();
            if (EmptyCheckUtils.isEmpty((Object)orgid) || CollectionUtils.isEmpty(org) || CollectionUtils.isEmpty((Collection)(channelConfigs = (List)org.computeIfAbsent("channelinfos", key -> new ArrayList(2))))) continue;
            StringBuilder supplierAndOrgInfo = new StringBuilder();
            for (Map channel : channelConfigs) {
                String channelNumber = (String)channel.get("channelnumber");
                if (!MethodSupportChannelEnums.SBJC.getSupportChannels().contains(channelNumber)) continue;
                if (!ids.contains(orgid)) {
                    ids.add(orgid);
                }
                supplierAndOrgInfos.add(supplierAndOrgInfo.append(channelNumber).append(SPLIT_STRING).append(orgid).toString());
                supplierAndOrgInfo.delete(0, supplierAndOrgInfo.length());
            }
        }
        pageCache.put(ORG_CHANLE_CACHE, JSON.toJSONString(ids));
        this.setOrgCache(supplierAndOrgInfos, pageCache);
    }

    private void setOrgCache(Set<String> supplierAndOrgInfos, IPageCache pageCache) {
        HashMap orgCacheMap = new HashMap(8);
        for (CheckListMappingEnums mapping : CheckListMappingEnums.values()) {
            orgCacheMap.put(mapping, new ArrayList());
        }
        for (Map.Entry entry : orgCacheMap.entrySet()) {
            CheckListMappingEnums mappingEnum = (CheckListMappingEnums)((Object)entry.getKey());
            List orgIds = (List)entry.getValue();
            for (String orgInfo : supplierAndOrgInfos) {
                String[] supplierOrgInfo = orgInfo.split(SPLIT_STRING);
                Long orgId = Long.valueOf(supplierOrgInfo[1]);
                String supplierCode = supplierOrgInfo[0];
                if (!mappingEnum.getSupplier().getCode().equals(supplierCode)) continue;
                orgIds.add(orgId);
            }
            pageCache.put(mappingEnum.getCacheKey(), JSON.toJSONString((Object)orgIds));
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Long value = (Long)args.getFilterValue(TASK_ID);
        if (EmptyCheckUtils.isEmpty((Object)value)) {
            this.getPageCache().remove(HIDDING_FLAG);
            return;
        }
        DynamicObject task = TsateTaskTypeBusiness.getByTaskId((Long)value);
        String number = task.getString("number");
        this.getPageCache().put(HIDDING_FLAG, number);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String fields = this.getPageCache().get(HIDDING_FLAG);
        String hiddenColumns = CheckListHiddenEnums.getHiddenColumnsByTaskType(fields);
        if (StringUtils.isEmpty((String)hiddenColumns)) {
            return;
        }
        List list = args.getListColumns();
        Iterator columnIterator = list.iterator();
        String[] split = hiddenColumns.split(",");
        while (columnIterator.hasNext()) {
            IListColumn iListColumn = (IListColumn)columnIterator.next();
            if (!Arrays.asList(split).contains(iListColumn.getListFieldKey())) continue;
            columnIterator.remove();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        QFilter qFilter = null;
        String fieldName = args.getFieldName();
        if ("org.id".equalsIgnoreCase(fieldName) || "org.number".equalsIgnoreCase(fieldName)) {
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)FORM_ID, (String)"47150e89000000ac", (Long)RequestContext.get().getCurrUserId());
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
                List<Long> orgList = hasPermOrgResult.getHasPermOrgs();
                if (!CollectionUtils.isEmpty((Collection)orgList)) {
                    orgList = TsateDeclareChecklistPlugin.excludeByTaxPayer(orgList, true);
                }
                qFilter = new QFilter("id", "in", orgList);
            } else {
                List<Long> ids = TsateDeclareChecklistPlugin.filterByIsTaxpayer(true);
                qFilter = new QFilter("id", "in", ids);
            }
        } else if (TASK_ID.equalsIgnoreCase(fieldName)) {
            String taskIdCache = this.getPageCache().get(TASK_TYPE_IDS);
            List taskIds = new ArrayList();
            if (EmptyCheckUtils.isNotEmpty((Object)taskIdCache)) {
                taskIds = JSON.parseArray((String)taskIdCache, Long.class);
            }
            qFilter = new QFilter("id", "in", taskIds);
        }
        if (qFilter != null) {
            args.getQfilters().add(qFilter);
        }
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList, boolean isincludeNoable) {
        List<Long> orgIds = TsateDeclareChecklistPlugin.filterByIsTaxpayer(isincludeNoable);
        orgList.removeIf(s -> !orgIds.contains(s));
        return orgList;
    }

    private static List<Long> filterByIsTaxpayer(boolean isincludeNoable) {
        DynamicObjectCollection taxOrgs;
        QFilter qFilter = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        if (!isincludeNoable) {
            qFilter.and(new QFilter("status", "=", (Object)"1"));
        }
        return CollectionUtils.isEmpty((Collection)(taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{qFilter}))) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private void dealNsrxx(PackageDataEvent e, AbstractColumnDesc columnDesc) {
        DynamicObject data = e.getRowData();
        if (EmptyCheckUtils.isEmpty((Object)data.getDynamicObject("org"))) {
            return;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)data.getDynamicObject("org").getLong("id"));
        DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"taxpayer, unifiedsocialcode", (QFilter[])new QFilter[]{qFilter});
        if (temp != null) {
            if ("nsrmc".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("taxpayer"));
            } else if ("nsrsbh".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("unifiedsocialcode"));
            }
        }
    }

    private void declareCheckShow() {
        String taskNumber = this.getPageCache().get(HIDDING_FLAG);
        if (CheckListHiddenEnums.SBSXXZ.getTaskType().equals(taskNumber)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_DECLARECHECK});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_DECLARECHECK});
        }
    }
}

