/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.checklist;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateTaskTypeBusiness;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.enums.CheckListMappingEnums;
import kd.taxc.tsate.formplugin.enums.MethodSupportChannelEnums;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.lang3.StringUtils;

public class TsateSbsxDownloadPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(TsateSbsxDownloadPlugin.class);
    private static final String FIELD_ORG = "org";
    private static final String CHANNEL_KEY = "downloadchannel";
    private static final String ORG_CACHE_KEY = "orgIdsCache";
    private static final String SINGLE_CACHE_KEY = "singleChannel";
    private static final String BTN_DOWNLOAD = "btnok";
    private static final String TASK_TYPES = "SBSXXZ,YQXX,SBJGXX,JKJGXX,WDTX,WDDB,DJKXX";
    private static final String SBSX_DOWNLOAD_PER = "28T/ALUDR3RZ";
    private static final String FIELD_TYPE = "tasktypes";
    private static final String TYPE_CACHE_FLAG = "SBSXXZ";
    private static final String SPLIT_STRING = "-";
    private static final Long TASK_TIMEOUT = 600000L;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_DOWNLOAD});
        BasedataEdit org = (BasedataEdit)this.getControl(FIELD_ORG);
        BasedataEdit type = (BasedataEdit)this.getControl(FIELD_TYPE);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        type.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrgFiled();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if (eventName.equals(FIELD_ORG) || eventName.equals(CHANNEL_KEY)) {
            this.buildTaskTypeAndChanel(null);
        }
    }

    private QFilter buildTaskTypeAndChanel(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds) && CollectionUtils.isEmpty(orgIds = this.getOrgsFromView())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u9700\u8981\u8fdb\u884c\u4e0b\u8f7d\u64cd\u4f5c\u7684\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"TsateSbsxDownloadPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return null;
        }
        if (this.getPageCache().get(TYPE_CACHE_FLAG) == null) {
            this.buildTypeIdCache();
        }
        HashSet<String> types = new HashSet<String>(8);
        HashSet<String> channels = new HashSet<String>(8);
        for (CheckListMappingEnums mappingEnum : CheckListMappingEnums.values()) {
            List orgs;
            if (this.getPageCache().get(mappingEnum.getCacheKey()) == null) {
                this.getValuableOrg();
            }
            if (CollectionUtils.isEmpty((Collection)(orgs = JSON.parseArray((String)this.getPageCache().get(mappingEnum.getCacheKey()), Long.class))) || !this.judgeIntersection(orgs, orgIds)) continue;
            String[] supportTypes = mappingEnum.getSupportTypes().split(SPLIT_STRING);
            channels.add(mappingEnum.getSupplier().getCode());
            types.addAll(Arrays.asList(supportTypes));
        }
        return this.buildDefaultValueAndFilter(types, channels);
    }

    private void buildChannelValue(Set<String> channels, Object channelValue) {
        ComboEdit downloadChannel = (ComboEdit)this.getControl(CHANNEL_KEY);
        List ValueMapItems = ((ComboProp)downloadChannel.getProperty()).getComboItems();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
        for (ValueMapItem item : ValueMapItems) {
            String value = item.getValue();
            if (!channels.contains(value)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(item.getName());
            comboItem.setValue(value);
            comboItems.add(comboItem);
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{CHANNEL_KEY});
        this.getPageCache().remove(SINGLE_CACHE_KEY);
        downloadChannel.setComboItems(comboItems);
        if (channels.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANNEL_KEY});
            this.getPageCache().put(SINGLE_CACHE_KEY, ((ComboItem)comboItems.get(0)).getValue());
        }
        if (EmptyCheckUtils.isNotEmpty((Object)channelValue) && !channels.contains(channelValue.toString())) {
            this.getModel().setValue(CHANNEL_KEY, null);
        }
    }

    private QFilter buildDefaultValueAndFilter(Set<String> types, Set<String> channels) {
        HashSet<String> taskTypes = new HashSet<String>(8);
        ArrayList<Long> taskTypeIds = new ArrayList<Long>(8);
        Object channelValue = this.getModel().getValue(CHANNEL_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)channelValue)) {
            CheckListMappingEnums checkListMappingInfo = CheckListMappingEnums.getCheckListMappingInfo(channelValue.toString());
            String[] supportTypes = checkListMappingInfo.getSupportTypes().split(SPLIT_STRING);
            taskTypes.addAll(Arrays.asList(supportTypes));
        } else {
            taskTypes.addAll(types);
        }
        this.buildChannelValue(channels, channelValue);
        for (String type : taskTypes) {
            if (this.getPageCache().get(type) == null) {
                this.buildTypeIdCache();
            }
            taskTypeIds.add(Long.valueOf(this.getPageCache().get(type)));
        }
        this.getModel().setValue(FIELD_TYPE, (Object)taskTypeIds.toArray());
        return new QFilter("id", "in", taskTypeIds);
    }

    private void buildTypeIdCache() {
        DynamicObjectCollection objects = TsateTaskTypeBusiness.getByTakeNumber((String)TASK_TYPES, (String)",");
        for (DynamicObject task : objects) {
            this.getPageCache().put(task.getString("number"), task.getString("id"));
        }
    }

    public boolean judgeIntersection(List<Long> list1, List<Long> list2) {
        boolean flag = false;
        list1.retainAll(list2);
        if (list1.size() > 0) {
            flag = true;
        }
        return flag;
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (BTN_DOWNLOAD.equals(((Control)evt.getSource()).getKey())) {
            DynamicObjectCollection taskType;
            ArrayList<DynamicObject> taskTypes;
            List<Long> orgsFromView = this.getOrgsFromView();
            if (this.checkIfExistTask(orgsFromView, taskTypes = new ArrayList<DynamicObject>((Collection<DynamicObject>)(taskType = this.getTaskType())))) {
                return;
            }
            int count = this.batchJob(orgsFromView, taskTypes);
            if (count > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u4e0b\u8f7d\u7ed3\u679c\uff0c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"TsateSbsxDownloadPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u4e0b\u53d1\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5df2\u6b63\u786e\u914d\u7f6e\u901a\u9053\u4fe1\u606f\u3002", (String)"TsateSbsxDownloadPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7) {
        ListShowParameter ls = (ListShowParameter)beforeF7.getFormShowParameter();
        String fieldKey = beforeF7.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_ORG)) {
            List<Long> ids = this.getValuableOrg();
            ls.getListFilterParameter().setFilter(new QFilter("id", "in", ids));
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)FIELD_TYPE)) {
            QFilter filter = this.buildTaskTypeAndChanel(null);
            if (filter == null) {
                filter = new QFilter("id", "=", null);
            }
            ls.getListFilterParameter().setFilter(filter);
        }
    }

    private void setOrgFiled() {
        ArrayList<Long> defaultOrgId = new ArrayList<Long>();
        List<Long> valuableOrg = this.getValuableOrg();
        if (CollectionUtils.isEmpty(valuableOrg)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANNEL_KEY});
            return;
        }
        Long currentOrgId = this.getCurrentOrgId();
        if (valuableOrg.contains(currentOrgId)) {
            defaultOrgId.add(currentOrgId);
        } else {
            defaultOrgId.add(valuableOrg.get(0));
        }
        this.getModel().setValue(FIELD_ORG, (Object)defaultOrgId.toArray());
        this.buildTaskTypeAndChanel(defaultOrgId);
    }

    private int batchJob(List<Long> orgIdList, List<DynamicObject> taskTypes) {
        String channel;
        Object selectChannel = this.getModel().getValue(CHANNEL_KEY);
        if (EmptyCheckUtils.isNotEmpty((Object)selectChannel)) {
            channel = selectChannel.toString();
        } else {
            if (EmptyCheckUtils.isEmpty((Object)this.getPageCache().get(SINGLE_CACHE_KEY))) {
                this.buildTaskTypeAndChanel(orgIdList);
            }
            channel = this.getPageCache().get(SINGLE_CACHE_KEY);
        }
        Map maps = TsateChannelBusiness.getDeclareConfigByOrgId(orgIdList, (Boolean)true, (Boolean)true, (Boolean)true);
        int count = 0;
        for (Map org : maps.values()) {
            List channelConfigs = (List)org.computeIfAbsent("channelinfos", key -> new ArrayList(2));
            if (channelConfigs.size() <= 0) continue;
            String supplier = null;
            Map item = new HashMap(16);
            for (Map channelConfig : channelConfigs) {
                supplier = (String)channelConfig.get("channelnumber");
                if (supplier == null || !EmptyCheckUtils.isNotEmpty((Object)channel) || !channel.equals(supplier)) continue;
                item = channelConfig;
                break;
            }
            if (CollectionUtils.isEmpty(item)) {
                logger.info("tsate-\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d,\u7a0e\u53f7\u65e0\u53ef\u7528\u901a\u9053\uff0c\u8be6\u7ec6\uff1a" + JSON.toJSONString((Object)org));
                continue;
            }
            Long taxorgid = (Long)org.get("taxofficeid");
            Long orgid = (Long)org.get("id");
            Long channelId = (Long)item.get("channelid");
            String nsrsbh = (String)org.get("nsrsbh");
            for (DynamicObject taskType : taskTypes) {
                long typeId = taskType.getDynamicObject("fbasedataid").getLong("id");
                String number = ((DynamicObject)taskType.get(1)).getString("number");
                if (!MethodSupportChannelEnums.getChannelByMethod(number).contains(supplier)) continue;
                DynamicObject record = this.addDeclareRecord(orgid, channelId, supplier, number, typeId);
                Long recordId = record.getLong("id");
                HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
                paramMap.put("taxorgid", taxorgid);
                paramMap.put("nsrsbh", nsrsbh);
                paramMap.put(FIELD_ORG, orgid);
                paramMap.put("recordid", recordId);
                paramMap.put("key", "sbsxxz");
                paramMap.put("taskCode", number);
                paramMap.put("operatorid", this.getCurrentOrgId());
                paramMap.put("taskId", typeId);
                paramMap.put("supplier", supplier);
                paramMap.put("operatetime", System.currentTimeMillis());
                paramMap.put("datasource", "1");
                JobUtils.submitJob(paramMap);
                ++count;
            }
        }
        logger.info("tsate-\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d ,\u7ec4\u7ec7\u6570\u91cf:" + orgIdList.size() + " \u6279\u91cf\u6267\u884c\u6570\u91cf\uff1a" + count);
        return count;
    }

    private DynamicObject addDeclareRecord(Long orgid, Long channelId, String channelNumber, String taskNumber, long taskId) {
        Date sbqj = new Date();
        Date createTime = new Date();
        String creatorId = this.getCurrentUserId() + "";
        ExecuteStatusEnum executestatus = ExecuteStatusEnum.PROCESSING;
        return TsateDeclareRecordBusiness.save((Long)orgid, (Date)createTime, (String)creatorId, (ExecuteStatusEnum)executestatus, (Date)sbqj, (String)channelNumber, (Long)channelId, (String)taskNumber, (Long)taskId);
    }

    private List<Long> getOrgsFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection orgs = (DynamicObjectCollection)dataEntity.get(FIELD_ORG);
        return orgs.parallelStream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
    }

    private boolean checkIfExistTask(List<Long> orgids, List<DynamicObject> taskType) {
        List dyns = TsateDeclareRecordBusiness.checkTimeoutRecord(orgids, (Long)TASK_TIMEOUT, taskType);
        if (CollectionUtils.isEmpty((Collection)dyns)) {
            return false;
        }
        StringBuilder erro = new StringBuilder();
        HashMap<String, String> flagMap = new HashMap<String, String>(4);
        HashSet<String> orgNameSet = new HashSet<String>(16);
        boolean tittleFlag = true;
        for (DynamicObject dyn : dyns) {
            String orgName2 = dyn.getString("org.name");
            orgNameSet.add(orgName2);
            String typeNmber = dyn.getString("tasktype.number");
            String typeName = dyn.getString("tasktype.name");
            flagMap.put(typeNmber, typeName);
        }
        if (flagMap.size() > 1) {
            tittleFlag = false;
        }
        String value = (String)((Map.Entry)flagMap.entrySet().stream().findFirst().get()).getValue();
        orgNameSet.forEach(orgName -> erro.append(ResManager.loadKDString((String)"\u3010%s\u3011\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TsateSbsxDownloadPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgName})).append(System.lineSeparator()));
        String title = tittleFlag ? ResManager.loadKDString((String)"\u60a8\u9009\u4e2d%1$s\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u7684%2$s\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TsateSbsxDownloadPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgNameSet.size(), value}) : ResManager.loadKDString((String)"\u60a8\u9009\u4e2d%1$s\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7533\u62a5\u6e05\u518c\u7b49\u4fe1\u606f\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TsateSbsxDownloadPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgNameSet.size()});
        this.getView().showConfirm(title, erro.toString(), null, ConfirmTypes.Fail, null);
        this.getView().close();
        return true;
    }

    private DynamicObjectCollection getTaskType() {
        return this.getModel().getDataEntity().getDynamicObjectCollection(FIELD_TYPE);
    }

    private List<Long> getValuableOrg() {
        String orgIdsFromCache = this.getPageCache().get(ORG_CACHE_KEY);
        if (orgIdsFromCache != null) {
            return JSON.parseArray((String)orgIdsFromCache, Long.class);
        }
        ArrayList ids = new ArrayList();
        ArrayList<Long> ids2 = new ArrayList<Long>();
        HasPermOrgResult tsate = PermissionUtils.getAllPermOrgsByUserId((String)"tsate", (String)"tsate_checklist_group", (String)SBSX_DOWNLOAD_PER, (Long)RequestContext.get().getCurrUserId());
        if (tsate != null) {
            if (!tsate.hasAllOrgPerm()) {
                ids.addAll(tsate.getHasPermOrgs());
            } else {
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)"1")});
                if (loads != null && loads.length > 0) {
                    ids.addAll(Arrays.stream(loads).map(o -> o.getLong("id")).collect(Collectors.toList()));
                }
            }
        }
        logger.info("gxsj \u7533\u62a5\u4e8b\u9879\u6743\u9650\u7ec4\u7ec7");
        logger.info(JSON.toJSONString(ids));
        Map orgInfos = TsateChannelBusiness.getDeclareConfigByOrgId(ids, (Boolean)true, (Boolean)true, (Boolean)true);
        if (CollectionUtils.isEmpty((Map)orgInfos)) {
            return ids2;
        }
        logger.info(JSON.toJSONString((Object)orgInfos));
        HashSet<String> supplierAndOrgInfos = new HashSet<String>(64);
        for (Map.Entry entry : orgInfos.entrySet()) {
            List channelConfigs;
            Long orgid = (Long)entry.getKey();
            Map org = (Map)entry.getValue();
            if (EmptyCheckUtils.isEmpty((Object)orgid) || CollectionUtils.isEmpty((Map)org) || CollectionUtils.isEmpty((Collection)(channelConfigs = (List)org.computeIfAbsent("channelinfos", key -> new ArrayList(2))))) continue;
            StringBuilder supplierAndOrgInfo = new StringBuilder();
            for (Map channel : channelConfigs) {
                String channelNumber = (String)channel.get("channelnumber");
                if (!MethodSupportChannelEnums.SBJC.getSupportChannels().contains(channelNumber)) continue;
                if (!ids2.contains(orgid)) {
                    ids2.add(orgid);
                }
                supplierAndOrgInfos.add(supplierAndOrgInfo.append(channelNumber).append(SPLIT_STRING).append(orgid).toString());
                supplierAndOrgInfo.delete(0, supplierAndOrgInfo.length());
            }
        }
        this.setOrgCache(supplierAndOrgInfos, ids2);
        return ids2;
    }

    private void setOrgCache(Set<String> supplierAndOrgInfos, List<Long> ids) {
        HashMap orgCacheMap = new HashMap(8);
        for (CheckListMappingEnums mapping : CheckListMappingEnums.values()) {
            orgCacheMap.put(mapping, new ArrayList());
        }
        for (Map.Entry entry : orgCacheMap.entrySet()) {
            CheckListMappingEnums mappingEnum = (CheckListMappingEnums)((Object)entry.getKey());
            List orgIds = (List)entry.getValue();
            for (String orgInfo : supplierAndOrgInfos) {
                String[] supplierOrgInfo = orgInfo.split(SPLIT_STRING);
                Long orgId = Long.valueOf(supplierOrgInfo[1]);
                String supplierCode = supplierOrgInfo[0];
                if (!mappingEnum.getSupplier().getCode().equals(supplierCode)) continue;
                orgIds.add(orgId);
            }
            this.getPageCache().put(mappingEnum.getCacheKey(), JSON.toJSONString((Object)orgIds));
        }
        this.getPageCache().put(ORG_CACHE_KEY, JSON.toJSONString(ids));
    }

    private Long getCurrentOrgId() {
        return RequestContext.get().getOrgId();
    }

    private Long getCurrentUserId() {
        return RequestContext.get().getCurrUserId();
    }
}

