/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.creditlevel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Control;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;

public class TaxCreditLevelFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String DATE_FORMAT = "YYYY";
    private static final String CACHE_KEY = "taxOrgIds";
    private static final String TAX_ORG_KEY = "selectorgs";
    private static final String LIST_SEL_ORGS = "defaultOrgs";
    private static final String END_YEAR = "endyear";
    private static final String BEGIN_YEAR = "beginyear";
    private static final String CHANNEL_CODE = SupplierEnum.GXSJ.getCode();
    private static final String ZLXZ_DOWNLOAD_PER = "2RG4L2631EU3";

    public void registerListener(EventObject e) {
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl(TAX_ORG_KEY);
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (EmptyCheckUtils.isEmpty(customParams.get(LIST_SEL_ORGS)) || EmptyCheckUtils.isEmpty(customParams.get("hasPermOrgs"))) {
            return;
        }
        DateEdit beginYear = (DateEdit)this.getView().getControl(BEGIN_YEAR);
        Date maxDate = DateUtils.addYear((Date)new Date(), (int)-1);
        beginYear.setMaxDate(maxDate);
        DateEdit endYear = (DateEdit)this.getView().getControl(END_YEAR);
        endYear.setMaxDate(maxDate);
        this.getModel().setValue(BEGIN_YEAR, (Object)maxDate);
        this.getModel().setValue(END_YEAR, (Object)maxDate);
        String orgCache = this.getPageCache().get(CACHE_KEY);
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isEmpty((Object)orgCache) || StringUtils.equals((CharSequence)"[]", (CharSequence)orgCache)) {
            List hasPermOrgs = (List)JSON.parseObject((String)customParams.get("hasPermOrgs").toString(), List.class);
            this.getPageCache().put("hasPermOrgs", SerializationUtils.toJsonString((Object)hasPermOrgs));
            orgList = this.buildOrgs(hasPermOrgs);
            if (CollectionUtils.isEmpty(orgList)) {
                return;
            }
            this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY), orgList.getClass());
        }
        List orgs = ((JSONArray)customParams.get(LIST_SEL_ORGS)).toJavaList(Long.class);
        Object[] defultSelect = null;
        orgs.retainAll(orgList);
        defultSelect = CollectionUtils.isEmpty((Collection)orgs) ? new Object[]{orgList.get(0)} : orgs.toArray();
        this.getModel().setValue(TAX_ORG_KEY, (Object)defultSelect);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)TAX_ORG_KEY)) {
            String orgCache = this.getPageCache().get(CACHE_KEY);
            List<Object> orgList = new ArrayList();
            if (EmptyCheckUtils.isEmpty((Object)orgCache) || StringUtils.equals((CharSequence)"[]", (CharSequence)orgCache)) {
                List hasPermOrgs = (List)JSON.parseObject((String)this.getPageCache().get("hasPermOrgs"), List.class);
                orgList = this.buildOrgs(hasPermOrgs);
                this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString(orgList));
            } else {
                orgList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY), orgList.getClass());
            }
            formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if (StringUtils.equals((CharSequence)itemKey, (CharSequence)"btnok")) {
            DynamicObjectCollection selectOrgs = (DynamicObjectCollection)this.getModel().getValue(TAX_ORG_KEY);
            if (CollectionUtils.isEmpty((Collection)selectOrgs)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u3002", (String)"TaxCreditLevelFormPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Date endyear = dataEntity.getDate(END_YEAR);
            Date beginyear = dataEntity.getDate(BEGIN_YEAR);
            if (beginyear.after(endyear)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u8bc4\u4ef7\u5e74\u5ea6\u8d77\u201d\u5e94\u65e9\u4e8e\u201c\u8bc4\u4ef7\u5e74\u5ea6\u6b62\u201d\uff0c\u8bf7\u8c03\u6574\u3002", (String)"TaxCreditLevelFormPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            List<Long> collect = selectOrgs.stream().map(o -> o.getLong(2)).collect(Collectors.toList());
            if (this.checkTask(collect).booleanValue()) {
                return;
            }
            DynamicObjectCollection taxOrg = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,unifiedsocialcode", (QFilter[])new QFilter("id", "in", collect).toArray());
            HashMap nsrsbhMap = new HashMap();
            taxOrg.forEach(org -> {
                String unifiedsocialcode = org.getString("unifiedsocialcode");
                String orgId = org.getString("id");
                if (StringUtils.isBlank((CharSequence)unifiedsocialcode)) {
                    return;
                }
                nsrsbhMap.put(orgId, unifiedsocialcode);
            });
            if (CollectionUtils.isEmpty(nsrsbhMap)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5b58\u5728\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff0c\u65e0\u6cd5\u8fdb\u884c\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u3002", (String)"TaxCreditLevelFormPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            int diffYears = DateUtils.getYearDiffByYear((Date)endyear, (Date)beginyear);
            ArrayList<String> downloadYears = new ArrayList<String>(diffYears);
            Date date = beginyear;
            for (int i = 0; i <= diffYears; ++i) {
                downloadYears.add(DateUtils.format((Date)date, (String)DATE_FORMAT));
                date = DateUtils.addYear((Date)date, (int)1);
            }
            HashMap<String, Object> params = new HashMap<String, Object>(nsrsbhMap.size());
            for (Map.Entry entry : nsrsbhMap.entrySet()) {
                String orgId = (String)entry.getKey();
                DynamicObject[] declarRecord = this.assembleDeclareRecord(orgId);
                params.put("org", orgId);
                params.put("nsrsbh", entry.getValue());
                params.put("recordid", declarRecord[0].getLong("id"));
                params.put("downLoadYears", downloadYears);
                params.put("key", "xydjxz");
                params.put("supplier", CHANNEL_CODE);
                JobUtils.submitJob(params);
            }
            this.getView().close();
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u4e0b\u8f7d\u7ed3\u679c\uff0c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"TaxCreditLevelFormPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private Boolean checkTask(List<Long> orgIds) {
        DynamicObjectCollection runingTask = QueryServiceHelper.query((String)"tsate_declare_record", (String)"id,org.name", (QFilter[])new QFilter("executetype", "=", (Object)"XYDJXZ").and(new QFilter("executestatus", "=", (Object)"1")).and(new QFilter("org", "in", orgIds)).toArray());
        if (CollectionUtils.isEmpty((Collection)runingTask)) {
            return Boolean.FALSE;
        }
        StringBuilder detailInfo = new StringBuilder(20);
        for (DynamicObject o : runingTask) {
            detailInfo.append(o.getString("org.name")).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxCreditLevelFormPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(System.lineSeparator());
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%s\u4e2a\u7a0e\u52a1\u7ec4\u7ec7\u7684\u7eb3\u7a0e\u4eba\u4fe1\u7528\u7b49\u7ea7\u4fe1\u606f\uff0c\u6b63\u5728\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"TaxCreditLevelFormPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[]{runingTask.size()}), detailInfo.toString(), MessageTypes.Default);
        return Boolean.TRUE;
    }

    private DynamicObject[] assembleDeclareRecord(String orgId) {
        DynamicObject channelObj;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("billstatus", (Object)"C");
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"XYDJXZ")});
        if (taskObj != null) {
            dynamicObject.set("executetype", (Object)"XYDJXZ");
            dynamicObject.set("tasktype", (Object)taskObj.getLong("id"));
        }
        if ((channelObj = BusinessDataServiceHelper.loadSingle((String)"tsate_channel", (String)MetadataUtil.getAllFieldString((String)"tsate_channel"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)CHANNEL_CODE)})) != null) {
            dynamicObject.set("channel", (Object)channelObj.getString("number"));
            dynamicObject.set("declarechannel", (Object)channelObj.getLong("id"));
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private List<Long> buildOrgs(List<Long> hasPermOrgs) {
        List<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tsate", (String)"tsate_credit_level_list", (String)ZLXZ_DOWNLOAD_PER);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            hasPermOrgs.retainAll(hasPermOrgResult.getHasPermOrgs());
        }
        if (CollectionUtils.isEmpty(hasPermOrgs)) {
            return orgIds;
        }
        List<Long> channelTaxorganIds = TaxCreditLevelFormPlugin.getTaxorganIds(Collections.singletonList(CHANNEL_CODE));
        ArrayList<Long> taxorganIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(channelTaxorganIds)) {
            return orgIds;
        }
        List<Long> childTaxauthorityByIds = this.getChildTaxauthorityByIds(taxorganIds, channelTaxorganIds);
        if (CollectionUtils.isEmpty(channelTaxorganIds)) {
            return orgIds;
        }
        DynamicObject[] taxMains = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxoffice,orgid", (QFilter[])new QFilter[]{new QFilter("taxoffice.id", "in", childTaxauthorityByIds)});
        if (taxMains == null || taxMains.length == 0) {
            return orgIds;
        }
        orgIds = Arrays.stream(taxMains).filter(o -> o.getDynamicObject("orgid") != null).map(o -> o.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection taxOrgIds = BastaxTaxorgBusiness.getByIds(orgIds, (Boolean)true, (Boolean)true);
        List<Long> ids = taxOrgIds.stream().map(o -> Long.parseLong(o.getString("id"))).collect(Collectors.toList());
        ids.retainAll(orgIds);
        ids.retainAll(hasPermOrgs);
        return ids;
    }

    private static List<Long> getTaxorganIds(List<String> channels) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("declarechannel.number", "in", channels));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tsate_declare_channel", (String)"id,declarechannel,taxorgancopy", (QFilter[])new QFilter[]{qFilter});
        HashSet taxorganIds = new HashSet();
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                obj.getDynamicObjectCollection("taxorgancopy").stream().forEach(o -> taxorganIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            }
            return new ArrayList<Long>(taxorganIds);
        }
        return new ArrayList<Long>();
    }

    private List<Long> getChildTaxauthorityByIds(List<Long> ids, List<Long> taxauthorityIds) {
        ids.addAll(taxauthorityIds);
        QFilter qFilter = new QFilter("parent", "in", taxauthorityIds);
        ArrayList<Long> tempIds = new ArrayList<Long>();
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                tempIds.add(obj.getLong("id"));
            }
            this.getChildTaxauthorityByIds(ids, tempIds);
        }
        return ids;
    }
}

