/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.creditlevel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.creditlevel.TaxCreditLevelBusiness;
import kd.taxc.tsate.common.util.OrgUtils;

public class TaxCreditLevelListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_NAME = "tsate_credit_level_list";
    private static final String FORM_ID = "tsate_download_level";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonFilterColumn orgColumn = this.getOrgFilterColumn(filterColumnList);
        if (orgColumn == null) {
            return;
        }
        List<ComboItem> combos = this.getOrgComboItem();
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("defaultOrg"))) {
            String defaultOrg = this.getPageCache().get("CACHE_DEFAULT_ORG");
            if (defaultOrg == null && !combos.isEmpty()) {
                defaultOrg = combos.get(0).getValue();
            }
            orgColumn.setDefaultValue(defaultOrg);
            this.getPageCache().put("defaultOrg", defaultOrg);
        }
        orgColumn.setType("enum");
        orgColumn.setComboItems(combos);
        String orgs = this.getPageCache().get("orgIds");
        if (StringUtils.isEmpty((CharSequence)orgs) || StringUtils.equals((CharSequence)"[]", (CharSequence)orgs)) {
            List orgList = combos.stream().map(comboItem -> Long.parseLong(comboItem.getValue())).collect(Collectors.toList());
            this.getPageCache().put("orgIds", SerializationUtils.toJsonString(orgList));
        }
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc;
        String key;
        ArrayList<String> nolinks = new ArrayList<String>(10);
        DynamicObject data = e.getRowData();
        String comparestatus = data.getString("comparestatus");
        String updatestatus = data.getString("updatestatus");
        if (!"fail".equals(comparestatus)) {
            nolinks.add("comparestatus");
        }
        if (!"fail".equals(updatestatus)) {
            nolinks.add("updatestatus");
        }
        if (nolinks.size() > 0) {
            e.setNoLinkKey(nolinks);
        }
        if ("nsrsbh".equals(key = (columnDesc = (AbstractColumnDesc)e.getSource()).getKey()) || "org.enable".equals(key)) {
            this.dealNsrxx(e, columnDesc);
        }
        if ("taxmaininfo".equals(key)) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"TaxCreditLevelListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)ENTITY_NAME);
        if ("taxmaininfo".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            this.showTaxOrgInfo(object.getDynamicObject("org").getLong("id"));
        } else if ("comparestatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            this.showMsgWindow(args, "comparestatus");
        } else if ("updatestatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            this.showMsgWindow(args, "updatestatus");
        }
    }

    public void showMsgWindow(HyperLinkClickArgs args, String actionName) {
        args.setCancel(true);
        String msgField = "";
        if ("comparestatus".equals(actionName)) {
            msgField = "comparemsg";
        } else if ("updatestatus".equals(actionName)) {
            msgField = "updatemsg";
        }
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        DynamicObject creditData = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)ENTITY_NAME, (String)("id" + (StringUtils.isEmpty((CharSequence)msgField) ? "" : "," + msgField)));
        if (StringUtils.isNotEmpty((CharSequence)msgField)) {
            String msg = creditData.getString(msgField);
            if (StringUtils.isNotEmpty((CharSequence)msg) && StringUtils.isNotEmpty((CharSequence)msg.trim())) {
                this.getView().showMessage(msg);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u5931\u8d25\u63d0\u793a\u4fe1\u606f\u3002", (String)"TaxCreditLevelListPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6682\u65e0\u5931\u8d25\u63d0\u793a\u4fe1\u606f\u3002", (String)"TaxCreditLevelListPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTaxOrgInfo(Long id) {
        QFilter qFilter = new QFilter("org", "=", (Object)id);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"status", (QFilter[])new QFilter[]{qFilter});
        if ("0".equals(dyo.getString("status"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u7f16\u7801 \u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"TaxCreditLevelListPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tctb_tax_info_home");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(true);
            showParameter.setCustomParam("listOrgId", (Object)id.toString());
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taxOrgInfo");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("download".equals(args.getOperateKey())) {
                List orgs = this.getControlFilters().getFilter("org.id");
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("defaultOrgs", orgs);
                customParams.put("hasPermOrgs", this.getPageCache().get("orgIds"));
                FormShowParameter param = new FormShowParameter();
                param.setCustomParams(customParams);
                param.setFormId(FORM_ID);
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "download");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm(param);
            } else if ("comparedata".equals(args.getOperateKey())) {
                this.compareData();
            } else if ("updatetaxmaininfo".equals(args.getOperateKey())) {
                this.updateTaxMainInfo();
            }
        }
    }

    public void compareData() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxCreditLevelListPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] creditLevelObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,comparestatus,comparemsg,updatestatus,updatemsg,evaluationyear,evaluationlevel,evaluationscore,org.id,org.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list.getPrimaryKeyValues())});
        StringBuilder errorSb = this.checkCanCompareData(creditLevelObjects);
        if (errorSb.length() > 0) {
            this.dealMessage(errorSb);
            return;
        }
        this.doCompareData(creditLevelObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5dee\u5f02\u6bd4\u5bf9\u5b8c\u6210\u3002", (String)"TaxCreditLevelListPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        billlist.refresh();
    }

    public StringBuilder checkCanCompareData(DynamicObject[] creditLevelObjects) {
        StringBuilder errorSb = new StringBuilder();
        for (DynamicObject dynObject : creditLevelObjects) {
            if (("undo".equals(dynObject.getString("comparestatus")) || "fail".equals(dynObject.getString("comparestatus"))) && "undo".equals(dynObject.getString("updatestatus"))) continue;
            errorSb.append(dynObject.getDynamicObject("org").getString("name")).append(" ").append(dynObject.getString("evaluationyear")).append("\uff1a").append(ResManager.loadKDString((String)"\u53ea\u6709\u5dee\u5f02\u6bd4\u5bf9\u7ed3\u679c\u4e3a\u201c\u672a\u6bd4\u5bf9\u201d\u6216\u201c\u6bd4\u5bf9\u5931\u8d25\u201d\u4e14\u66f4\u65b0\u72b6\u6001\u4e3a\u201c\u672a\u66f4\u65b0\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9\u64cd\u4f5c\u3002", (String)"TaxCreditLevelListPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(SEPARATOR);
        }
        return errorSb;
    }

    public void doCompareData(DynamicObject[] creditLevelObjects) {
        TaxCreditLevelBusiness.compareCredit((DynamicObject[])creditLevelObjects);
    }

    public void updateTaxMainInfo() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxCreditLevelListPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] creditLevelObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"id,comparestatus,comparemsg,updatestatus,updatemsg,evaluationyear,evaluationlevel,evaluationscore,org.id,org.name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list.getPrimaryKeyValues())});
        StringBuilder errorSb = this.checkCanUpdateTaxMainInfo(creditLevelObjects);
        if (errorSb.length() > 0) {
            this.dealMessage(errorSb);
            return;
        }
        TaxCreditLevelBusiness.updateTaxMainInfo((DynamicObject[])creditLevelObjects);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u66f4\u65b0\u5b8c\u6210\u3002", (String)"TaxCreditLevelListPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        billlist.refresh();
    }

    public StringBuilder checkCanUpdateTaxMainInfo(DynamicObject[] creditLevelObjects) {
        StringBuilder errorSb = new StringBuilder();
        for (DynamicObject dynObject : creditLevelObjects) {
            if ("diff".equals(dynObject.getString("comparestatus")) && ("undo".equals(dynObject.getString("updatestatus")) || "fail".equals(dynObject.getString("updatestatus")))) continue;
            errorSb.append(dynObject.getDynamicObject("org").getString("name")).append(" ").append(dynObject.getString("evaluationyear")).append("\uff1a").append(ResManager.loadKDString((String)"\u53ea\u6709\u5dee\u5f02\u6bd4\u5bf9\u7ed3\u679c\u4e3a\u201c\u6709\u5dee\u5f02\u201d\uff0c\u66f4\u65b0\u72b6\u6001\u4e3a\u201c\u672a\u66f4\u65b0\u201d\u6216\u201c\u66f4\u65b0\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u66f4\u65b0\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u64cd\u4f5c\u3002", (String)"TaxCreditLevelListPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(SEPARATOR);
        }
        return errorSb;
    }

    private void dealMessage(StringBuilder message) {
        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
            String[] messages = message.toString().split(System.getProperty("line.separator"));
            if (messages.length == 1) {
                this.getView().showErrorNotification(message.toString());
            } else {
                this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                OperationResult operationResult = new OperationResult();
                operationResult.setSuccess(false);
                operationResult.setMessage(message.toString());
                this.getView().showOperationResult(operationResult);
            }
        }
    }

    private void dealNsrxx(PackageDataEvent e, AbstractColumnDesc columnDesc) {
        DynamicObject data = e.getRowData();
        QFilter qFilter = new QFilter("org", "=", (Object)data.getDynamicObject("org").getLong("id"));
        DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"unifiedsocialcode,status", (QFilter[])new QFilter[]{qFilter});
        if (temp != null) {
            if ("nsrsbh".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("unifiedsocialcode"));
            }
            if ("org.enable".equals(columnDesc.getKey())) {
                e.setFormatValue((Object)temp.getString("status"));
            }
        }
    }

    private CommonFilterColumn getOrgFilterColumn(List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith("org.") || !(filterColumn instanceof CommonFilterColumn)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return null;
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{ENTITY_NAME}, null, null, (Boolean)Boolean.FALSE);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }
}

