/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareHistoryBusiness;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.TemplateTypeConstant;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.helper.OrgServiceHelper;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.formplugin.enums.HistoryDownloadPeriodType;
import kd.taxc.tsate.formplugin.utils.ComboEditUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.lang3.StringUtils;

public class HistoryDownloadPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String[] SUPPORT_NSRTYPES = new String[]{"zzsybnsr", "zdsybs_yd", "qysdsjb", "FR0002", "FR0003", "zzsxgmnsr"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"submit"});
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null) {
            List<Long> orgList = this.buildOrgs();
            if (EmptyCheckUtils.isNotEmpty(customParams.get("org"))) {
                Object orgId = customParams.get("org");
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
                    if (!orgList.contains(Long.valueOf((String)orgId))) {
                        orgId = orgList.get(0);
                    }
                    this.getModel().setValue("org", (Object)new Object[]{orgId});
                }
            } else if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
                this.getModel().setValue("org", (Object)new Object[]{orgList.get(0)});
            }
            this.getModel().setValue("taxtype", (Object)"zzsybnsr");
            this.getModel().setValue("startdate", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
            this.getModel().setValue("enddate", (Object)DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        }
        this.taxLimitSetting();
        this.setDeclareDataTypeItems();
        this.taxperiodSetting();
        this.getPageCache().put("updateCache", "0");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxtype".equals(name)) {
            this.setDeclareDataTypeItems();
            this.taxLimitSetting();
            this.taxperiodSetting();
        } else if ("taxlimit".equals(name)) {
            this.taxperiodSetting();
        } else if ("org".equals(name)) {
            this.setDeclareDataTypeItems();
            this.taxperiodSetting();
        } else if ("declaredatatype".equals(name)) {
            this.taxperiodSetting();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org")) {
            List<Long> orgList = this.buildOrgs();
            QFilter idsFilter = new QFilter("id", "in", orgList);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            formShowParameter.getListFilterParameter().setFilter(idsFilter.and(statusFilter));
            formShowParameter.setCustomParam("orgViewSchemeNumber", (Object)"40");
            formShowParameter.getCustomParams().put("orgFuncId", "40");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7", (String)"HistoryDownloadPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    private List<Long> buildOrgs() {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"tsate", (String)"tsate_declare_history", (String)"2NV2YWY=3JS/");
        List<Object> orgList = new ArrayList();
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm()) {
            orgList = hasPermOrgResult.getHasPermOrgs();
        } else {
            DynamicObjectCollection objs = OrgServiceHelper.getOrgLists();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)objs)) {
                orgList = objs.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            }
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(orgList)) {
            orgList = HistoryDownloadPlugin.excludeByTaxPayer(orgList);
        }
        ArrayList<String> suppliers = new ArrayList<String>();
        suppliers.add(SupplierEnum.ZWY.getCode());
        suppliers.add(SupplierEnum.QXY.getCode());
        List<Long> channelTaxorganIds = HistoryDownloadPlugin.getTaxorganIds(suppliers, Arrays.asList(SUPPORT_NSRTYPES));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(channelTaxorganIds)) {
            DynamicObject[] taxMains;
            ArrayList<Long> taxorganIds = new ArrayList<Long>();
            List<Long> childTaxauthorityByIds = this.getChildTaxauthorityByIds(taxorganIds, channelTaxorganIds);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(childTaxauthorityByIds)) {
                taxMains = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxoffice,orgid", (QFilter[])new QFilter[]{new QFilter("taxoffice.id", "in", childTaxauthorityByIds)});
                if (taxMains == null || taxMains.length <= 0) {
                    return new ArrayList<Long>();
                }
            } else {
                return new ArrayList<Long>();
            }
            List orgIds = Arrays.stream(taxMains).filter(o -> o.getDynamicObject("orgid") != null).map(o -> o.getDynamicObject("orgid").getLong("id")).collect(Collectors.toList());
            orgList.retainAll(orgIds);
            return orgList;
        }
        return new ArrayList<Long>();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String itemKey = control.getKey();
        if ("submit".equals(itemKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            int dayOfDate1 = DateUtils.getDayOfDate((Date)DateUtils.getLastDateOfMonth((Date)endDate));
            int dayOfDate2 = DateUtils.getDayOfDate((Date)endDate);
            if (DateUtils.getDayOfDate((Date)startDate) != 1 || dayOfDate1 != dayOfDate2) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u671f\u8d77\u6b62\u65e5\u671f\u8bf7\u5206\u522b\u9009\u62e9\u6708\u4efd\u7684\u7b2c\u4e00\u5929\u548c\u6700\u540e\u4e00\u5929\u3002", (String)"HistoryDownloadPlugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection orgs = dataEntity.getDynamicObjectCollection("org");
            DynamicObject taxtype = dataEntity.getDynamicObject("taxtype");
            List monthBetween = DateUtils.getMonthBetween((Date)startDate, (Date)endDate, (String)"yyyy-MM-dd");
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgs)) {
                ArrayList<String> messageList = new ArrayList<String>();
                StringBuilder detailMsg = new StringBuilder();
                List<Long> orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                Map<String, String> recordMap = this.buildRecordMap(taxtype, orgIds);
                Map<String, String> historyMap = this.buildHistoryMap(taxtype, orgIds);
                for (DynamicObject org : orgs) {
                    long orgId = org.getDynamicObject("fbasedataid").getLong("id");
                    for (String month : monthBetween) {
                        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)month));
                        Date latDateOfMonth = DateUtils.getLastDateOfMonth((Date)DateUtils.stringToDate((String)month));
                        String key = orgId + "_" + taxtype.getString("number") + "_" + DateUtils.format((Date)firstDateOfMonth, (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)latDateOfMonth, (String)"yyyy-MM-dd");
                        String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(taxtype.getString("number"));
                        if (recordMap.containsKey(key)) {
                            messageList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s", (String)"HistoryDownloadPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getDynamicObject("fbasedataid").getString("name"), DateUtils.format((Date)firstDateOfMonth, (String)new DateUtils().yyyymmddChinese()), DateUtils.format((Date)latDateOfMonth, (String)new DateUtils().yyyymmddChinese()), typeName));
                            continue;
                        }
                        if (!historyMap.containsKey(key)) continue;
                        detailMsg.append(String.format(ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s", (String)"HistoryDownloadPlugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getDynamicObject("fbasedataid").getString("name"), DateUtils.format((Date)firstDateOfMonth, (String)new DateUtils().yyyymmddChinese()), DateUtils.format((Date)latDateOfMonth, (String)new DateUtils().yyyymmddChinese()), typeName)).append(SEPARATOR);
                    }
                }
                if (org.apache.commons.collections.CollectionUtils.isEmpty(messageList)) {
                    if (StringUtils.isBlank((CharSequence)detailMsg)) {
                        this.doDownloadHistory();
                    } else {
                        this.historyDownloadConfirmTips("downloadhistory", detailMsg.toString());
                    }
                } else {
                    this.dealMessage(messageList);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (event.getResult() == MessageBoxResult.Yes && "downloadhistory".equals(callBackId)) {
            this.getPageCache().put("updateCache", "1");
            this.doDownloadHistory();
            this.getPageCache().put("updateCache", "0");
        }
    }

    private void doDownloadHistory() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date startDate = dataEntity.getDate("startdate");
        Date endDate = dataEntity.getDate("enddate");
        String taxlimitCode = dataEntity.getString("taxlimit");
        String datatype = dataEntity.getString("declaredatatype");
        TaxPeriodType taxlimit = TaxPeriodType.valueCode((String)taxlimitCode);
        DynamicObjectCollection orgs = dataEntity.getDynamicObjectCollection("org");
        DynamicObject taxtype = dataEntity.getDynamicObject("taxtype");
        List listPeriod = DateUtils.getPeriodDate((Date)startDate, (Date)endDate, (TaxPeriodType)taxlimit);
        if (listPeriod.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u671f\u4e0e\u7f34\u7eb3\u671f\u9650\u4e0d\u5339\u914d\uff0c\u8bf7\u6309\u7f34\u7eb3\u671f\u9650\u9009\u62e9\u53ef\u7528\u7684\u6240\u5c5e\u7a0e\u671f\u3002", (String)"HistoryDownloadPlugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        StringBuilder errorMsg = new StringBuilder();
        int orgCount = orgs.size();
        int failCount = 0;
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orgs)) {
            String failmsg;
            List<Long> orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Map<Long, String> orgMap = this.buildTaxorgMap(orgIds);
            for (DynamicObject org : orgs) {
                DynamicObject orgbasedata = org.getDynamicObject("fbasedataid");
                long orgId = orgbasedata.getLong("id");
                for (Date[] period : listPeriod) {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(12);
                    paramMap.put("nsrsbh", orgMap.get(orgId));
                    Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)period[0]);
                    Date latDateOfMonth = DateUtils.getLastDateOfMonth((Date)period[1]);
                    paramMap.put("skssqq", DateUtils.format((Date)firstDateOfMonth, (String)"yyyy-MM-dd"));
                    paramMap.put("skssqz", DateUtils.format((Date)latDateOfMonth, (String)"yyyy-MM-dd"));
                    paramMap.put("org", orgbasedata.getLong("id"));
                    if ("1".equals(datatype)) {
                        paramMap.put("key", "lsxz");
                    } else {
                        paramMap.put("key", "qcxz");
                    }
                    Set suppliers = TsateCommonConfig.getInstance().getAllSupplier(Long.valueOf(orgId));
                    DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)taxtype.getString("number"));
                    SupplierEnum chooseSupplier = TsateDeclareHistoryBusiness.selectSupportSupplierFirst((Set)suppliers, (String)datatype, (DeclareTypeEnum)declareType);
                    if (chooseSupplier == null) {
                        errorMsg.append(ResManager.loadKDString((String)"%s:\u7ec4\u7ec7\u672a\u914d\u7f6e\u652f\u6301\u8be5\u7533\u62a5\u8868\u4e0b\u8f7d\u529f\u80fd\u7684\u901a\u9053", (String)"HistoryDownloadPlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgbasedata.getString("name")})).append(SEPARATOR);
                        ++failCount;
                        continue;
                    }
                    DynamicObject[] dynamicObjects = HistoryDownloadPlugin.assembleDeclareRecord(orgId, firstDateOfMonth, latDateOfMonth, declareType.getCode(), datatype, chooseSupplier);
                    paramMap.put("recordid", dynamicObjects[0].getLong("id"));
                    paramMap.put("supplier", chooseSupplier.getCode());
                    paramMap.put("type", taxtype.getString("number"));
                    paramMap.put("declaredatatype", datatype);
                    paramMap.put("updateCache", this.getPageCache().get("updateCache"));
                    JobUtils.submitJob(paramMap);
                }
            }
            this.getView().close();
            String successmsg = ResManager.loadKDString((String)"\u6570\u636e\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u7533\u62a5\u7ed3\u679c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"HistoryDownloadPlugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            if (failCount == 0) {
                this.getView().getParentView().showSuccessNotification(successmsg);
            } else if (failCount == orgCount) {
                failmsg = ResManager.loadKDString((String)"\u5171\u9009\u62e9%1$s\u6761\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\uff0c%2$s\u6761\u4e0b\u8f7d\u5931\u8d25\u3002", (String)"HistoryDownloadPlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgCount, failCount});
                this.showCustomConfirm(failmsg, errorMsg.toString());
            } else {
                failmsg = ResManager.loadKDString((String)"\u5171\u9009\u62e9%1$s\u6761\u7a0e\u52a1\u7ec4\u7ec7\u6570\u636e\uff0c%2$s\u6761\u4e0b\u8f7d\u5931\u8d25\uff0c%3$s\u6761\u6570\u636e\u4e0b\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u7533\u62a5\u7ed3\u679c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"HistoryDownloadPlugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[]{orgCount, failCount, orgCount - failCount});
                this.showCustomConfirm(failmsg, errorMsg.toString());
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void showCustomConfirm(String msg, String detail) {
        MessageBoxOptions options = MessageBoxOptions.OK;
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"HistoryDownloadPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(msg, detail, options, ConfirmTypes.Default, null, btnNameMaps);
    }

    private Map<Long, String> buildTaxorgMap(List<Long> orgIds) {
        DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"unifiedsocialcode,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, String> taxOrgMap = new HashMap<Long, String>();
        if (taxorgs != null && taxorgs.length > 0) {
            Map<Long, String> map = Arrays.stream(taxorgs).collect(Collectors.toMap(o -> o.getDynamicObject("org").getLong("id"), o -> o.getString("unifiedsocialcode")));
            taxOrgMap.putAll(map);
        }
        return taxOrgMap;
    }

    private Map<String, String> buildRecordMap(DynamicObject taxtype, List<Long> orgIds) {
        QFilter qFilter = new QFilter("org", "in", orgIds).and(new QFilter("type", "=", (Object)taxtype.getString("number"))).and(new QFilter("executestatus", "=", (Object)"1")).and(new QFilter("tasktype.number", "=", (Object)"LSXZ"));
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> recordMap = new HashMap<String, String>();
        if (records != null && records.length > 0) {
            Map<String, String> map = Arrays.stream(records).collect(Collectors.toMap(o -> o.getDynamicObject("org").getString("id") + "_" + o.getString("type") + "_" + DateUtils.format((Date)o.getDate("skssqq"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)o.getDate("skssqz"), (String)"yyyy-MM-dd"), o -> o.getString("id"), (key1, key2) -> key2));
            recordMap.putAll(map);
        }
        return recordMap;
    }

    private Map<String, String> buildHistoryMap(DynamicObject taxtype, List<Long> orgIds) {
        QFilter qFilter = new QFilter("org", "in", orgIds).and(new QFilter("type", "=", (Object)taxtype.getString("number")));
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"tsate_declare_history", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_history"), (QFilter[])new QFilter[]{qFilter});
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (records != null && records.length > 0) {
            Map<String, String> map = Arrays.stream(records).collect(Collectors.toMap(o -> o.getDynamicObject("org").getString("id") + "_" + o.getString("type") + "_" + DateUtils.format((Date)o.getDate("skssqq"), (String)"yyyy-MM-dd") + "_" + DateUtils.format((Date)o.getDate("skssqz"), (String)"yyyy-MM-dd"), o -> o.getString("id"), (key1, key2) -> key2));
            dataMap.putAll(map);
        }
        return dataMap;
    }

    private void historyDownloadConfirmTips(String key, String details) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"HistoryDownloadPlugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"HistoryDownloadPlugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f4\u8fde\u4e0b\u8f7d\u7684\u8bb0\u5f55\uff0c\u786e\u8ba4\u662f\u5426\u8981\u91cd\u65b0\u4e0b\u8f7d\uff1f", (String)"HistoryDownloadPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, details, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void dealMessage(List<String> messages) {
        if (messages.size() == 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5b58\u5728\u6b63\u5728\u4e0b\u8f7d\u7684\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"HistoryDownloadPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[]{messages.get(0)}));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(true);
            parameters.setCustomParam("operateName", (Object)"");
            String title = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u5728\u4e0b\u8f7d\u7684\u4efb\u52a1\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"HistoryDownloadPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), new Object[0]);
            parameters.setCustomParam("title", (Object)title);
            parameters.setCustomParam("errorMsg", messages);
            this.getView().showForm(parameters);
        }
    }

    private static List<Long> filterByIsTaxpayer() {
        DynamicObjectCollection taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)Boolean.TRUE).and(new QFilter("status", "=", (Object)"1"))});
        return CollectionUtils.isEmpty((Collection)taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> excludeByTaxPayer(List<Long> orgList) {
        List<Long> orgIds = HistoryDownloadPlugin.filterByIsTaxpayer();
        orgList.removeIf(s -> !orgIds.contains(s));
        return orgList;
    }

    private static DynamicObject[] assembleDeclareRecord(Long orgId, Date skssqq, Date skssqz, String declareType, String declareDataType, SupplierEnum supplier) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        dynamicObject.set("org", (Object)orgId);
        dynamicObject.set("skssqq", (Object)skssqq);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", (Object)skssqz);
        dynamicObject.set("type", (Object)declareType);
        dynamicObject.set("billstatus", (Object)"C");
        ExecuteTypeEnums taskType = ExecuteTypeEnums.LSXZ;
        if ("0".equals(declareDataType)) {
            taskType = ExecuteTypeEnums.QCXZ;
        }
        dynamicObject.set("executetype", (Object)taskType.getExecuteType());
        dynamicObject.set("tasktype", (Object)taskType.getId());
        dynamicObject.set("channel", (Object)supplier.getCode());
        dynamicObject.set("declarechannel", (Object)supplier.getId());
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static List<Long> getTaxorganIds(List<String> channels, List<String> nsrTypes) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("declarechannel.number", "in", channels)).and(new QFilter("taxtypecopy.fbasedataid", "in", nsrTypes));
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"tsate_declare_channel", (String)"id,declarechannel,taxorgancopy", (QFilter[])new QFilter[]{qFilter});
        HashSet taxorganIds = new HashSet();
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                obj.getDynamicObjectCollection("taxorgancopy").stream().forEach(o -> taxorganIds.add(o.getDynamicObject("fbasedataid").getLong("id")));
            }
            return new ArrayList<Long>(taxorganIds);
        }
        return null;
    }

    private static List<Long> getParentTaxauthorityById(List<Long> taxauthorityIds, List<Long> ids) {
        ArrayList<Long> tempIds = new ArrayList<Long>();
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"id,parent.id", (QFilter[])new QFilter[]{qFilter});
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                if (obj.getLong("parent.id") == 0L) {
                    taxauthorityIds.add(obj.getLong("id"));
                    continue;
                }
                tempIds.add(obj.getLong("parent.id"));
            }
            HistoryDownloadPlugin.getParentTaxauthorityById(taxauthorityIds, tempIds);
        }
        return taxauthorityIds;
    }

    private List<Long> getChildTaxauthorityByIds(List<Long> ids, List<Long> taxauthorityIds) {
        ids.addAll(taxauthorityIds);
        QFilter qFilter = new QFilter("parent", "in", taxauthorityIds);
        ArrayList<Long> tempIds = new ArrayList<Long>();
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bastax_taxorgan", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
        if (objs != null && objs.length > 0) {
            for (DynamicObject obj : objs) {
                tempIds.add(obj.getLong("id"));
            }
            this.getChildTaxauthorityByIds(ids, tempIds);
        }
        return ids;
    }

    private void taxLimitSetting() {
        DynamicObject dyn = (DynamicObject)this.getModel().getValue("taxtype");
        if (dyn == null) {
            return;
        }
        String taxType = dyn.getString("number");
        List<String> options = HistoryDownloadPeriodType.getTaxPeriodTypeCodesByTaxCode(taxType);
        ComboEdit ctl = (ComboEdit)this.getControl("taxlimit");
        ComboEditUtils.setOptions(ctl, options);
    }

    private void taxperiodSetting() {
        String declaredatatype = (String)this.getModel().getValue("declaredatatype");
        this.setDefaultPeriod(!"0".equals(declaredatatype));
    }

    private void setDefaultPeriod(boolean enbaleTaxPeriod) {
        Date qq = null;
        Date qz = null;
        if (this.getModel().getValue("taxlimit").equals("month")) {
            Date lastMonth = DateUtils.addMonth((Date)new Date(), (int)-1);
            qq = DateUtils.getFirstDateOfMonth((Date)lastMonth);
            qz = DateUtils.getLastDateOfMonth((Date)lastMonth);
        } else if (this.getModel().getValue("taxlimit").equals("season")) {
            Date firstDateOfSeason = DateUtils.getFirstDateOfSeason((Date)new Date());
            qq = DateUtils.addMonth((Date)firstDateOfSeason, (int)-3);
            qz = DateUtils.getLastDateOfSeason((Date)qq);
        }
        if (qq == null || qz == null) {
            return;
        }
        this.getModel().setValue("startdate", (Object)qq);
        this.getModel().setValue("enddate", (Object)qz);
        this.getView().setEnable(Boolean.valueOf(enbaleTaxPeriod), new String[]{"taxperiod"});
    }

    public void setDeclareDataTypeItems() {
        ComboEdit declareTypeCombo = (ComboEdit)this.getControl("declaredatatype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(2);
        List<Long> orgsFromView = this.getOrgsFromView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String oldValue = dataEntity.getString("declaredatatype");
        DynamicObject taxtype = dataEntity.getDynamicObject("taxtype");
        if (orgsFromView == null || orgsFromView.isEmpty() || taxtype == null) {
            declareTypeCombo.setComboItems(comboItems);
            this.getModel().beginInit();
            this.getModel().setValue("declaredatatype", null);
            this.getModel().endInit();
            this.getView().updateView("declaredatatype");
            return;
        }
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)taxtype.getString("number"));
        Set declareDataType = TsateDeclareHistoryBusiness.getDeclareDataType(orgsFromView, (DeclareTypeEnum)declareType);
        List oriComboItems = ((ComboProp)declareTypeCombo.getProperty()).getComboItems();
        boolean isChangeValue = true;
        for (ValueMapItem item : oriComboItems) {
            String value = item.getValue();
            if (!declareDataType.contains(value)) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(item.getName());
            comboItem.setValue(value);
            if (StringUtils.equals((CharSequence)oldValue, (CharSequence)value)) {
                isChangeValue = false;
            }
            comboItems.add(comboItem);
        }
        declareTypeCombo.setComboItems(comboItems);
        this.getModel().beginInit();
        if (comboItems.size() > 0) {
            if (isChangeValue) {
                this.getModel().setValue("declaredatatype", (Object)((ComboItem)comboItems.get(0)).getValue());
            } else {
                this.getModel().setValue("declaredatatype", (Object)oldValue);
            }
        } else {
            this.getModel().setValue("declaredatatype", null);
        }
        this.getModel().endInit();
        this.getView().updateView("declaredatatype");
    }

    private List<Long> getOrgsFromView() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection orgs = (DynamicObjectCollection)dataEntity.get("org");
        return orgs.parallelStream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
    }
}

