/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tsate.common.enums.TemplateEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.model.request.DeclareRequestModel;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.OrgUtils;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TreeUtils;

public class HistoryListPlugin
extends AbstractListPlugin {
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private String orgField = null;
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.getOrgField();
        if (this.orgField == null) {
            return;
        }
        CommonFilterColumn orgColumn = this.getOrgFilterColumn(filterColumnList);
        if (orgColumn == null) {
            return;
        }
        List<ComboItem> combos = this.getOrgComboItem();
        String defaultOrg = this.getPageCache().get("CACHE_DEFAULT_ORG");
        if (defaultOrg == null && !combos.isEmpty()) {
            defaultOrg = combos.get(0).getValue();
        }
        orgColumn.setDefaultValue(defaultOrg);
        orgColumn.setType("enum");
        orgColumn.setComboItems(combos);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put("customfilter", new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put("FieldName", fieldName);
                if (filterColumn.getFieldName().startsWith(this.orgField + ".")) {
                    ArrayList<String> value = new ArrayList<String>();
                    value.add(defaultOrg);
                    customFiter.put("Value", value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put("Value", filterColumn.getDefaultValues());
                }
                if (customFiter.get("Value") == null) continue;
                this.filterValues.get("customfilter").add(customFiter);
            }
            this.customfilter = this.filterValues.get("customfilter");
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put("customfilter", customfilterSer);
            this.getPageCache().put("CACHE_DEFAULT_ORG", defaultOrg);
            this.getPageCache().put("verifyOrg", defaultOrg);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"bdtaxr_taxbureau_sbb");
        if ("skssqq".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            this.openHistorySbb(object.getString("id"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        DynamicObject[] executerecords;
        if ("tblrefresh".equals(evt.getItemKey()) && (executerecords = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)"id,org,executetype,tasktype,skssqq,skssqz,type,declarechannel", (QFilter[])new QFilter[]{new QFilter("executestatus", "=", (Object)"1").and("declarechannel.number", "in", Arrays.asList("1", "8")).and("tasktype.number", "in", Arrays.asList("LSXZ", "QCXZ"))})) != null) {
            for (DynamicObject executerecord : executerecords) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgId((Long)executerecord.getLong("org.id"));
                DynamicObject taxorg = (DynamicObject)taxResult.getData();
                paramMap.put("nsrsbh", taxorg.get("unifiedsocialcode"));
                paramMap.put("skssqq", DateUtils.format((Date)executerecord.getDate("skssqq"), (String)"yyyy-MM-dd"));
                paramMap.put("skssqz", DateUtils.format((Date)executerecord.getDate("skssqz"), (String)"yyyy-MM-dd"));
                paramMap.put("org", executerecord.getDynamicObject("org").getLong("id"));
                paramMap.put("recordid", executerecord.getLong("id"));
                String key = executerecord.getDynamicObject("taskType").getString("number");
                if ("QCXZ".equals(key)) {
                    paramMap.put("key", "qcxz");
                } else if ("LSXZ".equals(key)) {
                    paramMap.put("key", "lsxz");
                }
                String channelNumber = executerecord.getDynamicObject("declarechannel").getString("number");
                paramMap.put("supplier", channelNumber);
                paramMap.put("type", executerecord.getString("type"));
                paramMap.put("isQuery", Boolean.TRUE);
                try {
                    this.doMsg("taxc", "tsate", "MessageSendPlugin", "doCustomService", paramMap);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("downloadhistory".equals(args.getOperateKey())) {
                List orgs = this.getControlFilters().getFilter("org.id");
                HashMap customParams = new HashMap();
                if (!CollectionUtils.isEmpty((Collection)orgs)) {
                    customParams.put("org", orgs.get(0));
                }
                FormShowParameter param = new FormShowParameter();
                param.setCustomParams(customParams);
                param.setFormId("tsate_download_history");
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "historydownload");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm(param);
            } else if ("comparedata".equals(args.getOperateKey())) {
                this.compareData();
            } else if ("overridedata".equals(args.getOperateKey())) {
                this.overrideData();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("historydownload".equals(closedCallBackEvent.getActionId())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() == MessageBoxResult.Yes) {
            String customVaule = event.getCustomVaule();
            if ("overrideData".equals(event.getCallBackId())) {
                JSONObject jsonObject = JSONObject.parseObject((String)customVaule);
                List sbbIds = (List)jsonObject.get((Object)"sbbIds");
                this.doMsg("taxc", "bdtaxr", "TaxBureauDeclareService", "convert", sbbIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u8986\u76d6\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u8986\u76d6\u7ed3\u679c\u3002", (String)"HistoryListPlugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        }
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    public void setFilter(SetFilterEvent e) {
        ArrayList<QFilter> resultFilter = new ArrayList<QFilter>();
        List<Long> orgIds = this.getOrgListHasPermission();
        boolean isHasOrg = false;
        for (QFilter eQFilter : e.getQFilters()) {
            for (QFilter filter : eQFilter.recombine()) {
                if ("skssqq".equals(filter.getProperty())) {
                    if ("<".equals(filter.getCP())) {
                        resultFilter.add(new QFilter("skssqz", "<", filter.getValue()));
                        continue;
                    }
                    resultFilter.add(filter);
                    continue;
                }
                if (filter.getProperty().startsWith("org.")) {
                    isHasOrg = true;
                }
                resultFilter.add(filter);
            }
        }
        if (!CollectionUtils.isEmpty(resultFilter)) {
            if (!isHasOrg && !CollectionUtils.isEmpty(orgIds)) {
                resultFilter.add(new QFilter("org", "in", orgIds));
            }
        } else if (!CollectionUtils.isEmpty(orgIds)) {
            resultFilter.add(new QFilter("org", "in", orgIds));
        }
        e.getQFilters().clear();
        e.getQFilters().addAll(resultFilter);
    }

    private String getOrgField() {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_declare_history");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        for (IDataEntityProperty property : mainPros) {
            BasedataProp decProp;
            if (!(property instanceof BasedataProp) || !"bos_org".equals((decProp = (BasedataProp)property).getBaseEntityId())) continue;
            this.orgField = decProp.getName();
            break;
        }
        return this.orgField;
    }

    private CommonFilterColumn getOrgFilterColumn(List<FilterColumn> filterColumnList) {
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(this.orgField + ".") || !(filterColumn instanceof CommonFilterColumn)) continue;
            return (CommonFilterColumn)filterColumn;
        }
        return null;
    }

    private List<ComboItem> getOrgComboItem() {
        String orgListCache = "orgListCache";
        String orgListCacheString = this.getPageCache().get(orgListCache);
        List orgList = new ArrayList();
        if (orgListCacheString == null || org.apache.commons.lang3.StringUtils.equals((CharSequence)orgListCacheString, (CharSequence)"[]")) {
            orgList = OrgUtils.queryOrgListForInitOrgComboItems((IFormView)this.getView(), (String[])new String[]{"tsate_declare_history"}, null, null);
            this.getPageCache().put(orgListCache, SerializationUtils.toJsonString(orgList));
        } else {
            orgList = (List)SerializationUtils.fromJsonString((String)orgListCacheString, orgList.getClass());
        }
        return OrgUtils.getComboItems(orgList);
    }

    private List<Long> getOrgListHasPermission() {
        DynamicObjectCollection col;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgs != null && !hasPermOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)(col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false)))) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    private void compareData() {
        String title;
        DynamicObject[] historyObj;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"HistoryListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> messageList = new ArrayList<String>();
        ArrayList<String> noneedList = new ArrayList<String>();
        ArrayList<Long> sbbIds = new ArrayList<Long>();
        for (DynamicObject history : historyObj = BusinessDataServiceHelper.load((String)"tsate_declare_history", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_history"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list.getPrimaryKeyValues())})) {
            DynamicObject org = history.getDynamicObject("org");
            String type = history.getString("type");
            String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
            String skssqq = DateUtils.format((Date)history.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)history.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            if ("comparing".equals(history.getString("comparestatus"))) {
                messageList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (String)"HistoryListPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName));
                continue;
            }
            if ("noneed".equals(history.getString("comparestatus"))) {
                String msg = "%s %s %S~%s";
                noneedList.add(String.format(msg, history.getString("org.name"), typeName, skssqq, skssqz));
            }
            sbbIds.add(history.getLong("id"));
        }
        if (noneedList.size() > 0) {
            title = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u65e0\u9700\u6bd4\u5bf9\u7684\u6570\u636e\u65e0\u6cd5\u64cd\u4f5c\u6570\u636e\u5dee\u5f02\u6bd4\u5bf9", (String)"HistoryListPlugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            this.dealMessage(noneedList, title);
            return;
        }
        if (CollectionUtils.isEmpty(messageList)) {
            this.doMsg("taxc", "bdtaxr", "TaxBureauDeclareService", "compare", sbbIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u6bd4\u5bf9\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u6bd4\u5bf9\u7ed3\u679c\u3002", (String)"HistoryListPlugin_13", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            billlist.refresh();
        } else {
            title = ResManager.loadKDString((String)"\u5b58\u5728\u6bd4\u5bf9\u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"HistoryListPlugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            this.dealMessage(messageList, title);
        }
    }

    private void overrideData() {
        DynamicObject[] historyObj;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"HistoryListPlugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> messageList = new ArrayList<String>();
        ArrayList<Long> sbbIds = new ArrayList<Long>();
        for (DynamicObject history : historyObj = BusinessDataServiceHelper.load((String)"tsate_declare_history", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_history"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)list.getPrimaryKeyValues())})) {
            DynamicObject org = history.getDynamicObject("org");
            String type = history.getString("type");
            String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
            String skssqq = DateUtils.format((Date)history.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)history.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            if (!"diff".equals(history.getString("comparestatus"))) {
                messageList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (String)"HistoryListPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName));
                continue;
            }
            if (!("undo".equals(history.getString("convertstatus")) || "fail".equals(history.getString("convertstatus")) || EmptyCheckUtils.isEmpty((Object)history.getString("convertstatus")))) {
                messageList.add(String.format(ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u6ee1\u8db3\u6761\u4ef6\u3002", (String)"HistoryListPlugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName));
                continue;
            }
            sbbIds.add(history.getLong("id"));
        }
        if (CollectionUtils.isEmpty(messageList)) {
            String msg = ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u8981\u8986\u76d6\u7533\u62a5\u6570\u636e", (String)"HistoryListPlugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            this.confirmTips("overrideData", msg, sbbIds);
        } else {
            String title = ResManager.loadKDString((String)"\u4ec5\u5dee\u5f02\u6bd4\u5bf9\u7ed3\u679c\u4e3a\u201c\u6709\u5dee\u5f02\u201d\u4e14\u6570\u636e\u8986\u76d6\u72b6\u6001\u4e3a\u201c\u672a\u8986\u76d6\u201d\u6216\u201c\u8986\u76d6\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u6570\u636e\u8986\u76d6\u64cd\u4f5c\u3002", (String)"HistoryListPlugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            this.dealMessage(messageList, title);
        }
    }

    private void dealMessage(List<String> messages, String title) {
        if (messages.size() == 1) {
            this.getView().showErrorNotification(this.removeTrailingPeriod(title) + "\uff1a" + messages.get(0));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(false);
            parameters.setCustomParam("operateName", (Object)"");
            parameters.setCustomParam("title", (Object)title);
            parameters.setCustomParam("errorMsg", messages);
            this.getView().showForm(parameters);
        }
    }

    public String removeTrailingPeriod(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        if (str.charAt(str.length() - 1) == '\u3002') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void confirmTips(String key, String message, List<Long> sbbIds) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"HistoryListPlugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"HistoryListPlugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap<String, List<Long>> customValueMap = new HashMap<String, List<Long>>();
        customValueMap.put("sbbIds", sbbIds);
        this.getView().showConfirm(message, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }

    private void openHistorySbb(String sbbid) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(sbbid), (String)"bdtaxr_taxbureau_sbb");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("sbbid", object.getString("id"));
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("type", object.getString("type"));
        customParams.put("templatetype", object.getString("type"));
        customParams.put("taxPayerType", object.getString("type"));
        customParams.put("deadLine", "month".equals(object.getString("taxlimit")) ? "aysb" : "ajsb");
        customParams.put("tcrettype", object.getString("tcrettype"));
        customParams.put("apanage", object.getString("apanage"));
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
        customParams.put("taxperiod", startDate.substring(0, 7));
        customParams.put("readonly", Boolean.TRUE);
        customParams.put("datasource", "taxBureau");
        customParams.put("modifytime", object.getDate("modifytime"));
        String dataType = object.getString("datatype");
        customParams.put("datatype", dataType);
        customParams.put("entityid", "bdtaxr_taxbureau_sbb");
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)StringUtils.trimToEmpty((String)object.getString("type")));
        param.setFormId(templateEnum.getDeclareShowPage());
        param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(object.getString("type")) + DeclareConstant.getDeclaredDatdCn());
        if (object != null) {
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType(object.getString("type"));
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate("skssqq")));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate("skssqz")));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.FALSE);
            requestModel.setDataSource("taxBureau");
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void doMsg(String cloudId, String appId, String serviceName, String methodName, Object ... paras) {
        DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])paras);
    }
}

