/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.declare;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.event.DeclareMainStatusChangedEventBusiness;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.formplugin.utils.JobUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TaxTsateDeclareInfo
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(TaxTsateDeclareInfo.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String BTN_DIALOGSETTING = "dialogsetting";

    public void initialize() {
        this.addClickListeners(new String[]{"viewpic", "continue", BTN_DIALOGSETTING});
    }

    public void beforeBindData(EventObject e) {
        FormShowParameter formShowParameter = ((BillView)e.getSource()).getFormShowParameter();
        long pkId = (Long)((BillShowParameter)formShowParameter).getPkId();
        Map customParams = formShowParameter.getCustomParams();
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tsate_declare_record");
        SupplierEnum channel = SupplierEnum.valueOfCode((String)dyn.getString("channel"));
        if (channel == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bb0\u5f55\u5bf9\u5e94\u901a\u9053\u672a\u627e\u5230\u3002", (String)"TaxTsateDeclareInfo_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        if (dyn != null) {
            String sbbid = dyn.getString("sbbid");
            this.isShowContinue(dyn, channel.getCode());
            this.isShowDialogSetting(Long.parseLong(sbbid));
            if (SupplierEnum.YZF == channel || SupplierEnum.QXY == channel) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"viewpic"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"viewpic"});
            }
            this.dealShowMessage(dyn);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long pkId = (Long)((BillShowParameter)formShowParameter).getPkId();
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tsate_declare_record");
        String sbbid = dyn.getString("sbbid");
        if ("viewpic".equals(control.getKey())) {
            if (dyn != null) {
                List imgs = TsateDeclareRecordBusiness.getPic((DynamicObject)dyn);
                if (imgs.size() > 0) {
                    this.getView().showPictureView(imgs.toArray(new String[0]), 0);
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a", (String)"TaxTsateDeclareInfo_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("continue".equals(control.getKey())) {
            if (dyn != null) {
                String data = dyn.getString("piclog");
                if (StringUtils.isNotBlank((CharSequence)data)) {
                    List forceCodeList;
                    Object forceCodeData;
                    FileService fileService = FileServiceFactory.getAttachmentFileService();
                    InputStream in = fileService.getInputStream(data);
                    String log = TaxTsateDeclareInfo.getStringByInputStream(in);
                    Map dataMap = (Map)JsonUtil.fromJson((String)log, Map.class);
                    if (dataMap != null && dataMap.containsKey("forceCodeList") && EmptyCheckUtils.isNotEmpty(forceCodeData = dataMap.get("forceCodeList")) && CollectionUtils.isNotEmpty((Collection)(forceCodeList = (List)forceCodeData))) {
                        ArrayList<String> forceCodes = new ArrayList<String>(forceCodeList.size());
                        for (Map forceCode : forceCodeList) {
                            forceCodes.add((String)forceCode.get("forceCode"));
                        }
                        HashMap<String, Object> paramMap = new HashMap<String, Object>();
                        paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                        paramMap.put("transrc", "directdeclare");
                        paramMap.put("businessId", dyn.getString("sbbid"));
                        paramMap.put("isQuery", false);
                        paramMap.put("operationType", "qzsb");
                        paramMap.put("key", "qzsb");
                        paramMap.put("forceCodes", forceCodes);
                        ApiResult result = (ApiResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DirectDeclarePlugin", (String)"doCustomService", (Object[])new Object[]{paramMap});
                        if (!result.getSuccess()) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f3a\u5236\u7533\u62a5\u914d\u7f6e\u5931\u8d25", (String)"TaxTsateDeclareInfo_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                        } else {
                            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)dyn.getLong("sbbid"), (String)"tcvat_nsrxx");
                            DynamicObject oldData = DeclareMainStatusChangedEventBusiness.copyData((DynamicObject)declare);
                            if (declare != null) {
                                DynamicObject[] recordLog = TaxTsateDeclareInfo.assembleDeclareRecord(declare, "ZLSB");
                                declare.set("declarestatus", (Object)"submitted");
                                declare.set("declaretype", (Object)"1");
                                declare.set("declarer", (Object)RequestContext.get().getUserId());
                                declare.set("declaretype", (Object)"1");
                                declare.set("sbrq", (Object)new Date());
                                paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                                paramMap.put("transrc", "directdeclare");
                                paramMap.put("businessId", dyn.getString("sbbid"));
                                paramMap.put("isQuery", false);
                                paramMap.put("operationType", "directdeclare");
                                paramMap.put("recordtype", "ZLSB");
                                paramMap.put("recordid", recordLog[0].getLong("id"));
                                paramMap.put("key", "directdeclare");
                                paramMap.put("forceCodes", forceCodeList);
                                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{declare});
                                DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent((DynamicObject)oldData, (DynamicObject)declare);
                                JobUtils.submitJob(paramMap);
                                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u7533\u62a5\u4e2d\uff0c\u8bf7\u7a0d\u540e\u5237\u65b0\u754c\u9762\u67e5\u770b\u7533\u62a5\u7ed3\u679c\uff0c\u6216\u524d\u5f80\u62a5\u7a0e\u4efb\u52a1\u76d1\u63a7\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"TaxTsateDeclareInfo_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                                this.getView().close();
                            }
                        }
                    }
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u5185\u5bb9\u4e3a\u7a7a", (String)"TaxTsateDeclareInfo_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (BTN_DIALOGSETTING.equals(control.getKey())) {
            Long declareId = Long.parseLong(sbbid);
            this.dealSjtc(declareId);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u65e5\u5fd7\u8be6\u60c5", (String)"TaxTsateDeclareInfo_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
    }

    private static String getStringByInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int n;
            byte[] b = new byte[1024];
            while ((n = inputStream.read(b)) != -1) {
                outputStream.write(b, 0, n);
            }
        }
        catch (Exception e) {
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
            }
        }
        return outputStream.toString();
    }

    private void dealShowMessage(DynamicObject dyn) {
        Object forceCodeData;
        FileService fileService;
        InputStream in;
        String log;
        Map dataMap;
        String piclog;
        String picData;
        String data = dyn.getString("deallog");
        StringBuilder message = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)data)) {
            String log2 = null;
            if (data.startsWith("FILE:")) {
                FileService fileService2 = FileServiceFactory.getAttachmentFileService();
                InputStream in2 = fileService2.getInputStream(data.substring(5));
                log2 = TaxTsateDeclareInfo.getStringByInputStream(in2);
            } else {
                log2 = data;
            }
            message.append(log2).append(SEPARATOR);
        }
        if (EmptyCheckUtils.isNotEmpty((Object)(picData = dyn.getString("piclog"))) && StringUtils.isNotBlank((CharSequence)(piclog = dyn.getString("piclog"))) && (dataMap = (Map)JsonUtil.fromJson((String)(log = TaxTsateDeclareInfo.getStringByInputStream(in = (fileService = FileServiceFactory.getAttachmentFileService()).getInputStream(piclog))), Map.class)) != null && dataMap.containsKey("forceCodeList") && EmptyCheckUtils.isNotEmpty(forceCodeData = dataMap.get("forceCodeList"))) {
            List forceCodeList = (List)forceCodeData;
            message.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u63d0\u793a", (String)"TaxTsateDeclareInfo_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0])).append(SEPARATOR);
            for (Map forceCode : forceCodeList) {
                message.append(forceCode.get("forceDesc")).append(SEPARATOR);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)message)) {
            this.getModel().setValue("log", (Object)message.toString());
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u5185\u5bb9\u4e3a\u7a7a", (String)"TaxTsateDeclareInfo_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
    }

    private static DynamicObject[] assembleDeclareRecord(DynamicObject declare, String executeType) {
        DynamicObject channelObj;
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        DynamicObject org = declare.getDynamicObject("org");
        dynamicObject.set("org", (Object)org.getLong("id"));
        dynamicObject.set("skssqq", (Object)declare.getDate("skssqq"));
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        dynamicObject.set("executestatus", (Object)"1");
        dynamicObject.set("skssqz", (Object)declare.getDate("skssqz"));
        dynamicObject.set("type", (Object)declare.getString("type"));
        dynamicObject.set("billstatus", (Object)"C");
        dynamicObject.set("sbbid", (Object)declare.getString("id"));
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)executeType)});
        if (taskObj != null) {
            dynamicObject.set("executetype", (Object)executeType);
            dynamicObject.set("tasktype", (Object)taskObj.getLong("id"));
        }
        if ((channelObj = CommonInfoUtil.getChannel((Long)declare.getLong("id"))) != null) {
            dynamicObject.set("channel", (Object)channelObj.getDynamicObject("declarechannel").getString("number"));
            dynamicObject.set("declarechannel", (Object)channelObj.getDynamicObject("declarechannel").getLong("id"));
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        dynamicObject = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
        String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
        dynamicObject.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private void isShowContinue(DynamicObject object, String channel) {
        String data;
        long userId = Long.parseLong(RequestContext.get().getUserId());
        Long orgId = object.getDynamicObject("org").getLong("id");
        String appId = AppMetadataCache.getAppInfo((String)"tsate").getId();
        int i = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)"tsate_declare_query_list", (String)"1Z3WJSE25I8S");
        if (i != 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"continue"});
        }
        if (StringUtils.isNotBlank((CharSequence)(data = object.getString("piclog")))) {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            InputStream in = fileService.getInputStream(data);
            String log = TaxTsateDeclareInfo.getStringByInputStream(in);
            Map dataMap = (Map)JsonUtil.fromJson((String)log, Map.class);
            if (dataMap != null && dataMap.containsKey("forceCodeList")) {
                Object imageData = dataMap.get("forceCodeList");
                if (EmptyCheckUtils.isNotEmpty(imageData) && SupplierEnum.YZF.getCode().equals(channel)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"continue"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"continue"});
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"continue"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"continue"});
        }
    }

    private void isShowDialogSetting(Long declareId) {
        DynamicObject dyn = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)declareId);
        DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)dyn.getString("declarestatus"));
        if (DeclareStatusEnum.DECLARED == declareStatus) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DIALOGSETTING});
        } else if (this.isExistDialog(declareId)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_DIALOGSETTING});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_DIALOGSETTING});
        }
    }

    private boolean isExistDialog(Long declareId) {
        Map statusMap = TasteDeclarePopupBusiness.querySbPopupStatus(Collections.singletonList(declareId));
        PoppupStatusEnum status = (PoppupStatusEnum)statusMap.get(declareId);
        return PoppupStatusEnum.INIT == status;
    }

    private void dealSjtc(Long declareId) {
        Map statusMap = TasteDeclarePopupBusiness.querySbPopupStatus(Collections.singletonList(declareId));
        PoppupStatusEnum status = (PoppupStatusEnum)statusMap.get(declareId);
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        if (PoppupStatusEnum.INIT == status) {
            param.setStatus(OperationStatus.ADDNEW);
        } else if (PoppupStatusEnum.SELECTED == status || PoppupStatusEnum.USED == status) {
            param.setStatus(OperationStatus.EDIT);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7533\u62a5\u8868\u4e0d\u5b58\u5728\u5f39\u7a97\u8bbe\u7f6e\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"TaxTsateDeclareInfo_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_DIALOGSETTING);
        param.setCloseCallBack(closeCallBack);
        param.setFormId("tsate_dynamic_popup_qxy");
        param.getOpenStyle().setShowType(ShowType.Modal);
        customParams.put("sbbid", declareId.toString());
        param.setCustomParams(customParams);
        this.getView().showForm(param);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        if (closedCallBackEvent.getActionId().equals(BTN_DIALOGSETTING) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            IFormView parentView = this.getView().getParentView();
            BillList billList = (BillList)parentView.getControl("billlistap");
            billList.refresh();
            this.getView().sendFormAction(parentView);
            return;
        }
    }
}

