/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.property.BasedataProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclarePageOpenHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.business.declare.SyncCancelStatusServiceImpl;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.DeclareConstant;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.TreeUtils;

public class TaxTsateDeclareList2Plugin
extends TsateBaseDeclarePlugin
implements BeforeFilterF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(TaxTsateDeclareList2Plugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String QFILTER_CACHE_PREFIX = "QFilter";
    private static final String APPLY = "apply";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String PAY = "pay";
    private static final String CANCELPAY = "cancelpay";
    private static final String IMPORT = "import";
    private static final String RISK_CONTENT = "riskcontent";
    private static final String REFRESH = "refresh";
    private static final String NOTICEFLAG = "notice";
    private String orgField = null;
    private static final Map<String, QFilter> filterCache = new HashMap<String, QFilter>(16);
    private static final String TCRET_DECLARE_MAIN = "tcret_declare_main";
    private static final Map<String, Object> cacheQFilterMap = new HashMap<String, Object>(16);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String[] TCVVT_FORMS = new String[]{"FR0001", "FR0002", "FR0003", "FR0004"};
    private static final String FILTER_ORG_KEY = "org.id";
    private static final String BTN_YYJK = "btn_yyjk";
    private static final String BTN_CANCELYYJK = "btn_cancelyyjk";
    private static final String BTN_UNDO = "btn_undo";
    private static final String BTN_REFRESH_ZWY = "btn_refreshstatus";
    private static final String BTN_SZYH = "btn_szyhplatform";
    private static final Long TAXOFFICE_ID_ZHEJIANG = 1010868748401298555L;
    private static final String CLOSECALLBACK_DIALOG = "closeCallback_dialog";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.btnSetting(this.getOrgFromFilter());
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "sjfk"});
    }

    public void setFilter(SetFilterEvent e) {
        cacheQFilterMap.remove(this.getPageCache().getPageId());
        this.initFilterOrg(e);
        this.initFilterSkssq(e);
        this.initFilterType(e);
        cacheQFilterMap.put(this.getPageCache().getPageId(), e.getQFilters());
    }

    private List<QFilter> existFilter(List<QFilter> filters, String key) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        for (QFilter eQFilter : filters) {
            for (QFilter filter : eQFilter.recombine()) {
                if (!filter.getProperty().equals(key)) continue;
                list.add(filter);
            }
        }
        return list;
    }

    private QFilter initFilterType(SetFilterEvent e) {
        QFilter typeFilter;
        List eventFilters = e.getQFilters();
        List<QFilter> filters = this.existFilter(eventFilters, "type");
        if (CollectionUtils.isEmpty(filters)) {
            typeFilter = new QFilter("type", "in", this.getTemplateTypeList());
            e.getQFilters().add(typeFilter);
        } else {
            typeFilter = filters.get(0);
        }
        return typeFilter;
    }

    private List<QFilter> initFilterSkssq(SetFilterEvent e) {
        ArrayList<QFilter> finalFilters = new ArrayList<QFilter>();
        List<QFilter> filters = this.existFilter(e.getQFilters(), "skssqq");
        for (QFilter filter : filters) {
            if ("<".equals(filter.getCP())) {
                e.getQFilters().remove(filter);
                QFilter skssqzFilter = new QFilter("skssqz", filter.getCP(), filter.getValue());
                e.getQFilters().add(skssqzFilter);
                finalFilters.add(skssqzFilter);
                continue;
            }
            finalFilters.add(filter);
        }
        return finalFilters;
    }

    private QFilter initFilterOrg(SetFilterEvent e) {
        List<QFilter> filters = this.existFilter(e.getQFilters(), FILTER_ORG_KEY);
        if (filters.size() != 0) {
            return filters.get(0);
        }
        String customfilterSer = this.getPageCache().get("customfilter");
        QFilter orgFilter = null;
        if (customfilterSer != null) {
            List customfilter = (List)SerializationUtils.fromJsonString((String)customfilterSer, List.class);
            for (Map customFiter : customfilter) {
                List orgs;
                List fieldNames = (List)customFiter.get("FieldName");
                if (CollectionUtils.isEmpty((Collection)fieldNames) || !fieldNames.get(0).toString().startsWith(this.orgField + ".")) continue;
                List orgIds = (List)customFiter.get("Value");
                if (CollectionUtils.isEmpty((Collection)orgIds) || CollectionUtils.isEmpty(orgs = orgIds.stream().filter(o -> StringUtils.isNotBlank((Object)o)).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList()))) break;
                orgFilter = new QFilter(this.orgField, "in", orgs);
                break;
            }
        }
        if (orgFilter == null) {
            if (this.ifHasAllPermission()) {
                return null;
            }
            List<Long> orgIds = this.getOrgListHasPermission();
            orgFilter = new QFilter(FILTER_ORG_KEY, "in", orgIds);
        }
        return orgFilter;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn = (CommonFilterColumn)args.getFilterColumn("type");
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (controlFilters == null) {
            orgIdList.add(RequestContext.get().getOrgId());
        } else {
            List orgIds = controlFilters.getFilter(FILTER_ORG_KEY);
            if (CollectionUtils.isEmpty((Collection)orgIds) || orgIds.get(0).equals("")) {
                if (this.ifHasAllPermission()) {
                    List<ComboItem> combos = this.getDeclareTypeComboItems(this.getTemplateTypeList());
                    typeColumn.setComboItems(combos);
                    return;
                }
                orgIdList.addAll(this.getOrgListHasPermission());
            } else {
                for (Object o : orgIds) {
                    orgIdList.add(Long.parseLong(o.toString()));
                }
            }
        }
        Set declareTypes = TsateChannelBusiness.getOrgDeclareTypeFromBaseConfig(orgIdList);
        List<ComboItem> combos = this.getDeclareTypeComboItems(this.filterDeclareType(declareTypes, this.getTemplateTypeList()));
        typeColumn.setComboItems((List)combos);
    }

    private Set<String> filterDeclareType(Set<String> toBeFilterData, Collection<String> validType) {
        HashSet<String> data = new HashSet<String>(8);
        for (String type : validType) {
            if (!toBeFilterData.contains(type)) continue;
            data.add(type);
        }
        return data;
    }

    private List<ComboItem> getDeclareTypeComboItems(Collection<String> declareTypeCodes) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(declareTypeCodes.size());
        for (String code : declareTypeCodes) {
            ComboItem item = new ComboItem();
            item.setValue(code);
            DeclareTypeEnum type = DeclareTypeEnum.valueOfCode((String)code);
            if (type == null) continue;
            item.setCaption(new LocaleString(type.getName()));
            combos.add(item);
        }
        return combos;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<QFilter> getQFilters() {
                List qFilters = super.getQFilters();
                qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
                super.setQFilters(qFilters);
                return qFilters;
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        if (REFRESH.equals(evt.getItemKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
            billlist.clearSelection();
            billlist.refresh();
            this.refreshStatus();
        } else if (VIEWFLOWCHART.equals(evt.getItemKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u518d\u64cd\u4f5c\u3002", (String)"TaxTsateDeclareList2Plugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wf_viewflowchart");
            showParameter.setClientParam("billId", (Object)list.get(0).getPrimaryKeyValue().toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if ("sbpz".equals(evt.getItemKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tsate_sbpz_admin", (IFormView)this.getView(), null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if (APPLY.equals(args.getOperateKey())) {
                this.manualDeclare();
            } else if (CANCELAPPLY.equals(args.getOperateKey())) {
                this.cancelDeclare();
            } else if (PAY.equals(args.getOperateKey())) {
                this.manualPay();
            } else if (CANCELPAY.equals(args.getOperateKey())) {
                this.cancelPay();
            } else if ("sjfk".equals(args.getOperateKey())) {
                this.dealSjfkxx();
            } else if ("sjtc".equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                Long declareId = (Long)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                this.dealSjtc(declareId);
            } else if (NOTICEFLAG.equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRow listSelectedRow = billlist.getCurrentSelectedRowInfo();
                Object primaryKey = listSelectedRow.getPrimaryKeyValue();
                Long sbbid = (Long)primaryKey;
                this.openNotice(sbbid);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tcvat_nsrxx");
        DynamicObject org = object.getDynamicObject("org");
        if ("skssqq".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            try {
                DeclarePageOpenHelper.linkDeclarePageByPkId((IFormView)this.getView(), (Object)object.getLong("id"));
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7533\u62a5\u8868\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u8df3\u8f6c\u67e5\u770b\uff0c\u8bf7\u5230\u4e1a\u52a1\u6240\u5728\u5e94\u7528\u6253\u5f00\u3002", (String)"TaxTsateDeclareList2Plugin_29", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            }
        } else if ("org_name".equals(args.getHyperLinkClickEvent().getFieldName())) {
            List orgList;
            args.setCancel(true);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"tsate_declare_config", (String)"47150e89000000ac");
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && !(orgList = hasPermOrgResult.getHasPermOrgs()).contains(org.getLong("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6761\u76ee\u7ec4\u7ec7\u65e0\u76ee\u6807\u83dc\u5355\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxTsateDeclareList2Plugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_declare_config", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id"))});
            if (obj != null) {
                this.showTargetForm(obj.getLong("id"), "tsate_declare_config", null, null);
            }
        } else if ("declarestatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            DynamicObject obs = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcvat_nsrxx");
            if (obs != null) {
                DynamicObjectCollection objs = QueryServiceHelper.query((String)"tsate_declare_record", (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)obs.getString("id")).and("executestatus", "=", (Object)"3")}, (String)"createtime desc");
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("channel", this.getPageCache().get("current_channel"));
                    customParams.put("nsrsbh", obs.getString("nsrsbh"));
                    this.showTargetForm(((DynamicObject)objs.get(0)).getLong("id"), "tsate_msg_yjbs", null, customParams, false);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4efb\u52a1\u63d0\u793a\u4fe1\u606f", (String)"TaxTsateDeclareList2Plugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("attachmentcount".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            long userId = Long.parseLong(RequestContext.get().getUserId());
            Long orgId = org.getLong("id");
            String appId = AppMetadataCache.getAppInfo((String)"tsate").getId();
            int i = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appId, (String)"tsate_declare_query_list", (String)"1ZN3QJWK9QBE");
            if (i != 1) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7\u201c%1$s\u201d\u7684\u67e5\u770b\u9644\u4ef6\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxTsateDeclareList2Plugin_4", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name")));
                return;
            }
            String caption = ResManager.loadKDString((String)"\u9644\u4ef6\u7ba1\u7406", (String)"TaxTsateDeclareList2Plugin_5", (String)"taxc-tsate-formplugin", (Object[])new Object[0]);
            this.showTargetForm((Long)currentSelectedRowInfo.getPrimaryKeyValue(), "tsate_declare_query_list", caption, null);
        } else if ("paystatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            DynamicObjectCollection objs;
            args.setCancel(true);
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            DynamicObject obs = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcvat_nsrxx");
            if (obs != null && ("payfailed".equals(obs.get("paystatus")) || "yypayfailed".equals(obs.get("paystatus"))) && !CollectionUtils.isEmpty((Collection)(objs = QueryServiceHelper.query((String)"tsate_declare_record", (String)"id", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)obs.getString("id")).and("executestatus", "=", (Object)"3")}, (String)"createtime desc")))) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("channel", this.getPageCache().get("current_channel"));
                customParams.put("nsrsbh", obs.getString("nsrsbh"));
                this.showTargetForm(((DynamicObject)objs.get(0)).getLong("id"), "tsate_msg_yjbs", null, customParams);
            }
        } else if (RISK_CONTENT.equals(args.getFieldName())) {
            args.setCancel(true);
            DeclareUtils.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (IFormView)this.getView());
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        BillList billList = (BillList)this.getControl("billlistap");
        PageRowCacheUtils.clearPageRowcache((String)this.getView().getPageId(), (String)"billlistap");
        IListModel model = billList.getListModel();
        model.setFieldCotnrolRules(billList.getFieldControlRules());
        DynamicObjectCollection dyns = e.getPageData();
        if (dyns.size() > 1500) {
            return;
        }
        ArrayList<Long> idsLong = new ArrayList<Long>(50);
        ArrayList<String> idsStr = new ArrayList<String>(50);
        for (DynamicObject dyn : dyns) {
            Long id = dyn.getLong("id");
            idsLong.add(id);
            idsStr.add(id + "");
        }
        int size3 = this.cacheNoticeFlag(idsLong);
        int size1 = this.cacheZwySpecialDialog(idsStr);
        int size2 = this.cacheDialogStatus(idsLong);
        LOGGER.info("cache size: zwy dialog: {},common dialog: {},noticsflag: {}", new Object[]{size1, size2, size3});
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        String declarestatus = data.getString("declarestatus");
        String paystatus = data.getString("paystatus");
        ArrayList<String> nolinks = new ArrayList<String>(12);
        if (!StringUtils.equals((CharSequence)"declarefailed", (CharSequence)declarestatus)) {
            nolinks.add("declarestatus");
        }
        if (!StringUtils.equals((CharSequence)"payfailed", (CharSequence)paystatus) && !StringUtils.equals((CharSequence)"yypayfailed", (CharSequence)paystatus)) {
            nolinks.add("paystatus");
        }
        if (nolinks.size() > 0) {
            e.setNoLinkKey(nolinks);
        }
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String type = data.getString("type");
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)type);
        if ("taxtype".equals(columnDesc.getKey())) {
            if (type != null) {
                if (type.startsWith("zzs")) {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxTsateDeclareList2Plugin_6", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                } else if (type.startsWith("qysds")) {
                    e.setFormatValue((Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u6240\u5f97\u7a0e", (String)"TaxTsateDeclareList2Plugin_7", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                } else {
                    e.setFormatValue((Object)(declareType != null ? declareType.getName() : ""));
                }
            }
        } else if ("type".equals(columnDesc.getKey())) {
            e.setFormatValue((Object)(declareType != null ? declareType.getName() : ""));
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        } else if ("attachmentcount".equals(columnDesc.getKey())) {
            String id = data.getString("id");
            QFilter[] filters = new QFilter[]{new QFilter("FBillType", "=", (Object)"tsate_declare_query_list"), new QFilter("FInterID", "=", (Object)id), new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel")};
            int count = ORM.create().count(((Object)((Object)this)).getClass().getName(), "bos_attachment", "id", filters);
            e.setFormatValue((Object)count);
        } else if ("sjfk".equals(columnDesc.getKey())) {
            String sbbId = data.getString("id");
            List operationColItems = (List)e.getFormatValue();
            if (this.ifCacheExistZwySpecialDialog(sbbId)) {
                QFilter[] filters = new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)};
                DynamicObject[] signInfoData = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)MetadataUtil.getAllFieldString((String)"tsate_sign_info"), (QFilter[])filters, (String)"modifytime desc");
                if (null != signInfoData && signInfoData.length > 0) {
                    if (EmptyCheckUtils.isEmpty((Object)signInfoData[0].getString("sjfkxx_tag"))) {
                        ((OperationColItem)operationColItems.get(0)).setVisible(false);
                    } else {
                        ((OperationColItem)operationColItems.get(0)).setForeColor("#2b87f3");
                        if ("declared".equals(declarestatus)) {
                            ((OperationColItem)operationColItems.get(0)).setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b", (String)"TaxTsateDeclareList2Plugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
                        } else {
                            ((OperationColItem)operationColItems.get(0)).setOperationName(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406", (String)"TaxTsateDeclareList2Plugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
                        }
                    }
                }
            } else {
                ((OperationColItem)operationColItems.get(0)).setVisible(false);
            }
            Long declareId = Long.parseLong(sbbId);
            ((OperationColItem)operationColItems.get(1)).setVisible(this.ifCacheExistDialogStatus(declareId) && !"declared".equals(declarestatus));
        } else if (RISK_CONTENT.equals(columnDesc.getKey())) {
            if ("normal".equals(e.getFormatValue())) {
                e.getNoLinkKey().add(RISK_CONTENT);
            }
        } else if ("noticeflag".equals(columnDesc.getKey())) {
            boolean showflag = this.getNoticeFlag(data.getLong("id"));
            List operationColItems = (List)e.getFormatValue();
            ((OperationColItem)operationColItems.get(0)).setVisible(showflag);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (closedCallBackEvent.getActionId().equals(IMPORT)) {
            billList.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
        } else if (closedCallBackEvent.getActionId().equals(CLOSECALLBACK_DIALOG) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            billList.refresh();
            return;
        }
        billList.refresh();
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    private void refreshStatus() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (cacheQFilterMap.get(this.getPageCache().getPageId()) != null) {
            qFilters.addAll((List)cacheQFilterMap.get(this.getPageCache().getPageId()));
        }
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        qFilters.add(new QFilter("declaretype", "=", (Object)"1").or(new QFilter("paytype", "=", (Object)"1")).or(new QFilter("paytype", "=", (Object)"2")));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            List pkIds = Arrays.asList(dynamicObjects).stream().map(o -> o.getString("id")).collect(Collectors.toList());
            DynamicObjectCollection records = QueryServiceHelper.query((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{new QFilter("sbbid", "in", pkIds).and(new QFilter("tasktype.number", "in", Arrays.asList("ZLSB", "ZLJK", "YYJK"))).and(new QFilter("executestatus", "=", (Object)"1"))});
            if (!CollectionUtils.isEmpty((Collection)records)) {
                Map recordMap = records.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("sbbid"))).collect(Collectors.toMap(a -> a.getString("sbbid"), Function.identity(), (key1, key2) -> key2));
                TsateCommonConfig config = TsateCommonConfig.getInstance();
                for (DynamicObject mainObj : dynamicObjects) {
                    DynamicObject tysbbDeclare;
                    DynamicObject recordObj = (DynamicObject)recordMap.get(mainObj.getString("id"));
                    if (recordObj == null) continue;
                    JSONObject customMap = new JSONObject();
                    customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
                    customMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
                    customMap.put("isQuery", true);
                    customMap.put("businessId", mainObj.getString("id"));
                    Long orgId = mainObj.getLong(FILTER_ORG_KEY);
                    String declareType = mainObj.getString("type");
                    SupplierEnum supplier = config.getSupplier(orgId, DeclareTypeEnum.valueOfCode((String)declareType));
                    if (supplier == null) continue;
                    String sbStatus = mainObj.getString("declarestatus");
                    String kkStatus = mainObj.getString("paystatus");
                    if (("qtsf_tysbb".equals(mainObj.getString("type")) || "qtsf_fsstysbb".equals(mainObj.getString("type"))) && SupplierEnum.SZYH == supplier && (tysbbDeclare = this.dealTysbb(mainObj)) != null) {
                        customMap.put("relationid", tysbbDeclare.getLong("id"));
                    }
                    try {
                        if (StringUtils.equals((CharSequence)sbStatus, (CharSequence)"declared") && StringUtils.equals((CharSequence)kkStatus, (CharSequence)"unpaid") && (SupplierEnum.CLOUDCC == supplier || SupplierEnum.SZYH == supplier)) {
                            customMap.put("key", ExecuteTypeEnums.ZLJK.getKey());
                            customMap.put("recordid", recordObj.getLong("id"));
                            this.sendMessage((Map<String, Object>)customMap);
                            continue;
                        }
                        String executeType = recordObj.getString("executetype");
                        customMap.put("recordid", recordObj.getLong("id"));
                        customMap.put("key", ExecuteTypeEnums.getKeyByExecuteType((String)executeType));
                        this.sendMessage((Map<String, Object>)customMap);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void sendMessage(Map<String, Object> map) {
        if (map != null && map.containsKey("flag")) {
            if (map.get("flag").toString().startsWith("syn_user")) {
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"UserMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
            } else if (map.get("flag").toString().startsWith("syn_sh")) {
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"ShMessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
            }
        } else if (map != null && ("directdeclare".equals(String.valueOf(map.get("key"))) || "fastpay".equals(String.valueOf(map.get("key"))) || "yyjk".equals(String.valueOf(map.get("key"))) || "undo".equals(String.valueOf(map.get("key"))) || "qzsb".equals(String.valueOf(map.get("key"))))) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DirectDeclarePlugin", (String)"doCustomService", (Object[])new Object[]{map});
        } else {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"MessageSendPlugin", (String)"doCustomService", (Object[])new Object[]{map});
        }
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            if (object != null) {
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
                requestModel.setTemplateType(type);
                requestModel.setId(Long.valueOf(object.getLong("id")));
                requestModel.setSkssqq(DateUtils.format((Date)object.getDate("skssqq")));
                requestModel.setSkssqz(DateUtils.format((Date)object.getDate("skssqz")));
                requestModel.setOperation("read");
                requestModel.setRefresh(Boolean.FALSE);
                customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            }
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void showCcxwsDeclarePage(String type, FormShowParameter param, Map<String, Object> customParams, String billstatus, String declarestatus, String dataType, DynamicObject object) {
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus) || "2".equals(dataType)) {
            if ("2".equals(dataType) && "A".equals(billstatus)) {
                param.setFormId("tcret_declare_import_edit");
            } else {
                param.setFormId(templateEnum.getDeclareShowPage());
            }
            param.setCaption((String)TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType("ccxws");
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate("skssqq")));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate("skssqz")));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.valueOf(false));
            requestModel.addBusinessValue("declaremonth", (String)customParams.get("skssqq"));
            requestModel.addBusinessValue("maindataid", customParams.get("maindataid").toString());
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void showTargetForm(Long pkId, String formId, String caption, Map<String, Object> customParams) {
        this.showTargetForm(pkId, formId, caption, customParams, true);
    }

    private void showTargetForm(Long pkId, String formId, String caption, Map<String, Object> customParams, boolean callback) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(formId);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        if (callback) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "commonclose");
            showParameter.setCloseCallBack(closeCallBack);
        }
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)pkId);
        if (customParams != null) {
            showParameter.setCustomParams(customParams);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private String getOrgField() {
        if (this.orgField == null) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"tsate_declare_query_list");
            DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
            for (IDataEntityProperty property : mainPros) {
                BasedataProp decProp;
                if (!(property instanceof BasedataProp) || !"bos_org".equals((decProp = (BasedataProp)property).getBaseEntityId())) continue;
                this.orgField = decProp.getName();
                break;
            }
        }
        return this.orgField;
    }

    protected void showTip(String title, List<String> details) {
        if (details == null) {
            details = Collections.EMPTY_LIST;
        }
        if (details.size() == 1) {
            this.getView().showErrorNotification((String)details.get(0));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(true);
            parameters.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"TaxTsateDeclareList2Plugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            parameters.setCustomParam("operateName", (Object)"");
            parameters.setCustomParam("title", (Object)title);
            parameters.setCustomParam("errorMsg", (Object)details);
            this.getView().showForm(parameters);
        }
    }

    private List<Long> getOrgListHasPermission() {
        DynamicObjectCollection col;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgs != null && !hasPermOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)(col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false)))) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    private boolean ifHasAllPermission() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        return hasPermOrgs.hasAllOrgPerm();
    }

    private List<String> getTemplateTypeList() {
        Set set = TsateChannelBusiness.getAllDeclareTYpeFromBaseConfig();
        ArrayList<String> list = new ArrayList<String>(20);
        list.addAll(set);
        return list;
    }

    private static void updateSignInfo(String sbbId) {
        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbId);
        DeleteServiceHelper.delete((String)"tsate_sign_info", (QFilter[])new QFilter[]{qFilter});
    }

    private String getReportType(String taxlimit) {
        if ("season".equals(taxlimit)) {
            return "ajsb";
        }
        if ("year".equals(taxlimit)) {
            return "ansb";
        }
        if ("month".equals(taxlimit)) {
            return "aysb";
        }
        return " ";
    }

    private void manualDeclare() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = list.getPrimaryKeyValues();
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
            ArrayList<String> erros = new ArrayList<String>(8);
            for (DynamicObject declare : declares) {
                StringBuilder erro = new StringBuilder();
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String typeName = DeclareTypeEnum.getNameByCode((String)type);
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_12", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u672a\u7533\u62a5\u201d\u6216\u201c\u7533\u62a5\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u786e\u8ba4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_13", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                if (BigDecimal.ZERO.compareTo(bqybtse) == 0) {
                    declare.set("paystatus", (Object)"nopay");
                }
                declare.set("declarestatus", (Object)"declared");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("declaretype", (Object)"0");
                declare.set("sbrq", (Object)new Date());
                declare.set("declarer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (erros.size() == 0) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxTsateDeclareList2Plugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                billlist.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
                billlist.refresh();
            } else {
                this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), erros);
            }
        }
    }

    private void cancelDeclare() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = list.getPrimaryKeyValues();
        DynamicObject[] declares = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcvat_nsrxx"));
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
            ArrayList<String> erros = new ArrayList<String>(8);
            for (DynamicObject declare : declares) {
                boolean deferpayapply;
                StringBuilder erro = new StringBuilder(8);
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String declareType = declare.getString("declaretype");
                String typeName = DeclareTypeEnum.getNameByCode((String)type);
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_16", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (type.indexOf("zzs") != -1) {
                    DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
                    deferpayapply = entryentity.stream().anyMatch(e -> e.getBoolean("deferpayapply1"));
                } else {
                    deferpayapply = declare.getBoolean("deferpayapply");
                }
                if (!"payfailed".equals(declare.getString("paystatus")) && !"unpaid".equals(declare.getString("paystatus")) && !"nopay".equals(declare.getString("paystatus")) && !"yypayfailed".equals(declare.getString("paystatus")) && !StringUtils.isBlank((CharSequence)declare.getString("paystatus")) || deferpayapply) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u672a\u7f34\u6b3e\u201d\u3001\u201c\u7f34\u6b3e\u5931\u8d25\u201d\u3001\u201c\u65e0\u9700\u7f34\u6b3e\u201d\u3001\u201c\u9884\u7ea6\u5931\u8d25\u201d\u6216\u201c\u672a\u7533\u8bf7\u7f13\u7f34\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_17", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (!"declared".equals(declare.getString("declarestatus"))) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_18", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (!"0".equals(declareType)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u7533\u62a5\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_19", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                declare.set("declarestatus", (Object)"editing");
                declare.set("paystatus", (Object)"unpaid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("declaretype", (Object)"");
                declare.set("paytype", (Object)"");
                declare.set("sbrq", null);
                declare.set("paydate", null);
                declare.set("payer", (Object)0L);
                declare.set("declarer", (Object)0L);
                TaxTsateDeclareList2Plugin.updateSignInfo(declare.getString("id"));
                modifyDynamicObjects.add(declare);
            }
            if (erros.size() == 0) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelDeclare", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxTsateDeclareList2Plugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                billlist.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
                billlist.refresh();
            } else {
                this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), erros);
            }
        }
    }

    private void manualPay() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = list.getPrimaryKeyValues();
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
            ArrayList<String> erros = new ArrayList<String>(8);
            for (DynamicObject declare : declares) {
                StringBuilder erro = new StringBuilder();
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String typeName = DeclareTypeEnum.getNameByCode((String)type);
                String payStatus = declare.getString("paystatus");
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_20", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (!"declared".equals(declare.getString("declarestatus"))) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u786e\u8ba4\u7f34\u6b3e\uff1a%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_21", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                if (!("payfailed".equals(payStatus) || "unpaid".equals(payStatus) || "yypayfailed".equals(declare.getString("paystatus")) || StringUtils.isBlank((CharSequence)declare.getString("paystatus")))) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u672a\u7f34\u6b3e\u201d\u3001\u201c\u7f34\u6b3e\u5931\u8d25\u201d\u6216\u201c\u9884\u7ea6\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u786e\u8ba4\u7f34\u6b3e\uff1a%1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_22", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    erros.add(erro.toString());
                    continue;
                }
                declare.set("paystatus", (Object)"paid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"0");
                declare.set("paydate", (Object)new Date());
                declare.set("payer", (Object)RequestContext.get().getUserId());
                modifyDynamicObjects.add(declare);
            }
            if (erros.size() == 0) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualPay", (Object[])new Object[]{sbbIds});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxTsateDeclareList2Plugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                billlist.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
                billlist.refresh();
            } else {
                this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), erros);
            }
        }
    }

    private void cancelPay() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object[] pkIds = list.getPrimaryKeyValues();
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        ArrayList<String> errors = new ArrayList<String>(8);
        if (declares != null && declares.length > 0) {
            ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>();
            for (DynamicObject declare : declares) {
                StringBuilder erro = new StringBuilder();
                DynamicObject org = declare.getDynamicObject("org");
                String type = declare.getString("type");
                String typeName = DeclareTypeEnum.getNameByCode((String)type);
                String payType = declare.getString("paytype");
                String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
                String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
                String billStatus = declare.getString("billstatus");
                if (!"C".equals(billStatus)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_23", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    errors.add(erro.toString());
                    continue;
                }
                if (!"paid".equals(declare.getString("paystatus"))) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u7f34\u6b3e\u6210\u529f\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_24", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    errors.add(erro.toString());
                    continue;
                }
                if (!"0".equals(payType)) {
                    erro.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u201c\u624b\u5de5\u7f34\u6b3e\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"TaxTsateDeclareList2Plugin_25", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                    errors.add(erro.toString());
                    continue;
                }
                declare.set("paystatus", (Object)"unpaid");
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"");
                declare.set("paydate", null);
                declare.set("payer", (Object)0L);
                modifyDynamicObjects.add(declare);
            }
            if (errors.size() == 0) {
                List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{sbbIds});
                SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxTsateDeclareList2Plugin_14", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                billlist.getFilterParameter().setFilter(filterCache.get(QFILTER_CACHE_PREFIX + this.getTemplateTypeList()));
                billlist.refresh();
            } else {
                this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_15", (String)"taxc-tsate-formplugin", (Object[])new Object[0]), errors);
            }
        }
    }

    private void dealSjfkxx() {
        Map returnMap;
        String sjfkxx;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55\u3002", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object sbbId = billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject[] fkxx = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)MetadataUtil.getAllFieldString((String)"tsate_sign_info"), (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)String.valueOf(sbbId))});
        if (fkxx != null && fkxx.length > 0 && EmptyCheckUtils.isNotEmpty((Object)(sjfkxx = fkxx[0].getString("sjfkxx_tag"))) && (returnMap = (Map)JsonUtil.fromJson((String)sjfkxx, Map.class)) != null) {
            Map taxRefundRsp = (Map)returnMap.get("taxRefundRsp");
            String taxRefundUrl = String.valueOf(taxRefundRsp.get("taxRefundUrl"));
            this.getView().openUrl(taxRefundUrl);
        }
    }

    private void dealSjtc(Long declareId) {
        Map statusMap = TasteDeclarePopupBusiness.querySbPopupStatus(Collections.singletonList(declareId));
        PoppupStatusEnum status = (PoppupStatusEnum)statusMap.get(declareId);
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        if (PoppupStatusEnum.INIT == status) {
            param.setStatus(OperationStatus.ADDNEW);
        } else if (PoppupStatusEnum.SELECTED == status || PoppupStatusEnum.USED == status) {
            param.setStatus(OperationStatus.EDIT);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7533\u62a5\u8868\u4e0d\u5b58\u5728\u5f39\u7a97\u8bbe\u7f6e\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"TaxTsateDeclareList2Plugin_26", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_DIALOG);
        param.setCloseCallBack(closeCallBack);
        param.setFormId("tsate_dynamic_popup_qxy");
        param.getOpenStyle().setShowType(ShowType.Modal);
        customParams.put("sbbid", declareId.toString());
        param.setCustomParams(customParams);
        this.getView().showForm(param);
    }

    private DynamicObject dealTysbb(DynamicObject declare) {
        try {
            if (declare != null) {
                DynamicObject channelObj;
                DynamicObject org = declare.getDynamicObject("org");
                Date skssqq = declare.getDate("skssqq");
                Date skssqz = declare.getDate("skssqz");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
                QFilter declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0");
                QFilter typeFilter = "qtsf_fsstysbb".equals(declare.getString("type")) ? new QFilter("type", "=", (Object)"qtsf_tysbb") : new QFilter("type", "=", (Object)"qtsf_fsstysbb");
                QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
                QFilter delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared");
                DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{qFilter, typeFilter, skssqqzFilter, declareTypeQfilter, billstatusFilter, delcareStatusQfilter});
                if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                    String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                    if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                        return tysbDeclare;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5408\u5e76\u5904\u7406\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_27", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    private void openNotice(Long sbbid) {
        String log;
        DynamicObject declareMain = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"declarestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sbbid)});
        DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareMain.getString("declarestatus"));
        DynamicObject obj = TsateDeclareRecordBusiness.getRecordBySbbid((Long)sbbid, (DeclareStatusEnum)declareStatus);
        if (obj != null && kd.bos.util.StringUtils.isNotEmpty((String)(log = obj.getString("deallog")))) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("channel", this.getPageCache().get("current_channel"));
            customParams.put("nsrsbh", "");
            this.showTargetForm(obj.getLong("id"), "tsate_msg_yjbs", null, customParams, false);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4efb\u52a1\u63d0\u793a\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"TaxTsateDeclareList2Plugin_28", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
    }

    private void btnSetting(List<Long> orgIds) {
        HashMap<String, Boolean> btnConfig = new HashMap<String, Boolean>(8);
        btnConfig.put(BTN_CANCELYYJK, false);
        btnConfig.put(BTN_YYJK, false);
        btnConfig.put(BTN_REFRESH_ZWY, false);
        btnConfig.put(BTN_SZYH, false);
        btnConfig.put(BTN_UNDO, false);
        TsateCommonConfig cfg = TsateCommonConfig.getInstance();
        Map orgTopTaxOfficeIds = cfg.getTopTaxofficeId(orgIds);
        for (Map.Entry item : orgTopTaxOfficeIds.entrySet()) {
            Long orgId = (Long)item.getKey();
            Long topTaxOfficeId = (Long)item.getValue();
            Set suppliers = cfg.getAllSupplier(orgId);
            if (TAXOFFICE_ID_ZHEJIANG.equals(topTaxOfficeId) && suppliers.contains(SupplierEnum.ZWY)) {
                btnConfig.put(BTN_CANCELYYJK, true);
                btnConfig.put(BTN_YYJK, true);
            }
            if (!((Boolean)btnConfig.get(BTN_REFRESH_ZWY)).booleanValue()) {
                Set syncStatusSupports = new SyncCancelStatusServiceImpl().getSupportSuppliers();
                for (SupplierEnum itemSupplier : suppliers) {
                    if (!syncStatusSupports.contains(itemSupplier)) continue;
                    btnConfig.put(BTN_REFRESH_ZWY, true);
                    break;
                }
            }
            if (suppliers.contains(SupplierEnum.SZYH) || suppliers.contains(SupplierEnum.CLOUDCC)) {
                btnConfig.put(BTN_SZYH, true);
            }
            if (!suppliers.contains(SupplierEnum.YZF) && !suppliers.contains(SupplierEnum.GXSJ)) continue;
            btnConfig.put(BTN_UNDO, true);
        }
        HashSet hidden = new HashSet(8);
        HashSet show = new HashSet(8);
        for (Map.Entry entry : btnConfig.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) {
                show.add(entry.getKey());
                continue;
            }
            hidden.add(entry.getKey());
        }
        if (hidden.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(false), hidden.toArray(new String[0]));
        }
        if (show.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), show.toArray(new String[0]));
        }
    }

    private int cacheDialogStatus(List<Long> declareIds) {
        StringBuilder sb = new StringBuilder("|");
        Map dialogDeclareStatus = TasteDeclarePopupBusiness.querySbPopupStatus(declareIds);
        for (Map.Entry kv : dialogDeclareStatus.entrySet()) {
            Long sbbid = (Long)kv.getKey();
            PoppupStatusEnum status = (PoppupStatusEnum)kv.getValue();
            if (PoppupStatusEnum.INIT != status && PoppupStatusEnum.SELECTED != status) continue;
            sb.append(sbbid).append("|");
        }
        this.getPageCache().put("dialogstatus", sb.toString());
        return dialogDeclareStatus.size();
    }

    private boolean ifCacheExistDialogStatus(Long declareId) {
        String str = this.getPageCache().get("dialogstatus");
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        String compare = "|" + declareId + "|";
        return str.contains(compare);
    }

    private int cacheZwySpecialDialog(List<String> declareIds) {
        QFilter[] filters = new QFilter[]{new QFilter("sbbid", "in", declareIds)};
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)MetadataUtil.getAllFieldString((String)"tsate_sign_info"), (QFilter[])filters, (String)"modifytime desc");
        StringBuilder sb = new StringBuilder("|");
        for (DynamicObject dyn : dyns) {
            String sbbid = dyn.getString("sbbid");
            sb.append(sbbid).append("|");
        }
        this.getPageCache().put("zwydialogstatus", sb.toString());
        return dyns.length;
    }

    private boolean ifCacheExistZwySpecialDialog(String declareId) {
        String sbbids = this.getPageCache().get("zwydialogstatus");
        if (StringUtil.isBlank((CharSequence)sbbids)) {
            return false;
        }
        String compare = "|" + declareId + "|";
        return sbbids.contains(compare);
    }

    private int cacheNoticeFlag(List<Long> declareList) {
        List declareIds = declareList.stream().map(id -> id + "").collect(Collectors.toList());
        QFilter[] filters0 = new QFilter[]{new QFilter("id", "in", declareList)};
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tsate_declare_query_list", (String)"id,type,skssqq,skssqz,bqybtse,billno,billstatus,creator,auditor,modifier,auditdate,createtime,modifytime,ewblxh,nsrsbh,templateid,sshymc,fddbrxm,zcdz,scjydz,khyh,yhzh,registertype,phonenum,yssr,nsrmc,declarestatus,datatype,taxlimit,org,declaretype,paytype,sbrq,paydate,paystatus,attachmentcount,fjss,payer,declarer,taxauthority,riskstatus", (QFilter[])filters0);
        QFilter filter1 = new QFilter("sbbid", "in", declareIds);
        filter1.and("tasktype", "=", (Object)ExecuteTypeEnums.ZLSB.getId());
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,skssqq,skssqz,executetype,executestatus,deallog,type,detaillog,channel,sbbid,sbqj,piclog,declarechannel,tasktype,taxtype", (QFilter[])new QFilter[]{filter1});
        HashMap<String, List> recordsMap = new HashMap<String, List>(64);
        for (DynamicObject recordDyn : records) {
            String sbbid = recordDyn.getString("sbbid");
            List declareRecords = recordsMap.computeIfAbsent(sbbid, k -> new ArrayList(8));
            declareRecords.add(recordDyn);
        }
        HashMap<Long, Boolean> declareNoticeFlag = new HashMap<Long, Boolean>(64);
        for (DynamicObject declareDyn : declares) {
            List declareRecords;
            Long declareId = declareDyn.getLong("id");
            DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareDyn.getString("declarestatus"));
            ExecuteStatusEnum executeStatus = TsateDeclareRecordBusiness.getExecuteStatusByDeclareStatus((DeclareStatusEnum)declareStatus);
            if (executeStatus == null || (declareRecords = (List)recordsMap.get(declareId + "")) == null) continue;
            DynamicObject selectRecord = null;
            for (DynamicObject filterDeclareDyn : declareRecords) {
                ExecuteTypeEnums executeType = ExecuteTypeEnums.valuesOfId((Long)filterDeclareDyn.getLong("tasktype.id"));
                if (ExecuteTypeEnums.ZLSB != executeType) continue;
                String recordStatus = filterDeclareDyn.getString("executestatus");
                Date createTime = filterDeclareDyn.getDate("createtime");
                if (!executeStatus.getCode().equals(recordStatus)) continue;
                if (selectRecord == null) {
                    selectRecord = filterDeclareDyn;
                    continue;
                }
                Date selectCreateTime = selectRecord.getDate("createtime");
                if (!selectCreateTime.before(createTime)) continue;
                selectRecord = filterDeclareDyn;
            }
            if (selectRecord != null) {
                String log = selectRecord.getString("deallog");
                declareNoticeFlag.put(declareId, StringUtil.isNotEmpty((CharSequence)log));
                continue;
            }
            declareNoticeFlag.put(declareId, false);
        }
        StringBuilder sb = new StringBuilder("|");
        for (Map.Entry item : declareNoticeFlag.entrySet()) {
            if (!((Boolean)item.getValue()).booleanValue()) continue;
            sb.append(item.getKey()).append("|");
        }
        this.getPageCache().put("noticeflag", sb.toString());
        return declareList.size();
    }

    private boolean getNoticeFlag(Long declareId) {
        String cacheIds = this.getPageCache().get("noticeflag");
        if (StringUtil.isBlank((CharSequence)cacheIds)) {
            return false;
        }
        String key = "|" + declareId + "|";
        return cacheIds.contains(key);
    }
}

