/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.formplugin.declare;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IListModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.TsateDeclareConfigBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.TsateSignInfoBusiness;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.business.declare.SyncCancelStatusServiceImpl;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.taxdialog.TasteDeclarePopupBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.task.TaskConstant;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.common.util.PageShowCommon;
import kd.taxc.tsate.common.util.PermissionUtils;
import kd.taxc.tsate.common.util.TreeUtils;
import kd.taxc.tsate.formplugin.utils.JobUtils;

public class TsateDeclareListPlugin
extends TsateBaseDeclarePlugin
implements BeforeFilterF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(TsateDeclareListPlugin.class);
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String TEMPLATE_TYPE_NAME = "templatetype.name";
    private static final String REFRESH = "refresh";
    private static final String NOTICEFLAG = "notice";
    private String orgField = null;
    private static final String FILTER_ORG_KEY = "org.id";
    private static final String BTN_YYJK = "btn_yyjk";
    private static final String BTN_CANCELYYJK = "btn_cancelyyjk";
    private static final String BTN_UNDO = "btn_undo";
    private static final String BTN_REFRESH_ZWY = "btn_refreshstatus";
    private static final String BTN_SZYH = "btn_szyhplatform";
    private static final Long TAXOFFICE_ID_ZHEJIANG = 1010868748401298555L;
    private static final String CLOSECALLBACK_DIALOG = "closeCallback_dialog";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.btnSetting(this.getOrgFromFilter());
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap", "sjfk"});
    }

    public void setFilter(SetFilterEvent e) {
        this.initFilterOrg(e);
        this.initFilterSkssq(e);
        this.initFilterType(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (REFRESH.equals(operateKey)) {
            this.refreshStatus(list);
        }
    }

    private List<QFilter> existFilter(List<QFilter> filters, String key) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        for (QFilter eQFilter : filters) {
            for (QFilter filter : eQFilter.recombine()) {
                if (!filter.getProperty().equals(key)) continue;
                list.add(filter);
            }
        }
        return list;
    }

    private QFilter initFilterType(SetFilterEvent e) {
        QFilter typeFilter;
        List eventFilters = e.getQFilters();
        List<QFilter> filters = this.existFilter(eventFilters, "templatetype.id");
        if (CollectionUtils.isEmpty(filters)) {
            typeFilter = new QFilter("templatetype.id", "in", this.getTemplateTypeList());
            e.getQFilters().add(typeFilter);
        } else {
            typeFilter = filters.get(0);
        }
        return typeFilter;
    }

    private List<QFilter> initFilterSkssq(SetFilterEvent e) {
        ArrayList<QFilter> finalFilters = new ArrayList<QFilter>();
        List<QFilter> filters = this.existFilter(e.getQFilters(), "skssqq");
        for (QFilter filter : filters) {
            if ("<".equals(filter.getCP())) {
                e.getQFilters().remove(filter);
                QFilter skssqzFilter = new QFilter("skssqz", filter.getCP(), filter.getValue());
                e.getQFilters().add(skssqzFilter);
                finalFilters.add(skssqzFilter);
                continue;
            }
            finalFilters.add(filter);
        }
        return finalFilters;
    }

    private QFilter initFilterOrg(SetFilterEvent e) {
        List<QFilter> filters = this.existFilter(e.getQFilters(), FILTER_ORG_KEY);
        if (filters.size() != 0) {
            return filters.get(0);
        }
        String customfilterSer = this.getPageCache().get("customfilter");
        QFilter orgFilter = null;
        if (customfilterSer != null) {
            List customfilter = (List)SerializationUtils.fromJsonString((String)customfilterSer, List.class);
            for (Map customFiter : customfilter) {
                List orgs;
                List fieldNames = (List)customFiter.get("FieldName");
                if (CollectionUtils.isEmpty((Collection)fieldNames) || !fieldNames.get(0).toString().startsWith(this.orgField + ".")) continue;
                List orgIds = (List)customFiter.get("Value");
                if (CollectionUtils.isEmpty((Collection)orgIds) || CollectionUtils.isEmpty(orgs = orgIds.stream().filter(o -> StringUtils.isNotBlank((Object)o)).map(o -> Long.parseLong(String.valueOf(o))).collect(Collectors.toList()))) break;
                orgFilter = new QFilter(this.orgField, "in", orgs);
                break;
            }
        }
        if (orgFilter == null) {
            if (this.ifHasAllPermission()) {
                return null;
            }
            List<Long> orgIds = this.getOrgListHasPermission();
            orgFilter = new QFilter(FILTER_ORG_KEY, "in", orgIds);
        }
        return orgFilter;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn = (CommonFilterColumn)args.getFilterColumn(TEMPLATE_TYPE_NAME);
        ControlFilters controlFilters = ((IListView)this.getView()).getControlFilters();
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (controlFilters == null) {
            orgIdList.add(RequestContext.get().getOrgId());
        } else {
            List orgIds = controlFilters.getFilter(FILTER_ORG_KEY);
            if (CollectionUtils.isEmpty((Collection)orgIds) || orgIds.get(0).equals("")) {
                if (this.ifHasAllPermission()) {
                    List<ComboItem> combos = this.getDeclareTypeComboItems(this.getTemplateTypeList());
                    typeColumn.setComboItems(combos);
                    return;
                }
                orgIdList.addAll(this.getOrgListHasPermission());
            } else {
                for (Object o : orgIds) {
                    orgIdList.add(Long.parseLong(o.toString()));
                }
            }
        }
        Set declareTypes = TsateChannelBusiness.getOrgDeclareTypeId(orgIdList);
        List<ComboItem> combos = this.getDeclareTypeComboItems(declareTypes);
        typeColumn.setComboItems(combos);
    }

    private List<ComboItem> getDeclareTypeComboItems(Collection<String> declareTypeCodes) {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(declareTypeCodes.size());
        for (String code : declareTypeCodes) {
            ComboItem item = new ComboItem();
            item.setValue(code);
            DeclareTypeEnum type = DeclareTypeEnum.valueOfId((String)code);
            if (type == null) continue;
            item.setCaption(new LocaleString(type.getName()));
            combos.add(item);
        }
        return combos;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public List<QFilter> getQFilters() {
                List qFilters = super.getQFilters();
                qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
                super.setQFilters(qFilters);
                return qFilters;
            }
        });
    }

    public void itemClick(ItemClickEvent evt) {
        if (VIEWFLOWCHART.equals(evt.getItemKey())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55", (String)"TaxTsateDeclareList2Plugin_0", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c", (String)"TaxTsateDeclareList2Plugin_1", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wf_viewflowchart");
            showParameter.setClientParam("billId", (Object)list.get(0).getPrimaryKeyValue().toString());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if ("sbpz".equals(evt.getItemKey())) {
            PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)"tsate_sbpz_admin", (IFormView)this.getView(), null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if ("sjfk".equals(args.getOperateKey())) {
                this.dealSjfkxx();
            } else if ("sjtc".equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                Long declareId = (Long)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                this.dealSjtc(declareId);
            } else if (NOTICEFLAG.equals(args.getOperateKey())) {
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRow listSelectedRow = billlist.getCurrentSelectedRowInfo();
                Object primaryKey = listSelectedRow.getPrimaryKeyValue();
                Long sbbid = (Long)primaryKey;
                this.openNotice(sbbid);
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        if ("org_name".equals(args.getHyperLinkClickEvent().getFieldName())) {
            List orgList;
            DynamicObject obs = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)((Long)primaryKeyValue));
            if (obs == null) {
                return;
            }
            DynamicObject org = obs.getDynamicObject("org");
            args.setCancel(true);
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"tsate_declare_config", (String)"47150e89000000ac");
            if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && !(orgList = hasPermOrgResult.getHasPermOrgs()).contains(org.getLong("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6761\u76ee\u7ec4\u7ec7\u65e0\u76ee\u6807\u83dc\u5355\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaxTsateDeclareList2Plugin_2", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject obj = TsateDeclareConfigBusiness.getOneConfigIdByOrgId((Long)org.getLong("id"));
            if (obj != null) {
                this.showTargetForm(obj.getLong("id"), "tsate_declare_config", null, null);
            }
        } else if ("declarestatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            DynamicObject obs = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)((Long)primaryKeyValue));
            if (obs != null) {
                DynamicObjectCollection objs = TsateDeclareRecordBusiness.queryBySbbIdExecuteStatusDescByCreateTime((String)obs.getString("id"), (ExecuteStatusEnum)ExecuteStatusEnum.FAIL, (ExecuteTypeEnums)ExecuteTypeEnums.ZLSB);
                if (!CollectionUtils.isEmpty((Collection)objs)) {
                    HashMap<String, Object> customParams = new HashMap<String, Object>();
                    customParams.put("channel", this.getPageCache().get("current_channel"));
                    customParams.put("nsrsbh", obs.getString("nsrsbh"));
                    this.showTargetForm(((DynamicObject)objs.get(0)).getLong("id"), "tsate_msg_yjbs", null, customParams, false);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4efb\u52a1\u63d0\u793a\u4fe1\u606f", (String)"TaxTsateDeclareList2Plugin_3", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
                }
            }
        } else if ("paystatus".equals(args.getHyperLinkClickEvent().getFieldName())) {
            DynamicObjectCollection objs;
            args.setCancel(true);
            DynamicObject obs = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)((Long)primaryKeyValue));
            if (obs != null && ("payfailed".equals(obs.get("paystatus")) || "yypayfailed".equals(obs.get("paystatus"))) && !CollectionUtils.isEmpty((Collection)(objs = TsateDeclareRecordBusiness.queryBySbbIdExecuteStatusDescByCreateTime((String)obs.getString("id"), (ExecuteStatusEnum)ExecuteStatusEnum.FAIL, (ExecuteTypeEnums)ExecuteTypeEnums.ZLJK)))) {
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("channel", this.getPageCache().get("current_channel"));
                customParams.put("nsrsbh", obs.getString("nsrsbh"));
                this.showTargetForm(((DynamicObject)objs.get(0)).getLong("id"), "tsate_msg_yjbs", null, customParams);
            }
        } else if ("riskstatus".equals(args.getFieldName())) {
            args.setCancel(true);
            DeclareUtils.showRiskDialog((String)primaryKeyValue.toString(), (IFormView)this.getView());
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        BillList billList = (BillList)this.getControl("billlistap");
        IListModel model = billList.getListModel();
        model.setFieldCotnrolRules(billList.getFieldControlRules());
        DynamicObjectCollection dyns = e.getPageData();
        if (dyns.size() > 1500) {
            return;
        }
        ArrayList<Long> idsLong = new ArrayList<Long>(50);
        ArrayList<String> idsStr = new ArrayList<String>(50);
        for (DynamicObject dyn : dyns) {
            Long id = dyn.getLong("id");
            idsLong.add(id);
            idsStr.add(id + "");
        }
        int size3 = this.cacheNoticeFlag(idsLong);
        int size1 = this.cacheZwySpecialDialog(idsStr);
        int size2 = this.cacheDialogStatus(idsLong);
        LOGGER.info("cache size: zwy dialog: {},common dialog: {},noticsflag: {}", new Object[]{size1, size2, size3});
    }

    public void packageData(PackageDataEvent e) {
        AbstractColumnDesc columnDesc;
        DynamicObject data = e.getRowData();
        String declarestatus = data.getString("declarestatus");
        String paystatus = data.getString("paystatus");
        ArrayList<String> nolinks = new ArrayList<String>(12);
        if (!StringUtils.equals((CharSequence)"declarefailed", (CharSequence)declarestatus)) {
            nolinks.add("declarestatus");
        }
        if (!StringUtils.equals((CharSequence)"payfailed", (CharSequence)paystatus) && !StringUtils.equals((CharSequence)"yypayfailed", (CharSequence)paystatus)) {
            nolinks.add("paystatus");
        }
        if (nolinks.size() > 0) {
            e.setNoLinkKey(nolinks);
        }
        if ("sjfk".equals((columnDesc = (AbstractColumnDesc)e.getSource()).getKey())) {
            String sbbId = data.getString("id");
            List operationColItems = (List)e.getFormatValue();
            if (this.ifCacheExistZwySpecialDialog(sbbId)) {
                ((OperationColItem)operationColItems.get(0)).setForeColor("#2b87f3");
                if ("declared".equals(declarestatus)) {
                    ((OperationColItem)operationColItems.get(0)).setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b", (String)"TaxTsateDeclareList2Plugin_8", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
                } else {
                    ((OperationColItem)operationColItems.get(0)).setOperationName(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406", (String)"TaxTsateDeclareList2Plugin_9", (String)"taxc-tsate-formplugin", (Object[])new Object[0])));
                }
            } else {
                ((OperationColItem)operationColItems.get(0)).setVisible(false);
            }
            ((OperationColItem)operationColItems.get(1)).setVisible(this.ifCacheExistDialogStatus(Long.parseLong(sbbId)) && !"declared".equals(declarestatus));
        } else if ("riskcontent".equals(columnDesc.getKey())) {
            if ("normal".equals(e.getFormatValue())) {
                e.getNoLinkKey().add("riskcontent");
            }
        } else if ("noticeflag".equals(columnDesc.getKey())) {
            boolean showflag = this.getNoticeFlag(data.getLong("id"));
            List operationColItems = (List)e.getFormatValue();
            ((OperationColItem)operationColItems.get(0)).setVisible(showflag);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (closedCallBackEvent.getActionId().equals(CLOSECALLBACK_DIALOG) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            billList.refresh();
            return;
        }
        billList.refresh();
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent beforeFilterF7SelectEvent) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    private void refreshStatus(ListSelectedRowCollection selectedRows) {
        DynamicObjectCollection records;
        List<Object> selectDeclaredRows = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            Object[] selectPrimaryKeys = selectedRows.getPrimaryKeyValues();
            selectDeclaredRows = Arrays.stream(selectPrimaryKeys).map(o -> (Long)o).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)(records = TsateDeclareRecordBusiness.queryAllRunningRecordByTimeOrSbbid((Long)TaskConstant.TASK_REFRESH_TIMEOUT, (Long)TaskConstant.TASK_REFRESH_BEFORTIMEOUT, Arrays.asList(ExecuteTypeEnums.ZLSB, ExecuteTypeEnums.ZLJK, ExecuteTypeEnums.YYJK), selectDeclaredRows)))) {
            return;
        }
        List runningSbbids = records.stream().map(o -> o.getLong("sbbid")).collect(Collectors.toList());
        List dynamicObjects = DeclarationMainFormBusniess.queryByIdsNotThrowEx(runningSbbids);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return;
        }
        Map recordMap = records.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getString("sbbid"))).collect(Collectors.toMap(a -> a.getString("sbbid"), Function.identity(), (key1, key2) -> key2));
        TsateCommonConfig config = TsateCommonConfig.getInstance();
        for (DynamicObject mainObj : dynamicObjects) {
            DynamicObject tysbbDeclare;
            String declareType;
            DynamicObject recordObj = (DynamicObject)recordMap.get(mainObj.getString("id"));
            if (recordObj == null) continue;
            JSONObject customMap = new JSONObject();
            customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            customMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
            customMap.put("isQuery", true);
            customMap.put("businessId", mainObj.getString("id"));
            Long orgId = mainObj.getLong(FILTER_ORG_KEY);
            SupplierEnum supplier = config.getSupplier(orgId, DeclareTypeEnum.valueOfCode((String)(declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)mainObj))));
            if (supplier == null) continue;
            String sbStatus = mainObj.getString("declarestatus");
            String kkStatus = mainObj.getString("paystatus");
            if (("qtsf_tysbb".equals(declareType) || "qtsf_fsstysbb".equals(declareType)) && SupplierEnum.SZYH == supplier && (tysbbDeclare = this.dealTysbb(mainObj)) != null) {
                customMap.put("relationid", tysbbDeclare.getLong("id"));
            }
            try {
                if (StringUtils.equals((CharSequence)sbStatus, (CharSequence)"declared") && StringUtils.equals((CharSequence)kkStatus, (CharSequence)"unpaid") && (SupplierEnum.CLOUDCC == supplier || SupplierEnum.SZYH == supplier)) {
                    customMap.put("key", ExecuteTypeEnums.ZLJK.getKey());
                    customMap.put("recordid", recordObj.getLong("id"));
                    JobUtils.sendMessage((Map<String, Object>)customMap);
                    continue;
                }
                String executeType = recordObj.getString("executetype");
                customMap.put("recordid", recordObj.getLong("id"));
                customMap.put("key", ExecuteTypeEnums.getKeyByExecuteType((String)executeType));
                JobUtils.sendMessage((Map<String, Object>)customMap);
            }
            catch (Exception e) {}
        }
    }

    private void showTargetForm(Long pkId, String formId, String caption, Map<String, Object> customParams) {
        this.showTargetForm(pkId, formId, caption, customParams, true);
    }

    private void showTargetForm(Long pkId, String formId, String caption, Map<String, Object> customParams, boolean callback) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setFormId(formId);
        if (StringUtils.isNotBlank((CharSequence)caption)) {
            showParameter.setCaption(caption);
        }
        if (callback) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "commonclose");
            showParameter.setCloseCallBack(closeCallBack);
        }
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setPkId((Object)pkId);
        if (customParams != null) {
            showParameter.setCustomParams(customParams);
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected void showTip(String title, List<String> details) {
        if (details == null) {
            details = Collections.EMPTY_LIST;
        }
        if (details.size() == 1) {
            this.getView().showErrorNotification((String)details.get(0));
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(true);
            parameters.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"TaxTsateDeclareList2Plugin_10", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            parameters.setCustomParam("operateName", (Object)"");
            parameters.setCustomParam("title", (Object)title);
            parameters.setCustomParam("errorMsg", (Object)details);
            this.getView().showForm(parameters);
        }
    }

    private List<Long> getOrgListHasPermission() {
        DynamicObjectCollection col;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        if (hasPermOrgs != null && !hasPermOrgs.hasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)(col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)false)))) {
            for (DynamicObject obj : col) {
                orgIds.add(obj.getLong("id"));
            }
        }
        return orgIds;
    }

    private boolean ifHasAllPermission() {
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        return hasPermOrgs.hasAllOrgPerm();
    }

    private List<String> getTemplateTypeList() {
        Set set = TsateChannelBusiness.getAllDeclareTYpeIdFromBaseConfig();
        ArrayList<String> list = new ArrayList<String>(20);
        list.addAll(set);
        return list;
    }

    private void dealSjfkxx() {
        Map returnMap;
        String sjfkxx;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55", (String)"TaxTsateDeclareList2Plugin_11", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        Object sbbId = billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject[] fkxx = TsateSignInfoBusiness.queryBySbbid((String)String.valueOf(sbbId));
        if (fkxx != null && fkxx.length > 0 && EmptyCheckUtils.isNotEmpty((Object)(sjfkxx = fkxx[0].getString("sjfkxx_tag"))) && (returnMap = (Map)JsonUtil.fromJson((String)sjfkxx, Map.class)) != null) {
            Map taxRefundRsp = (Map)returnMap.get("taxRefundRsp");
            String taxRefundUrl = String.valueOf(taxRefundRsp.get("taxRefundUrl"));
            this.getView().openUrl(taxRefundUrl);
        }
    }

    private void dealSjtc(Long declareId) {
        Map statusMap = TasteDeclarePopupBusiness.querySbPopupStatus(Collections.singletonList(declareId));
        PoppupStatusEnum status = (PoppupStatusEnum)statusMap.get(declareId);
        FormShowParameter param = new FormShowParameter();
        HashMap<String, String> customParams = new HashMap<String, String>(8);
        if (PoppupStatusEnum.INIT == status) {
            param.setStatus(OperationStatus.ADDNEW);
        } else if (PoppupStatusEnum.SELECTED == status || PoppupStatusEnum.USED == status) {
            param.setStatus(OperationStatus.EDIT);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7533\u62a5\u8868\u4e0d\u5b58\u5728\u5f39\u7a97\u8bbe\u7f6e\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"TaxTsateDeclareList2Plugin_26", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
            return;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_DIALOG);
        param.setCloseCallBack(closeCallBack);
        param.setFormId("tsate_dynamic_popup_qxy");
        param.getOpenStyle().setShowType(ShowType.Modal);
        customParams.put("sbbid", declareId.toString());
        param.setCustomParams(customParams);
        this.getView().showForm(param);
    }

    private DynamicObject dealTysbb(DynamicObject declare) {
        try {
            if (declare != null) {
                DynamicObject channelObj;
                DynamicObject org = declare.getDynamicObject("org");
                Date skssqq = declare.getDate("skssqq");
                Date skssqz = declare.getDate("skssqz");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
                QFilter declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0");
                String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declare);
                QFilter typeFilter = "qtsf_fsstysbb".equals(declareType) ? new QFilter("type", "=", (Object)"qtsf_tysbb") : new QFilter("type", "=", (Object)"qtsf_fsstysbb");
                QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
                QFilter delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared");
                DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{qFilter, typeFilter, skssqqzFilter, declareTypeQfilter, billstatusFilter, delcareStatusQfilter});
                if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                    String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                    if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                        return tysbDeclare;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5408\u5e76\u5904\u7406\u5931\u8d25", (String)"TaxTsateDeclareList2Plugin_27", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
        }
        return null;
    }

    private void openNotice(Long sbbid) {
        String log;
        DynamicObject declareMain = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)sbbid);
        if (declareMain == null) {
            return;
        }
        DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareMain.getString("declarestatus"));
        DynamicObject obj = TsateDeclareRecordBusiness.getRecordBySbbid((Long)sbbid, (DeclareStatusEnum)declareStatus);
        if (obj != null && kd.bos.util.StringUtils.isNotEmpty((String)(log = obj.getString("deallog")))) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("channel", this.getPageCache().get("current_channel"));
            customParams.put("nsrsbh", "");
            this.showTargetForm(obj.getLong("id"), "tsate_msg_yjbs", null, customParams, false);
            return;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4efb\u52a1\u63d0\u793a\u4fe1\u606f\uff0c\u8bf7\u5237\u65b0\u754c\u9762", (String)"TaxTsateDeclareList2Plugin_28", (String)"taxc-tsate-formplugin", (Object[])new Object[0]));
    }

    private void btnSetting(List<Long> orgIds) {
        HashMap<String, Boolean> btnConfig = new HashMap<String, Boolean>(8);
        btnConfig.put(BTN_CANCELYYJK, false);
        btnConfig.put(BTN_YYJK, false);
        btnConfig.put(BTN_REFRESH_ZWY, false);
        btnConfig.put(BTN_SZYH, false);
        btnConfig.put(BTN_UNDO, false);
        TsateCommonConfig cfg = TsateCommonConfig.getInstance();
        Map orgTopTaxOfficeIds = cfg.getTopTaxofficeId(orgIds);
        for (Map.Entry item : orgTopTaxOfficeIds.entrySet()) {
            Long orgId = (Long)item.getKey();
            Long topTaxOfficeId = (Long)item.getValue();
            Set suppliers = cfg.getAllSupplier(orgId);
            if (TAXOFFICE_ID_ZHEJIANG.equals(topTaxOfficeId) && suppliers.contains(SupplierEnum.ZWY)) {
                btnConfig.put(BTN_CANCELYYJK, true);
                btnConfig.put(BTN_YYJK, true);
            }
            if (!((Boolean)btnConfig.get(BTN_REFRESH_ZWY)).booleanValue()) {
                Set syncStatusSupports = new SyncCancelStatusServiceImpl().getSupportSuppliers();
                for (SupplierEnum itemSupplier : suppliers) {
                    if (!syncStatusSupports.contains(itemSupplier)) continue;
                    btnConfig.put(BTN_REFRESH_ZWY, true);
                    break;
                }
            }
            if (suppliers.contains(SupplierEnum.SZYH) || suppliers.contains(SupplierEnum.CLOUDCC)) {
                btnConfig.put(BTN_SZYH, true);
            }
            if (!suppliers.contains(SupplierEnum.YZF) && !suppliers.contains(SupplierEnum.GXSJ)) continue;
            btnConfig.put(BTN_UNDO, true);
        }
        HashSet hidden = new HashSet(8);
        HashSet show = new HashSet(8);
        for (Map.Entry entry : btnConfig.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) {
                show.add(entry.getKey());
                continue;
            }
            hidden.add(entry.getKey());
        }
        if (hidden.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(false), hidden.toArray(new String[0]));
        }
        if (show.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), show.toArray(new String[0]));
        }
    }

    private int cacheDialogStatus(List<Long> declareIds) {
        StringBuilder sb = new StringBuilder("|");
        Map dialogDeclareStatus = TasteDeclarePopupBusiness.querySbPopupStatus(declareIds);
        for (Map.Entry kv : dialogDeclareStatus.entrySet()) {
            Long sbbid = (Long)kv.getKey();
            PoppupStatusEnum status = (PoppupStatusEnum)kv.getValue();
            if (PoppupStatusEnum.INIT != status && PoppupStatusEnum.SELECTED != status) continue;
            sb.append(sbbid).append("|");
        }
        this.getPageCache().put("dialogstatus", sb.toString());
        return dialogDeclareStatus.size();
    }

    private boolean ifCacheExistDialogStatus(Long declareId) {
        String str = this.getPageCache().get("dialogstatus");
        if (StringUtil.isBlank((CharSequence)str)) {
            return false;
        }
        String compare = "|" + declareId + "|";
        return str.contains(compare);
    }

    private int cacheZwySpecialDialog(List<String> declareIds) {
        DynamicObject[] dyns = TsateSignInfoBusiness.queryBySbbidsDescModifytime(declareIds);
        StringBuilder sb = new StringBuilder("|");
        for (DynamicObject dyn : dyns) {
            if (EmptyCheckUtils.isEmpty((Object)dyn.getString("sjfkxx_tag"))) continue;
            String sbbid = dyn.getString("sbbid");
            sb.append(sbbid).append("|");
        }
        this.getPageCache().put("zwydialogstatus", sb.toString());
        return dyns.length;
    }

    private boolean ifCacheExistZwySpecialDialog(String declareId) {
        String sbbids = this.getPageCache().get("zwydialogstatus");
        if (StringUtil.isBlank((CharSequence)sbbids)) {
            return false;
        }
        String compare = "|" + declareId + "|";
        return sbbids.contains(compare);
    }

    private int cacheNoticeFlag(List<Long> declareList) {
        List declareIds = declareList.stream().map(id -> id + "").collect(Collectors.toList());
        List declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareList);
        if (CollectionUtils.isEmpty(declareIds)) {
            return 0;
        }
        DynamicObject[] records = TsateDeclareRecordBusiness.loadBySbbIdsAndExecuteType(declareIds, (ExecuteTypeEnums)ExecuteTypeEnums.ZLSB);
        if (records == null || records.length == 0) {
            return 0;
        }
        HashMap<String, List> recordsMap = new HashMap<String, List>(64);
        for (DynamicObject recordDyn : records) {
            String sbbid = recordDyn.getString("sbbid");
            List declareRecords = recordsMap.computeIfAbsent(sbbid, k -> new ArrayList(8));
            declareRecords.add(recordDyn);
        }
        HashMap<Long, Boolean> declareNoticeFlag = new HashMap<Long, Boolean>(64);
        for (DynamicObject declareDyn : declares) {
            List declareRecords;
            Long declareId = declareDyn.getLong("id");
            DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declareDyn.getString("declarestatus"));
            ExecuteStatusEnum executeStatus = TsateDeclareRecordBusiness.getExecuteStatusByDeclareStatus((DeclareStatusEnum)declareStatus);
            if (executeStatus == null || (declareRecords = (List)recordsMap.get(declareId + "")) == null) continue;
            DynamicObject selectRecord = null;
            for (DynamicObject filterDeclareDyn : declareRecords) {
                ExecuteTypeEnums executeType = ExecuteTypeEnums.valuesOfId((Long)filterDeclareDyn.getLong("tasktype.id"));
                if (ExecuteTypeEnums.ZLSB != executeType) continue;
                String recordStatus = filterDeclareDyn.getString("executestatus");
                Date createTime = filterDeclareDyn.getDate("createtime");
                if (!executeStatus.getCode().equals(recordStatus)) continue;
                if (selectRecord == null) {
                    selectRecord = filterDeclareDyn;
                    continue;
                }
                Date selectCreateTime = selectRecord.getDate("createtime");
                if (!selectCreateTime.before(createTime)) continue;
                selectRecord = filterDeclareDyn;
            }
            if (selectRecord != null) {
                String log = selectRecord.getString("deallog");
                declareNoticeFlag.put(declareId, StringUtil.isNotEmpty((CharSequence)log));
                continue;
            }
            declareNoticeFlag.put(declareId, false);
        }
        StringBuilder sb = new StringBuilder("|");
        for (Map.Entry item : declareNoticeFlag.entrySet()) {
            if (!((Boolean)item.getValue()).booleanValue()) continue;
            sb.append(item.getKey()).append("|");
        }
        this.getPageCache().put("noticeflag", sb.toString());
        return declareList.size();
    }

    private boolean getNoticeFlag(Long declareId) {
        String cacheIds = this.getPageCache().get("noticeflag");
        if (StringUtil.isBlank((CharSequence)cacheIds)) {
            return false;
        }
        String key = "|" + declareId + "|";
        return cacheIds.contains(key);
    }
}

